/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.server.web.OverwriteDefaultConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyServerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerConfig.class);
    public static final String GRAVITINO_SERVER_CONFIG_PREFIX = "gravitino.server.webserver.";
    private static final String SPLITTER = ",";
    public static final int DEFAULT_ICEBERG_REST_SERVICE_HTTP_PORT = 9001;
    public static final int DEFAULT_ICEBERG_REST_SERVICE_HTTPS_PORT = 9433;
    public static final int DEFAULT_GRAVITINO_WEBSERVER_HTTP_PORT = 8090;
    public static final int DEFAULT_GRAVITINO_WEBSERVER_HTTPS_PORT = 8433;
    public static final ConfigEntry<String> WEBSERVER_HOST = new ConfigBuilder("host").doc("The host name of the Jetty web server").version("0.1.0").stringConf().createWithDefault((Object)"0.0.0.0");
    public static final ConfigEntry<Integer> WEBSERVER_HTTP_PORT = new ConfigBuilder("httpPort").doc("The http port number of the Jetty web server").version("0.1.0").intConf().checkValue(value -> value >= 0, "The value must be a non-negative number").createWithDefault((Object)8090);
    public static final ConfigEntry<Integer> WEBSERVER_MIN_THREADS = new ConfigBuilder("minThreads").doc("The minimum number of threads in the thread pool used by Jetty webserver").version("0.2.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 100), 4));
    public static final ConfigEntry<Integer> WEBSERVER_MAX_THREADS = new ConfigBuilder("maxThreads").doc("The maximum number of threads in the thread pool used by Jetty webserver").version("0.1.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)Math.max(Runtime.getRuntime().availableProcessors() * 4, 400));
    public static final ConfigEntry<Long> WEBSERVER_STOP_TIMEOUT = new ConfigBuilder("stopTimeout").doc("Time in milliseconds to gracefully shutdown the Jetty webserver").version("0.2.0").longConf().checkValue(value -> value > 0L, "The value must be a positive number").createWithDefault((Object)30000L);
    public static final ConfigEntry<Integer> WEBSERVER_IDLE_TIMEOUT = new ConfigBuilder("idleTimeout").doc("The timeout in milliseconds of idle connections").version("0.2.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)30000);
    public static final ConfigEntry<Integer> WEBSERVER_REQUEST_HEADER_SIZE = new ConfigBuilder("requestHeaderSize").doc("Maximum size of HTTP requests").version("0.1.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)131072);
    public static final ConfigEntry<Integer> WEBSERVER_RESPONSE_HEADER_SIZE = new ConfigBuilder("responseHeaderSize").doc("Maximum size of HTTP responses").version("0.1.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)131072);
    public static final ConfigEntry<Integer> WEBSERVER_THREAD_POOL_WORK_QUEUE_SIZE = new ConfigBuilder("threadPoolWorkQueueSize").doc("The size of the queue in the thread pool used by Jetty webserver").version("0.1.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)100);
    public static final ConfigEntry<Boolean> ENABLE_HTTPS = new ConfigBuilder("enableHttps").doc("Enable https").version("0.3.0").booleanConf().createWithDefault((Object)false);
    public static final ConfigEntry<Integer> WEBSERVER_HTTPS_PORT = new ConfigBuilder("httpsPort").doc("The https port number of the Jetty web server").version("0.3.0").intConf().checkValue(value -> value >= 0, "The value must be a non-negative number").createWithDefault((Object)8433);
    public static final ConfigEntry<String> SSL_KEYSTORE_PATH = new ConfigBuilder("keyStorePath").doc("Path to the key store file").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SSL_KEYSTORE_PASSWORD = new ConfigBuilder("keyStorePassword").doc("Password to the key store").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SSL_MANAGER_PASSWORD = new ConfigBuilder("managerPassword").doc("Manager password to the key store").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SSL_KEYSTORE_TYPE = new ConfigBuilder("keyStoreType").doc("The type to the key store").version("0.3.0").stringConf().createWithDefault((Object)"JKS");
    public static final ConfigEntry<Optional<String>> SSL_PROTOCOL = new ConfigBuilder("tlsProtocol").doc("TLS protocol to use. The protocol must be supported by JVM").version("0.3.0").stringConf().createWithOptional();
    public static final ConfigEntry<String> ENABLE_CIPHER_ALGORITHMS = new ConfigBuilder("enableCipherAlgorithms").doc("The collection of the cipher algorithms are enabled ").version("0.3.0").stringConf().createWithDefault((Object)"");
    public static final ConfigEntry<Boolean> ENABLE_CLIENT_AUTH = new ConfigBuilder("enableClientAuth").doc("Enable the authentication of the client").version("0.3.0").booleanConf().createWithDefault((Object)false);
    public static final ConfigEntry<String> SSL_TRUST_STORE_PATH = new ConfigBuilder("trustStorePath").doc("Path to the trust store file").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SSL_TRUST_STORE_PASSWORD = new ConfigBuilder("trustStorePassword").doc("Password to the trust store").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> SSL_TRUST_STORE_TYPE = new ConfigBuilder("trustStoreType").doc("The type to the trust store").version("0.3.0").stringConf().createWithDefault((Object)"JKS");
    public static final ConfigEntry<Optional<String>> CUSTOM_FILTERS = new ConfigBuilder("customFilters").doc("Comma separated list of filter class names to apply to the APIs").version("0.4.0").stringConf().createWithOptional();
    public static final ConfigEntry<Boolean> ENABLE_CORS_FILTER = new ConfigBuilder("enableCorsFilter").doc("Enable cross origin resource share filter").version("0.4.0").booleanConf().createWithDefault((Object)false);
    public static final ConfigEntry<String> ALLOWED_ORIGINS = new ConfigBuilder("allowedOrigins").doc("A comma separated list of origins that are allowed to access the resources. Default value is *, means all origins").version("0.4.0").stringConf().createWithDefault((Object)"*");
    public static final ConfigEntry<String> ALLOWED_TIMING_ORIGINS = new ConfigBuilder("allowedTimingOrigins").doc("A comma separated list of origins that are allowed to time the resource. Default value is the empty string, means no origins.").version("0.4.0").stringConf().createWithDefault((Object)"");
    public static final ConfigEntry<String> ALLOWED_METHODS = new ConfigBuilder("allowedMethods").doc("A comma separated list of HTTP methods that are allowed to be used when accessing the resources. Default value is GET,POST,HEAD,DELETE").version("0.4.0").stringConf().createWithDefault((Object)"GET,POST,HEAD,DELETE,PUT");
    public static final ConfigEntry<String> ALLOWED_HEADERS = new ConfigBuilder("allowedHeaders").doc("A comma separated list of HTTP headers that are allowed to be specified when accessing the resources. Default value is X-Requested-With,Content-Type,Accept,Origin. If the value is a single *, this means that any headers will be accepted.").version("0.4.0").stringConf().createWithDefault((Object)"X-Requested-With,Content-Type,Accept,Origin");
    public static final ConfigEntry<Integer> PREFLIGHT_MAX_AGE_IN_SECS = new ConfigBuilder("preflightMaxAgeInSecs").doc("The number of seconds that preflight requests can be cached by the client. Default value is 1800 seconds, or 30 minutes").version("0.4.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)1800);
    public static final ConfigEntry<Boolean> ALLOW_CREDENTIALS = new ConfigBuilder("allowCredentials").doc("A boolean indicating if the resource allows requests with credentials. Default value is true").version("0.4.0").booleanConf().createWithDefault((Object)true);
    public static final ConfigEntry<String> EXPOSED_HEADERS = new ConfigBuilder("exposedHeaders").doc("A comma separated list of HTTP headers that are allowed to be exposed on the client. Default value is the empty list").version("0.4.0").stringConf().createWithDefault((Object)"");
    public static final ConfigEntry<Boolean> CHAIN_PREFLIGHT = new ConfigBuilder("chainPreflight").doc("If true preflight requests are chained to their target resource for normal handling (as an OPTION request). Otherwise the filter will response to the preflight. Default is true.").version("0.4.0").booleanConf().createWithDefault((Object)true);
    private final String host;
    private final int httpPort;
    private final int minThreads;
    private final int maxThreads;
    private final long stopTimeout;
    private final int idleTimeout;
    private final int requestHeaderSize;
    private final int responseHeaderSize;
    private final int threadPoolWorkQueueSize;
    private final int httpsPort;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String managerPassword;
    private final boolean enableHttps;
    private final String keyStoreType;
    private final Optional<String> tlsProtocol;
    private final Set<String> enableCipherAlgorithms;
    private final boolean enableClientAuth;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final Set<String> customFilters;
    private final String trustStoreType;
    private final boolean enableCorsFilter;
    private final String allowedOrigins;
    private final String allowedTimingOrigins;
    private final int preflightMaxAgeInSecs;
    private final String allowedMethods;
    private final String allowedHeaders;
    private final boolean allowCredentials;
    private final String exposedHeaders;
    private final boolean chainPreflight;
    private final Config internalConfig = new Config(false){};

    private JettyServerConfig(Map<String, String> configs) {
        this.internalConfig.loadFromMap(configs, t -> true);
        this.host = (String)this.internalConfig.get(WEBSERVER_HOST);
        this.httpPort = (Integer)this.internalConfig.get(WEBSERVER_HTTP_PORT);
        int minThreads = (Integer)this.internalConfig.get(WEBSERVER_MIN_THREADS);
        int maxThreads = (Integer)this.internalConfig.get(WEBSERVER_MAX_THREADS);
        Preconditions.checkArgument((maxThreads >= minThreads ? 1 : 0) != 0, (Object)String.format("maxThreads:%d should not less than minThreads:%d", maxThreads, minThreads));
        if (minThreads < 8) {
            LOG.info("The configuration of minThread is too small, adjust to 8");
            minThreads = 8;
        }
        if (maxThreads < 8) {
            LOG.info("The configuration of maxThread is too small, adjust to 8");
            maxThreads = 8;
        }
        this.minThreads = minThreads;
        this.maxThreads = maxThreads;
        this.stopTimeout = (Long)this.internalConfig.get(WEBSERVER_STOP_TIMEOUT);
        this.idleTimeout = (Integer)this.internalConfig.get(WEBSERVER_IDLE_TIMEOUT);
        this.requestHeaderSize = (Integer)this.internalConfig.get(WEBSERVER_REQUEST_HEADER_SIZE);
        this.responseHeaderSize = (Integer)this.internalConfig.get(WEBSERVER_RESPONSE_HEADER_SIZE);
        this.threadPoolWorkQueueSize = (Integer)this.internalConfig.get(WEBSERVER_THREAD_POOL_WORK_QUEUE_SIZE);
        this.enableHttps = (Boolean)this.internalConfig.get(ENABLE_HTTPS);
        this.httpsPort = (Integer)this.internalConfig.get(WEBSERVER_HTTPS_PORT);
        this.tlsProtocol = (Optional)this.internalConfig.get(SSL_PROTOCOL);
        this.enableCipherAlgorithms = Collections.unmodifiableSet(Sets.newHashSet((Object[])((String)this.internalConfig.get(ENABLE_CIPHER_ALGORITHMS)).split(SPLITTER)));
        this.enableClientAuth = (Boolean)this.internalConfig.get(ENABLE_CLIENT_AUTH);
        this.customFilters = ((Optional)this.internalConfig.get(CUSTOM_FILTERS)).map(filters -> Collections.unmodifiableSet(Sets.newHashSet((Object[])filters.split(SPLITTER)))).orElse(Collections.emptySet());
        this.keyStoreType = (String)this.internalConfig.get(SSL_KEYSTORE_TYPE);
        this.trustStoreType = (String)this.internalConfig.get(SSL_TRUST_STORE_TYPE);
        if (this.enableHttps) {
            this.keyStorePath = (String)this.internalConfig.get(SSL_KEYSTORE_PATH);
            this.keyStorePassword = (String)this.internalConfig.get(SSL_KEYSTORE_PASSWORD);
            this.managerPassword = (String)this.internalConfig.get(SSL_MANAGER_PASSWORD);
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
            this.managerPassword = null;
        }
        if (this.enableHttps && this.enableClientAuth) {
            this.trustStorePath = (String)this.internalConfig.get(SSL_TRUST_STORE_PATH);
            this.trustStorePassword = (String)this.internalConfig.get(SSL_TRUST_STORE_PASSWORD);
        } else {
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
        this.enableCorsFilter = (Boolean)this.internalConfig.get(ENABLE_CORS_FILTER);
        this.allowedOrigins = (String)this.internalConfig.get(ALLOWED_ORIGINS);
        this.allowedTimingOrigins = (String)this.internalConfig.get(ALLOWED_TIMING_ORIGINS);
        this.preflightMaxAgeInSecs = (Integer)this.internalConfig.get(PREFLIGHT_MAX_AGE_IN_SECS);
        this.allowedMethods = (String)this.internalConfig.get(ALLOWED_METHODS);
        this.allowedHeaders = (String)this.internalConfig.get(ALLOWED_HEADERS);
        this.allowCredentials = (Boolean)this.internalConfig.get(ALLOW_CREDENTIALS);
        this.exposedHeaders = (String)this.internalConfig.get(EXPOSED_HEADERS);
        this.chainPreflight = (Boolean)this.internalConfig.get(CHAIN_PREFLIGHT);
    }

    public static JettyServerConfig fromConfig(Config config, String prefix) {
        Map<String, String> configs = config.getConfigsWithPrefix(prefix);
        if (config instanceof OverwriteDefaultConfig) {
            configs = JettyServerConfig.overwriteJettyDefaultConfig(configs, (OverwriteDefaultConfig)config);
        }
        return new JettyServerConfig(configs);
    }

    public static JettyServerConfig fromConfig(Config config) {
        return JettyServerConfig.fromConfig(config, "");
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public int getThreadPoolWorkQueueSize() {
        return this.threadPoolWorkQueueSize;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public boolean isEnableHttps() {
        return this.enableHttps;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public Optional<String> getTlsProtocol() {
        return this.tlsProtocol;
    }

    public boolean isEnableClientAuth() {
        return this.enableClientAuth;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public Set<String> getSupportedAlgorithms() {
        if (this.enableCipherAlgorithms.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet supportedAlgorithms = Sets.newHashSet(this.enableCipherAlgorithms);
        supportedAlgorithms.retainAll(this.getSupportedCipherSuites());
        return supportedAlgorithms;
    }

    public Map<String, String> getAllWithPrefix(String prefix) {
        return this.internalConfig.getConfigsWithPrefix(prefix);
    }

    public Set<String> getCustomFilters() {
        return this.customFilters;
    }

    public boolean isEnableCorsFilter() {
        return this.enableCorsFilter;
    }

    public String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public String getAllowedTimingOrigins() {
        return this.allowedTimingOrigins;
    }

    public int getPreflightMaxAgeInSecs() {
        return this.preflightMaxAgeInSecs;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public boolean isChainPreflight() {
        return this.chainPreflight;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    private SSLContext getDefaultSSLContext() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException nsa) {
            return null;
        }
    }

    private SSLContext getSSLContextInstance(String protocol) {
        try {
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(null, null, null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    @VisibleForTesting
    Set<String> getSupportedCipherSuites() {
        SSLContext context = this.tlsProtocol.map(this::getSSLContextInstance).orElseGet(this::getDefaultSSLContext);
        if (context == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])context.getServerSocketFactory().getSupportedCipherSuites());
    }

    private static Map<String, String> overwriteJettyDefaultConfig(Map<String, String> properties, OverwriteDefaultConfig config) {
        if (config.getOverwriteDefaultConfig().isEmpty()) {
            return properties;
        }
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        config.getOverwriteDefaultConfig().forEach((k, v) -> newProperties.putIfAbsent((String)k, (String)v));
        return newProperties;
    }
}

