/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.ref;

import java.util.EnumSet;

public interface Reference<T, A> {
    public T get();

    public A getAttachment();

    public void clear();

    public Type getType();

    public static enum Type {
        STRONG,
        WEAK,
        PHANTOM,
        SOFT,
        NULL;

        private static final int fullSize;

        public static boolean isFull(EnumSet<Type> set) {
            return set != null && set.size() == fullSize;
        }

        public boolean in(Type v1) {
            return this == v1;
        }

        public boolean in(Type v1, Type v2) {
            return this == v1 || this == v2;
        }

        public boolean in(Type v1, Type v2, Type v3) {
            return this == v1 || this == v2 || this == v3;
        }

        public boolean in(Type ... values) {
            if (values != null) {
                for (Type value : values) {
                    if (this != value) continue;
                    return true;
                }
            }
            return false;
        }

        static {
            fullSize = Type.values().length;
        }
    }
}

