/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface TableMetaMapper {
    public static final String TABLE_NAME = "table_meta";

    @Select(value={"SELECT table_id as tableId, table_name as tableName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM table_meta WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public List<TablePO> listTablePOsBySchemaId(@Param(value="schemaId") Long var1);

    @Select(value={"SELECT table_id as tableId FROM table_meta WHERE schema_id = #{schemaId} AND table_name = #{tableName} AND deleted_at = 0"})
    public Long selectTableIdBySchemaIdAndName(@Param(value="schemaId") Long var1, @Param(value="tableName") String var2);

    @Select(value={"SELECT table_id as tableId, table_name as tableName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM table_meta WHERE schema_id = #{schemaId} AND table_name = #{tableName} AND deleted_at = 0"})
    public TablePO selectTableMetaBySchemaIdAndName(@Param(value="schemaId") Long var1, @Param(value="tableName") String var2);

    @Select(value={"SELECT table_id as tableId, table_name as tableName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM table_meta WHERE table_id = #{tableId} AND deleted_at = 0"})
    public TablePO selectTableMetaById(@Param(value="tableId") Long var1);

    @Insert(value={"INSERT INTO table_meta(table_id, table_name, metalake_id, catalog_id, schema_id, audit_info, current_version, last_version, deleted_at) VALUES( #{tableMeta.tableId}, #{tableMeta.tableName}, #{tableMeta.metalakeId}, #{tableMeta.catalogId}, #{tableMeta.schemaId}, #{tableMeta.auditInfo}, #{tableMeta.currentVersion}, #{tableMeta.lastVersion}, #{tableMeta.deletedAt} )"})
    public void insertTableMeta(@Param(value="tableMeta") TablePO var1);

    @Insert(value={"INSERT INTO table_meta(table_id, table_name, metalake_id, catalog_id, schema_id, audit_info, current_version, last_version, deleted_at) VALUES( #{tableMeta.tableId}, #{tableMeta.tableName}, #{tableMeta.metalakeId}, #{tableMeta.catalogId}, #{tableMeta.schemaId}, #{tableMeta.auditInfo}, #{tableMeta.currentVersion}, #{tableMeta.lastVersion}, #{tableMeta.deletedAt} ) ON DUPLICATE KEY UPDATE table_name = #{tableMeta.tableName}, metalake_id = #{tableMeta.metalakeId}, catalog_id = #{tableMeta.catalogId}, schema_id = #{tableMeta.schemaId}, audit_info = #{tableMeta.auditInfo}, current_version = #{tableMeta.currentVersion}, last_version = #{tableMeta.lastVersion}, deleted_at = #{tableMeta.deletedAt}"})
    public void insertTableMetaOnDuplicateKeyUpdate(@Param(value="tableMeta") TablePO var1);

    @Update(value={"UPDATE table_meta SET table_name = #{newTableMeta.tableName}, metalake_id = #{newTableMeta.metalakeId}, catalog_id = #{newTableMeta.catalogId}, schema_id = #{newTableMeta.schemaId}, audit_info = #{newTableMeta.auditInfo}, current_version = #{newTableMeta.currentVersion}, last_version = #{newTableMeta.lastVersion}, deleted_at = #{newTableMeta.deletedAt} WHERE table_id = #{oldTableMeta.tableId} AND table_name = #{oldTableMeta.tableName} AND metalake_id = #{oldTableMeta.metalakeId} AND catalog_id = #{oldTableMeta.catalogId} AND schema_id = #{oldTableMeta.schemaId} AND audit_info = #{oldTableMeta.auditInfo} AND current_version = #{oldTableMeta.currentVersion} AND last_version = #{oldTableMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateTableMeta(@Param(value="newTableMeta") TablePO var1, @Param(value="oldTableMeta") TablePO var2);

    @Update(value={"UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE table_id = #{tableId} AND deleted_at = 0"})
    public Integer softDeleteTableMetasByTableId(@Param(value="tableId") Long var1);

    @Update(value={"UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public Integer softDeleteTableMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public Integer softDeleteTableMetasByCatalogId(@Param(value="catalogId") Long var1);

    @Update(value={"UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public Integer softDeleteTableMetasBySchemaId(@Param(value="schemaId") Long var1);

    @Delete(value={"DELETE FROM table_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteTableMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

