/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.FilesetMaxVersionPO;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface FilesetVersionMapper {
    public static final String VERSION_TABLE_NAME = "fileset_version_info";

    @Insert(value={"INSERT INTO fileset_version_info(metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location, deleted_at) VALUES( #{filesetVersion.metalakeId}, #{filesetVersion.catalogId}, #{filesetVersion.schemaId}, #{filesetVersion.filesetId}, #{filesetVersion.version}, #{filesetVersion.filesetComment}, #{filesetVersion.properties}, #{filesetVersion.storageLocation}, #{filesetVersion.deletedAt} )"})
    public void insertFilesetVersion(@Param(value="filesetVersion") FilesetVersionPO var1);

    @Insert(value={"INSERT INTO fileset_version_info(metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location, deleted_at) VALUES( #{filesetVersion.metalakeId}, #{filesetVersion.catalogId}, #{filesetVersion.schemaId}, #{filesetVersion.filesetId}, #{filesetVersion.version}, #{filesetVersion.filesetComment}, #{filesetVersion.properties}, #{filesetVersion.storageLocation}, #{filesetVersion.deletedAt} ) ON DUPLICATE KEY UPDATE metalake_id = #{filesetVersion.metalakeId}, catalog_id = #{filesetVersion.catalogId}, schema_id = #{filesetVersion.schemaId}, fileset_id = #{filesetVersion.filesetId}, version = #{filesetVersion.version}, fileset_comment = #{filesetVersion.filesetComment}, properties = #{filesetVersion.properties}, storage_location = #{filesetVersion.storageLocation}, deleted_at = #{filesetVersion.deletedAt}"})
    public void insertFilesetVersionOnDuplicateKeyUpdate(@Param(value="filesetVersion") FilesetVersionPO var1);

    @Update(value={"UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public Integer softDeleteFilesetVersionsByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public Integer softDeleteFilesetVersionsByCatalogId(@Param(value="catalogId") Long var1);

    @Update(value={"UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public Integer softDeleteFilesetVersionsBySchemaId(@Param(value="schemaId") Long var1);

    @Update(value={"UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND deleted_at = 0"})
    public Integer softDeleteFilesetVersionsByFilesetId(@Param(value="filesetId") Long var1);

    @Delete(value={"DELETE FROM fileset_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteFilesetVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);

    @Select(value={"SELECT fileset_id as filesetId, Max(version) as version FROM fileset_version_info WHERE version > #{versionRetentionCount} AND deleted_at = 0 GROUP BY fileset_id"})
    public List<FilesetMaxVersionPO> selectFilesetVersionsByRetentionCount(@Param(value="versionRetentionCount") Long var1);

    @Update(value={"UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND version <= #{versionRetentionLine} AND deleted_at = 0 LIMIT #{limit}"})
    public Integer softDeleteFilesetVersionsByRetentionLine(@Param(value="filesetId") Long var1, @Param(value="versionRetentionLine") long var2, @Param(value="limit") int var4);
}

