/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface FilesetMetaMapper {
    public static final String META_TABLE_NAME = "fileset_meta";
    public static final String VERSION_TABLE_NAME = "fileset_version_info";

    @Select(value={"SELECT fm.fileset_id, fm.fileset_name, fm.metalake_id, fm.catalog_id, fm.schema_id, fm.type, fm.audit_info, fm.current_version, fm.last_version, fm.deleted_at, vi.id, vi.metalake_id as version_metalake_id, vi.catalog_id as version_catalog_id, vi.schema_id as version_schema_id, vi.fileset_id as version_fileset_id, vi.version, vi.fileset_comment, vi.properties, vi.storage_location, vi.deleted_at as version_deleted_at FROM fileset_meta fm INNER JOIN fileset_version_info vi ON fm.fileset_id = vi.fileset_id AND fm.current_version = vi.version WHERE fm.schema_id = #{schemaId} AND fm.deleted_at = 0 AND vi.deleted_at = 0"})
    @Results(value={@Result(property="filesetId", column="fileset_id"), @Result(property="filesetName", column="fileset_name"), @Result(property="metalakeId", column="metalake_id"), @Result(property="catalogId", column="catalog_id"), @Result(property="schemaId", column="schema_id"), @Result(property="type", column="type"), @Result(property="auditInfo", column="audit_info"), @Result(property="currentVersion", column="current_version"), @Result(property="lastVersion", column="last_version"), @Result(property="deletedAt", column="deleted_at"), @Result(property="filesetVersionPO.id", column="id"), @Result(property="filesetVersionPO.metalakeId", column="version_metalake_id"), @Result(property="filesetVersionPO.catalogId", column="version_catalog_id"), @Result(property="filesetVersionPO.schemaId", column="version_schema_id"), @Result(property="filesetVersionPO.filesetId", column="version_fileset_id"), @Result(property="filesetVersionPO.version", column="version"), @Result(property="filesetVersionPO.filesetComment", column="fileset_comment"), @Result(property="filesetVersionPO.properties", column="properties"), @Result(property="filesetVersionPO.storageLocation", column="storage_location"), @Result(property="filesetVersionPO.deletedAt", column="version_deleted_at")})
    public List<FilesetPO> listFilesetPOsBySchemaId(@Param(value="schemaId") Long var1);

    @Select(value={"SELECT fileset_id as filesetId FROM fileset_meta WHERE schema_id = #{schemaId} AND fileset_name = #{filesetName} AND deleted_at = 0"})
    public Long selectFilesetIdBySchemaIdAndName(@Param(value="schemaId") Long var1, @Param(value="filesetName") String var2);

    @Select(value={"SELECT fm.fileset_id, fm.fileset_name, fm.metalake_id, fm.catalog_id, fm.schema_id, fm.type, fm.audit_info, fm.current_version, fm.last_version, fm.deleted_at, vi.id, vi.metalake_id as version_metalake_id, vi.catalog_id as version_catalog_id, vi.schema_id as version_schema_id, vi.fileset_id as version_fileset_id, vi.version, vi.fileset_comment, vi.properties, vi.storage_location, vi.deleted_at as version_deleted_at FROM fileset_meta fm INNER JOIN fileset_version_info vi ON fm.fileset_id = vi.fileset_id AND fm.current_version = vi.version WHERE fm.schema_id = #{schemaId} AND fm.fileset_name = #{filesetName} AND fm.deleted_at = 0 AND vi.deleted_at = 0"})
    @Results(value={@Result(property="filesetId", column="fileset_id"), @Result(property="filesetName", column="fileset_name"), @Result(property="metalakeId", column="metalake_id"), @Result(property="catalogId", column="catalog_id"), @Result(property="schemaId", column="schema_id"), @Result(property="type", column="type"), @Result(property="auditInfo", column="audit_info"), @Result(property="currentVersion", column="current_version"), @Result(property="lastVersion", column="last_version"), @Result(property="deletedAt", column="deleted_at"), @Result(property="filesetVersionPO.id", column="id"), @Result(property="filesetVersionPO.metalakeId", column="version_metalake_id"), @Result(property="filesetVersionPO.catalogId", column="version_catalog_id"), @Result(property="filesetVersionPO.schemaId", column="version_schema_id"), @Result(property="filesetVersionPO.filesetId", column="version_fileset_id"), @Result(property="filesetVersionPO.version", column="version"), @Result(property="filesetVersionPO.filesetComment", column="fileset_comment"), @Result(property="filesetVersionPO.properties", column="properties"), @Result(property="filesetVersionPO.storageLocation", column="storage_location"), @Result(property="filesetVersionPO.deletedAt", column="version_deleted_at")})
    public FilesetPO selectFilesetMetaBySchemaIdAndName(@Param(value="schemaId") Long var1, @Param(value="filesetName") String var2);

    @Select(value={"SELECT fm.fileset_id, fm.fileset_name, fm.metalake_id, fm.catalog_id, fm.schema_id, fm.type, fm.audit_info, fm.current_version, fm.last_version, fm.deleted_at, vi.id, vi.metalake_id as version_metalake_id, vi.catalog_id as version_catalog_id, vi.schema_id as version_schema_id, vi.fileset_id as version_fileset_id, vi.version, vi.fileset_comment, vi.properties, vi.storage_location, vi.deleted_at as version_deleted_at FROM fileset_meta fm INNER JOIN fileset_version_info vi ON fm.fileset_id = vi.fileset_id AND fm.current_version = vi.version WHERE fm.fileset_id = #{filesetId} AND fm.deleted_at = 0 AND vi.deleted_at = 0"})
    @Results(value={@Result(property="filesetId", column="fileset_id"), @Result(property="filesetName", column="fileset_name"), @Result(property="metalakeId", column="metalake_id"), @Result(property="catalogId", column="catalog_id"), @Result(property="schemaId", column="schema_id"), @Result(property="type", column="type"), @Result(property="auditInfo", column="audit_info"), @Result(property="currentVersion", column="current_version"), @Result(property="lastVersion", column="last_version"), @Result(property="deletedAt", column="deleted_at"), @Result(property="filesetVersionPO.id", column="id"), @Result(property="filesetVersionPO.metalakeId", column="version_metalake_id"), @Result(property="filesetVersionPO.catalogId", column="version_catalog_id"), @Result(property="filesetVersionPO.schemaId", column="version_schema_id"), @Result(property="filesetVersionPO.filesetId", column="version_fileset_id"), @Result(property="filesetVersionPO.version", column="version"), @Result(property="filesetVersionPO.filesetComment", column="fileset_comment"), @Result(property="filesetVersionPO.properties", column="properties"), @Result(property="filesetVersionPO.storageLocation", column="storage_location"), @Result(property="filesetVersionPO.deletedAt", column="version_deleted_at")})
    public FilesetPO selectFilesetMetaById(@Param(value="filesetId") Long var1);

    @Insert(value={"INSERT INTO fileset_meta(fileset_id, fileset_name, metalake_id, catalog_id, schema_id, type, audit_info, current_version, last_version, deleted_at) VALUES( #{filesetMeta.filesetId}, #{filesetMeta.filesetName}, #{filesetMeta.metalakeId}, #{filesetMeta.catalogId}, #{filesetMeta.schemaId}, #{filesetMeta.type}, #{filesetMeta.auditInfo}, #{filesetMeta.currentVersion}, #{filesetMeta.lastVersion}, #{filesetMeta.deletedAt} )"})
    public void insertFilesetMeta(@Param(value="filesetMeta") FilesetPO var1);

    @Insert(value={"INSERT INTO fileset_meta(fileset_id, fileset_name, metalake_id, catalog_id, schema_id, type, audit_info, current_version, last_version, deleted_at) VALUES( #{filesetMeta.filesetId}, #{filesetMeta.filesetName}, #{filesetMeta.metalakeId}, #{filesetMeta.catalogId}, #{filesetMeta.schemaId}, #{filesetMeta.type}, #{filesetMeta.auditInfo}, #{filesetMeta.currentVersion}, #{filesetMeta.lastVersion}, #{filesetMeta.deletedAt} ) ON DUPLICATE KEY UPDATE fileset_name = #{filesetMeta.filesetName}, metalake_id = #{filesetMeta.metalakeId}, catalog_id = #{filesetMeta.catalogId}, schema_id = #{filesetMeta.schemaId}, type = #{filesetMeta.type}, audit_info = #{filesetMeta.auditInfo}, current_version = #{filesetMeta.currentVersion}, last_version = #{filesetMeta.lastVersion}, deleted_at = #{filesetMeta.deletedAt}"})
    public void insertFilesetMetaOnDuplicateKeyUpdate(@Param(value="filesetMeta") FilesetPO var1);

    @Update(value={"UPDATE fileset_meta SET fileset_name = #{newFilesetMeta.filesetName}, metalake_id = #{newFilesetMeta.metalakeId}, catalog_id = #{newFilesetMeta.catalogId}, schema_id = #{newFilesetMeta.schemaId}, type = #{newFilesetMeta.type}, audit_info = #{newFilesetMeta.auditInfo}, current_version = #{newFilesetMeta.currentVersion}, last_version = #{newFilesetMeta.lastVersion}, deleted_at = #{newFilesetMeta.deletedAt} WHERE fileset_id = #{oldFilesetMeta.filesetId} AND fileset_name = #{oldFilesetMeta.filesetName} AND metalake_id = #{oldFilesetMeta.metalakeId} AND catalog_id = #{oldFilesetMeta.catalogId} AND schema_id = #{oldFilesetMeta.schemaId} AND type = #{oldFilesetMeta.type} AND audit_info = #{oldFilesetMeta.auditInfo} AND current_version = #{oldFilesetMeta.currentVersion} AND last_version = #{oldFilesetMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateFilesetMeta(@Param(value="newFilesetMeta") FilesetPO var1, @Param(value="oldFilesetMeta") FilesetPO var2);

    @Update(value={"UPDATE fileset_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public Integer softDeleteFilesetMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE fileset_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public Integer softDeleteFilesetMetasByCatalogId(@Param(value="catalogId") Long var1);

    @Update(value={"UPDATE fileset_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public Integer softDeleteFilesetMetasBySchemaId(@Param(value="schemaId") Long var1);

    @Update(value={"UPDATE fileset_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND deleted_at = 0"})
    public Integer softDeleteFilesetMetasByFilesetId(@Param(value="filesetId") Long var1);

    @Delete(value={"DELETE FROM fileset_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteFilesetMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

