/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.gravitino.Config;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.tag.SupportsTagOperations;

public interface RelationalBackend
extends Closeable,
SupportsTagOperations,
SupportsRelationOperations {
    public void initialize(Config var1);

    public <E extends Entity & HasIdentifier> List<E> list(Namespace var1, Entity.EntityType var2) throws NoSuchEntityException, IOException;

    public boolean exists(NameIdentifier var1, Entity.EntityType var2) throws IOException;

    public <E extends Entity & HasIdentifier> void insert(E var1, boolean var2) throws EntityAlreadyExistsException, IOException;

    public <E extends Entity & HasIdentifier> E update(NameIdentifier var1, Entity.EntityType var2, Function<E, E> var3) throws IOException, NoSuchEntityException;

    public <E extends Entity & HasIdentifier> E get(NameIdentifier var1, Entity.EntityType var2) throws IOException;

    public boolean delete(NameIdentifier var1, Entity.EntityType var2, boolean var3) throws IOException;

    public int hardDeleteLegacyData(Entity.EntityType var1, long var2) throws IOException;

    public int deleteOldVersionData(Entity.EntityType var1, long var2) throws IOException;
}

