/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterTopicEvent;
import org.apache.gravitino.listener.api.event.AlterTopicFailureEvent;
import org.apache.gravitino.listener.api.event.CreateTopicEvent;
import org.apache.gravitino.listener.api.event.CreateTopicFailureEvent;
import org.apache.gravitino.listener.api.event.DropTopicEvent;
import org.apache.gravitino.listener.api.event.DropTopicFailureEvent;
import org.apache.gravitino.listener.api.event.ListTopicEvent;
import org.apache.gravitino.listener.api.event.ListTopicFailureEvent;
import org.apache.gravitino.listener.api.event.LoadTopicEvent;
import org.apache.gravitino.listener.api.event.LoadTopicFailureEvent;
import org.apache.gravitino.listener.api.info.TopicInfo;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.utils.PrincipalUtils;

public class TopicEventDispatcher
implements TopicDispatcher {
    private final EventBus eventBus;
    private final TopicDispatcher dispatcher;

    public TopicEventDispatcher(EventBus eventBus, TopicDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    public Topic alterTopic(NameIdentifier ident, TopicChange ... changes) throws NoSuchTopicException, IllegalArgumentException {
        try {
            Topic topic = this.dispatcher.alterTopic(ident, changes);
            this.eventBus.dispatchEvent(new AlterTopicEvent(PrincipalUtils.getCurrentUserName(), ident, changes, new TopicInfo(topic)));
            return topic;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterTopicFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, changes));
            throw e;
        }
    }

    public boolean dropTopic(NameIdentifier ident) {
        try {
            boolean isExists = this.dispatcher.dropTopic(ident);
            this.eventBus.dispatchEvent(new DropTopicEvent(PrincipalUtils.getCurrentUserName(), ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropTopicFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public NameIdentifier[] listTopics(Namespace namespace) throws NoSuchTopicException {
        try {
            NameIdentifier[] nameIdentifiers = this.dispatcher.listTopics(namespace);
            this.eventBus.dispatchEvent(new ListTopicEvent(PrincipalUtils.getCurrentUserName(), namespace));
            return nameIdentifiers;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListTopicFailureEvent(PrincipalUtils.getCurrentUserName(), namespace, e));
            throw e;
        }
    }

    public Topic loadTopic(NameIdentifier ident) throws NoSuchTopicException {
        try {
            Topic topic = this.dispatcher.loadTopic(ident);
            this.eventBus.dispatchEvent(new LoadTopicEvent(PrincipalUtils.getCurrentUserName(), ident, new TopicInfo(topic)));
            return topic;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LoadTopicFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public boolean topicExists(NameIdentifier ident) {
        return this.dispatcher.topicExists(ident);
    }

    public Topic createTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) throws NoSuchTopicException, TopicAlreadyExistsException {
        try {
            Topic topic = this.dispatcher.createTopic(ident, comment, dataLayout, properties);
            this.eventBus.dispatchEvent(new CreateTopicEvent(PrincipalUtils.getCurrentUserName(), ident, new TopicInfo(topic)));
            return topic;
        }
        catch (Exception e) {
            TopicInfo createTopicRequest = new TopicInfo(ident.name(), comment, properties, null);
            this.eventBus.dispatchEvent(new CreateTopicFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, createTopicRequest));
            throw e;
        }
    }
}

