/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.request;

import java.io.File;
import java.io.IOException;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.ccache.Credential;
import org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.preauth.KrbFastRequestState;
import org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.common.CheckSumUtil;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.crypto.fast.FastUtil;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.ap.ApOptions;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.fast.ArmorType;
import org.apache.kerby.kerberos.kerb.type.fast.KrbFastArmor;
import org.apache.kerby.kerberos.kerb.type.fast.KrbFastArmoredReq;
import org.apache.kerby.kerberos.kerb.type.fast.KrbFastReq;
import org.apache.kerby.kerberos.kerb.type.fast.PaFxFastRequest;
import org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;

public class ArmoredRequest {
    private Credential credential;
    private EncryptionKey subKey;
    private EncryptionKey armorCacheKey;
    private KdcRequest kdcRequest;

    public ArmoredRequest(KdcRequest kdcRequest) {
        this.kdcRequest = kdcRequest;
    }

    public void process() throws KrbException {
        KdcReq kdcReq = this.kdcRequest.getKdcReq();
        KrbFastRequestState state = this.kdcRequest.getFastRequestState();
        this.fastAsArmor(state, this.kdcRequest.getArmorKey(), this.subKey, this.credential, kdcReq);
        this.kdcRequest.setFastRequestState(state);
        this.kdcRequest.setOuterRequestBody(KrbCodec.encode((Asn1Type)state.getFastOuterRequest().getReqBody()));
        kdcReq.getPaData().addElement((Asn1Type)this.makeFastEntry(state, kdcReq, this.kdcRequest.getOuterRequestBody()));
    }

    protected void preauth() throws KrbException {
        KOptions preauthOptions = this.getPreauthOptions();
        this.getCredential(preauthOptions);
        this.armorCacheKey = this.getArmorCacheKey(this.credential);
        this.subKey = this.getSubKey(this.armorCacheKey.getKeyType());
        EncryptionKey armorKey = this.makeArmorKey(this.subKey, this.armorCacheKey);
        this.kdcRequest.getFastRequestState().setArmorKey(armorKey);
    }

    private void getCredential(KOptions kOptions) throws KrbException {
        if (kOptions.contains((KOption)KrbOption.ARMOR_CACHE)) {
            String ccache = kOptions.getStringOption((KOption)KrbOption.ARMOR_CACHE);
            this.credential = this.getCredentialFromFile(ccache);
        } else if (kOptions.contains((KOption)KrbOption.TGT)) {
            TgtTicket tgt = (TgtTicket)kOptions.getOptionValue((KOption)KrbOption.TGT);
            this.credential = new Credential(tgt);
        }
    }

    public KOptions getPreauthOptions() {
        KOptions results = new KOptions();
        KOptions krbOptions = this.kdcRequest.getRequestOptions();
        if (krbOptions.contains((KOption)KrbOption.ARMOR_CACHE)) {
            results.add(krbOptions.getOption((KOption)KrbOption.ARMOR_CACHE));
        } else if (krbOptions.contains((KOption)KrbOption.TGT)) {
            results.add(krbOptions.getOption((KOption)KrbOption.TGT));
        }
        return results;
    }

    public EncryptionKey getClientKey() throws KrbException {
        return this.kdcRequest.getFastRequestState().getArmorKey();
    }

    public EncryptionKey getArmorCacheKey() {
        return this.armorCacheKey;
    }

    private Credential getCredentialFromFile(String ccache) throws KrbException {
        File ccacheFile = new File(ccache);
        CredentialCache cc = null;
        try {
            cc = ArmoredRequest.resolveCredCache(ccacheFile);
        }
        catch (IOException e) {
            throw new KrbException("Failed to load armor cache file");
        }
        return (Credential)cc.getCredentials().iterator().next();
    }

    private static CredentialCache resolveCredCache(File ccacheFile) throws IOException {
        CredentialCache cc = new CredentialCache();
        cc.load(ccacheFile);
        return cc;
    }

    private void fastAsArmor(KrbFastRequestState state, EncryptionKey armorKey, EncryptionKey subKey, Credential credential, KdcReq kdcReq) throws KrbException {
        state.setArmorKey(armorKey);
        state.setFastArmor(this.fastArmorApRequest(subKey, credential));
        AsReq fastOuterRequest = new AsReq();
        fastOuterRequest.setReqBody(kdcReq.getReqBody());
        fastOuterRequest.setPaData(null);
        state.setFastOuterRequest((KdcReq)fastOuterRequest);
    }

    private PaDataEntry makeFastEntry(KrbFastRequestState state, KdcReq kdcReq, byte[] outerRequestBody) throws KrbException {
        KrbFastReq fastReq = new KrbFastReq();
        fastReq.setKdcReqBody(kdcReq.getReqBody());
        fastReq.setFastOptions(state.getFastOptions());
        PaFxFastRequest paFxFastRequest = new PaFxFastRequest();
        KrbFastArmoredReq armoredReq = new KrbFastArmoredReq();
        armoredReq.setArmor(state.getFastArmor());
        CheckSum reqCheckSum = CheckSumUtil.makeCheckSumWithKey((CheckSumType)CheckSumType.NONE, (byte[])outerRequestBody, (EncryptionKey)state.getArmorKey(), (KeyUsage)KeyUsage.FAST_REQ_CHKSUM);
        armoredReq.setReqChecksum(reqCheckSum);
        armoredReq.setEncryptedFastReq(EncryptionUtil.seal((Asn1Encodeable)fastReq, (EncryptionKey)state.getArmorKey(), (KeyUsage)KeyUsage.FAST_ENC));
        paFxFastRequest.setFastArmoredReq(armoredReq);
        PaDataEntry paDataEntry = new PaDataEntry();
        paDataEntry.setPaDataType(PaDataType.FX_FAST);
        paDataEntry.setPaDataValue(KrbCodec.encode((Asn1Type)paFxFastRequest));
        return paDataEntry;
    }

    private KrbFastArmor fastArmorApRequest(EncryptionKey subKey, Credential credential) throws KrbException {
        KrbFastArmor fastArmor = new KrbFastArmor();
        fastArmor.setArmorType(ArmorType.ARMOR_AP_REQUEST);
        ApReq apReq = this.makeApReq(subKey, credential);
        fastArmor.setArmorValue(KrbCodec.encode((Asn1Type)apReq));
        return fastArmor;
    }

    private ApReq makeApReq(EncryptionKey subKey, Credential credential) throws KrbException {
        ApReq apReq = new ApReq();
        ApOptions apOptions = new ApOptions();
        apReq.setApOptions(apOptions);
        Ticket ticket = credential.getTicket();
        apReq.setTicket(ticket);
        Authenticator authenticator = this.makeAuthenticator(credential, subKey);
        apReq.setAuthenticator(authenticator);
        EncryptedData authnData = EncryptionUtil.seal((Asn1Encodeable)authenticator, (EncryptionKey)credential.getKey(), (KeyUsage)KeyUsage.AP_REQ_AUTH);
        apReq.setEncryptedAuthenticator(authnData);
        return apReq;
    }

    private EncryptionKey makeArmorKey(EncryptionKey subKey, EncryptionKey armorCacheKey) throws KrbException {
        EncryptionKey armorKey = FastUtil.makeArmorKey((EncryptionKey)subKey, (EncryptionKey)armorCacheKey);
        return armorKey;
    }

    private EncryptionKey getSubKey(EncryptionType type) throws KrbException {
        return EncryptionHandler.random2Key((EncryptionType)type);
    }

    private EncryptionKey getArmorCacheKey(Credential credential) throws KrbException {
        EncryptionKey armorCacheKey = credential.getKey();
        return armorCacheKey;
    }

    protected Authenticator makeAuthenticator(Credential credential, EncryptionKey subKey) throws KrbException {
        Authenticator authenticator = new Authenticator();
        authenticator.setAuthenticatorVno(5);
        authenticator.setCname(credential.getClientName());
        authenticator.setCrealm(credential.getClientRealm());
        authenticator.setCtime(KerberosTime.now());
        authenticator.setCusec(0);
        authenticator.setSubKey(subKey);
        KdcReqBody reqBody = this.kdcRequest.getReqBody(null);
        CheckSum checksum = CheckSumUtil.seal((Asn1Encodeable)reqBody, null, (EncryptionKey)subKey, (KeyUsage)KeyUsage.TGS_REQ_AUTH_CKSUM);
        authenticator.setCksum(checksum);
        return authenticator;
    }
}

