/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class ApplyNameMapping
extends AvroSchemaVisitor<Schema> {
    private final NameMapping nameMapping;

    public ApplyNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    @Override
    public Schema record(Schema record, List<String> names, List<Schema> fields) {
        List originalFields = record.getFields();
        ArrayList newFields = Lists.newArrayList();
        boolean hasChange = false;
        for (int i = 0; i < originalFields.size(); ++i) {
            Schema newSchema = fields.get(i);
            Schema.Field field = (Schema.Field)originalFields.get(i);
            Integer fieldId = AvroSchemaUtil.getFieldId(field, this.nameMapping, this.fieldNames());
            if (newSchema != null && fieldId != null) {
                newFields.add(ApplyNameMapping.copyField(field, newSchema, fieldId));
                hasChange = true;
                continue;
            }
            newFields.add(ApplyNameMapping.copyField(field, field.schema(), null));
        }
        if (!hasChange) {
            return record;
        }
        return this.copyRecord(record, newFields);
    }

    @Override
    public Schema union(Schema union, List<Schema> options) {
        if (options.equals(union.getTypes())) {
            return union;
        }
        List validOptions = options.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return this.copyProps(union, Schema.createUnion(validOptions));
    }

    @Override
    public Schema array(Schema array, Schema element) {
        if (array.getLogicalType() instanceof LogicalMap || this.isKeyValueMapping(this.fieldNames()) && AvroSchemaUtil.isKeyValueSchema(array.getElementType())) {
            return this.copyProps(array, Schema.createArray((Schema)element));
        }
        Integer elementId = AvroSchemaUtil.elementId(array);
        if (elementId != null) {
            if (array.getElementType().equals((Object)element)) {
                return array;
            }
            return this.copyProps(array, this.createArray(element, elementId));
        }
        MappedField mapping = this.nameMapping.find(this.fieldNames(), "element");
        if (mapping != null) {
            return this.copyProps(array, this.createArray(element, mapping.id()));
        }
        return array;
    }

    private boolean isKeyValueMapping(Iterable<String> names) {
        return this.nameMapping.find(names, "key") != null && this.nameMapping.find(names, "value") != null;
    }

    @Override
    public Schema map(Schema map, Schema value) {
        Integer keyId = AvroSchemaUtil.keyId(map);
        Integer valueId = AvroSchemaUtil.valueId(map);
        if (keyId != null && valueId != null) {
            if (map.getValueType().equals((Object)value)) {
                return map;
            }
            return this.copyProps(map, this.createMap(value, keyId, valueId));
        }
        MappedField keyMapping = this.nameMapping.find(this.fieldNames(), "key");
        MappedField valueMapping = this.nameMapping.find(this.fieldNames(), "value");
        if (keyMapping != null && valueMapping != null) {
            return this.copyProps(map, this.createMap(value, keyMapping.id(), valueMapping.id()));
        }
        return map;
    }

    @Override
    public Schema primitive(Schema primitive) {
        return primitive;
    }

    private Schema copyRecord(Schema record, List<Schema.Field> newFields) {
        Schema copy = Schema.createRecord((String)record.getName(), (String)record.getDoc(), (String)record.getNamespace(), (boolean)record.isError(), newFields);
        this.copyProps(record, copy);
        return copy;
    }

    static Schema.Field copyField(Schema.Field field, Schema newSchema, Integer fieldId) {
        Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry prop : field.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        if (fieldId != null) {
            copy.addProp("field-id", (Object)fieldId);
        }
        for (String alias : field.aliases()) {
            copy.addAlias(alias);
        }
        return copy;
    }

    private Schema createMap(Schema value, int keyId, int valueId) {
        Schema result = Schema.createMap((Schema)value);
        result.addProp("key-id", (Object)keyId);
        result.addProp("value-id", (Object)valueId);
        return result;
    }

    private Schema createArray(Schema element, int elementId) {
        Schema result = Schema.createArray((Schema)element);
        result.addProp("element-id", (Object)elementId);
        return result;
    }

    private Schema copyProps(Schema from, Schema copy) {
        for (Map.Entry prop : from.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        LogicalType logicalType = from.getLogicalType();
        if (logicalType != null) {
            logicalType.addToSchema(copy);
        }
        return copy;
    }
}

