create schema bfv_catalog;
set search_path=bfv_catalog;

-- count number of certain operators in a given plan
-- start_ignore
create language plpython3u;
-- end_ignore

create or replace function count_operator(query text, operator text) returns int as
$$
rv = plpy.execute('EXPLAIN ' + query)
search_text = operator
result = 0
for i in range(len(rv)):
    cur_line = rv[i]['QUERY PLAN']
    if search_text.lower() in cur_line.lower():
        result = result+1
return result
$$
language plpython3u;

--
-- Testing queries with subqueries with nested scalar functions
-- 

create table q68t792_temp(u_vtgnr varchar(6), u_zj varchar(2), u_folio varchar(2));
insert into q68t792_temp select x ||'1' , x || '', x || '' from generate_series(30,99) x;

SELECT  u_vtgnr, u_zj, u_folio                                                                                                                                 
FROM  q68t792_temp a  
WHERE 
u_zj = 
(SELECT substr(max(case when cast(u_zj as integer) < 50 then '20' || u_zj else '19' || u_zj end),3,2) 
 FROM q68t792_temp b WHERE a.u_vtgnr = b.u_vtgnr) 
AND u_folio = (SELECT max(u_folio)  FROM q68t792_temp c WHERE a.u_vtgnr = c.u_vtgnr  and a.u_zj = c.u_zj) 
order by u_vtgnr, u_zj, u_folio;

SELECT  u_vtgnr, u_zj, u_folio                                                                                                                                 
FROM  q68t792_temp a  
WHERE 
u_zj = 
(SELECT substr(max(case when cast(u_zj as integer) < 50 then '20' || u_zj else '19' || u_zj end),3,2) 
 FROM q68t792_temp b WHERE a.u_vtgnr <= b.u_vtgnr) 
AND u_folio = (SELECT max(u_folio)  FROM q68t792_temp c WHERE a.u_vtgnr <= c.u_vtgnr  and a.u_zj <= c.u_zj)
order by u_vtgnr, u_zj, u_folio;

-- Fix bug in Expression to DXL translation for correlated queries when optimizer is turned on.
CREATE TABLE t1 (a int, b int);
CREATE TABLE t2 (a int, b int);
CREATE TABLE x (a int);
select * from x where a=  (select sum(t1.a)  from t1 inner join (select x.a as outer_ref, * from t2) as foo on (foo.a=t1.a+ outer_ref)  group by foo.a);

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET default_with_oids = false;

CREATE TABLE test_r_rvv_stada_dim_konst (
    dim_bezei character varying(50) NOT NULL,
    dim_elem_lvl smallint NOT NULL,
    dim_elem_nr character varying(12) NOT NULL,
    dim_elem_id character varying(12) NOT NULL,
    dim_elem_bezei character varying(50) NOT NULL,
    dim_parent_nr smallint,
    dim_bed character varying(150)
);


CREATE TABLE test_sf_dd_land_vm (
    land_elem_nr smallint NOT NULL,
    land_elem_bezei character varying(50) NOT NULL,
    land_typ smallint NOT NULL,
    land_id character varying(2),
    land_nr smallint,
    land_bezei character varying(50),
    land_bezei_krz character varying(15),
    land_abc_kz character varying(1),
    land_seg_qis_nr smallint,
    land_seg_qis_bezei character varying(50),
    land_seg_geo_nr smallint,
    land_seg_geo_bezei character varying(50),
    region_nr smallint,
    region_bezei character varying(50),
    sm_region_nr smallint,
    sm_region_bezei character varying(50),
    land_ges_nr smallint NOT NULL,
    land_ges_bezei character varying(50) NOT NULL
);


COPY test_r_rvv_stada_dim_konst (dim_bezei, dim_elem_lvl, dim_elem_nr, dim_elem_id, dim_elem_bezei, dim_parent_nr, dim_bed) FROM stdin;
0103b7ea15f866bb11c1759b46f61c7a	1	3	d4cd0dabcf4c	d4cd0dabcf4caa22ad92fab40844c786	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	0	100	84809c695116	5e911021574e6ad2ca8ca34ce765daac	\N	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	16	832e21f9da1a	832e21f9da1ad55895637d00686fdb42	104	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	64	ea5d2f1c4608	ea5d2f1c4608232e07d3aa3d998e5135	0	d41d8cd98f00b204e9800998ecf8427e
181f050e04dc4d9242f0471fbd5fbfa8	0	0	84809c695116	e46b26a1b91a96f494700f063dff87c7	\N	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	1	19344954f04f	19344954f04f9849eea867f331cddcce	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	18	78b0fb7d034c	78b0fb7d034c46f13890008e6f36806b	103	d41d8cd98f00b204e9800998ecf8427e
0c6bd6bf4cb194fc5fb0c8a8384c94db	0	0	84809c695116	0c6bd6bf4cb194fc5fb0c8a8384c94db	\N	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	3	517639957570	c80b4612e3467840dd8494788e6c5e38	0	aa9f9adca6b67dcc7e619c1e9df77808
NatCat-Zone	0	0	84809c695116	326069604c6a5df905ad7524ff6fd845	\N	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	11	6512bd43d9ca	bbe248bb0a79ab2d69315a853f1c73d4	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	22	b6d767d2f8ed	b6d767d2f8ed5d21a44b0e5886680cb9	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	102	0776809bccf9	0776809bccf9f0ce17bea87f017c1b9f	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	41	3416a75f4cea	3416a75f4cea9109507cacd8e2f2aefc	0	d41d8cd98f00b204e9800998ecf8427e
b61a3e9e5117789228714a7dbece5368	1	2	e1e1d3d40573	414acbafa74626ab848ef393426f1ca7	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	12	c20ad4d76fe9	c20ad4d76fe97759aa27a0c99bff6710	100	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	6	bffaa107d122	d9baa57d66694e09cd367b300941327f	0	c8af20d0259db915e0b1d4c8a9c7c882
NatCat-Zone	2	19	ec8989f78fab	ec8989f78fab481d87f43ecacca55aa1	103	d41d8cd98f00b204e9800998ecf8427e
145b109f5ab16b305c5a59400e8615bb	1	10	57cec4137b61	a6105c0a611b41b08f1209506350279e	0	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	1	b8decd29b0a1	e874610aaffeec5fb65aab5f81befd6d	0	92bc431e364f8523d9ae7cedf181c872
NatCat-Zone	2	21	f81e986ee4c9	f81e986ee4c9f80d6002bf5302b3ea87	103	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	19	1f0e3dad9990	55276c10d84e1df7713b441e76e141f9	0	d41d8cd98f00b204e9800998ecf8427e
f61d103ff565d935bbf5a2cd4ea0572f	1	3	890a10788493	890a10788493e3d572586e991cd43543	0	d41d8cd98f00b204e9800998ecf8427e
f61d103ff565d935bbf5a2cd4ea0572f	1	1	b86fc6b051f6	b86fc6b051f63d73de262d4c34e3a0a9	0	d41d8cd98f00b204e9800998ecf8427e
16844c1af98e046d58f641eedf0a1ada	1	2	e1e1d3d40573	52c9932e7a5247ab8915e56ebc31a319	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	3	eccbc87e4b5c	efa32d1e971e9d0ed2553a66f1548e50	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	51	2838023a778d	2838023a778dfaecdc212708f721b788	0	d41d8cd98f00b204e9800998ecf8427e
4d2ba128186be45047709f751cfb8a92	1	3	d4cd0dabcf4c	316af6c21cc12f37b0f702350a5ee660	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	106	e4541ed56cf3	e4541ed56cf3de37439937a54e5d6f38	0	d41d8cd98f00b204e9800998ecf8427e
181f050e04dc4d9242f0471fbd5fbfa8	1	1	a7bdee32cb21	79afeab88e1ebd59a017476928f83adb	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	8	c9f0f895fb98	c9f0f895fb98ab9159f51fd0297e236d	100	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	8	131d5a3daa39	131d5a3daa39b73050f40a62372ee44e	103	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	7	49b10fbde180	49b10fbde180f30ecd23a4155ecc5a6f	103	d41d8cd98f00b204e9800998ecf8427e
5b7dce2e8e6b158650dd553068b571c0	1	1	cc8ee37afb5c	53aa6eaffd8c87ca8ba676019ca8cc64	0	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	5	aa18c2e4dc3e	db5de5565ee5ad2c14507075fed51964	0	186c373830fa2ebdfb3672b1af52b997
NatCat-Zone	2	5	ffe7470430a7	ffe7470430a737c4ce6dc74bea0155d5	103	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	15	8381363cab61	8381363cab61eb967e4bb45a8d44b7e0	103	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	15	9bf31c7ff062	9bf31c7ff062936a96d3c8bd1f8f2ff3	0	d41d8cd98f00b204e9800998ecf8427e
5b7dce2e8e6b158650dd553068b571c0	1	3	74b8d5453b65	8fe1c21c436612f4844e910bd7fe8c70	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	9	be031607d3ae	be031607d3ae67c9031f3d900b8683ef	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	13	fc8baa6879e6	fc8baa6879e639926be3916810962e13	101	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	26	4e732ced3463	4e732ced3463d06de0ca9a15b6153677	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	7	8f14e45fceea	8f14e45fceea167a5a36dedd4bea2543	100	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	11	6512bd43d9ca	6512bd43d9caa6e02c990b0a82652dca	100	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	110	dec371fcaec1	dec371fcaec103c77f726ecf6f045d19	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	109	3fbe674f00bd	3fbe674f00bdce9f04865f793d7b555a	0	d41d8cd98f00b204e9800998ecf8427e
482a0f9da73eaef2635fca46019e5dfe	1	1	0d61f8370cad	349e686330723975502e9ef4f939a5ac	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	10	d3d9446802a4	e2beaebbb707494ef8742001c7911e66	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	22	d877c55797fd	d877c55797fd430ce8150363cd86058f	103	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	98	d4cd0dabcf4c	d4cd0dabcf4caa22ad92fab40844c786	0	d41d8cd98f00b204e9800998ecf8427e
745fcda37ffcd71c95c824972c842b91	0	0	84809c695116	745fcda37ffcd71c95c824972c842b91	\N	d41d8cd98f00b204e9800998ecf8427e
4d2ba128186be45047709f751cfb8a92	1	1	19344954f04f	039e333d79779b73c6ac8467aa6c8446	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	61	7f39f8317fbd	7f39f8317fbdb1988ef4c628eba02591	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	2	5034bc3fd2a1	5034bc3fd2a153aad8f903a3df44d08a	101	d41d8cd98f00b204e9800998ecf8427e
482a0f9da73eaef2635fca46019e5dfe	0	0	84809c695116	482a0f9da73eaef2635fca46019e5dfe	\N	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	17	70efdf2ec9b0	72f7f8076a8a3d529437e8d725c168a2	0	d41d8cd98f00b204e9800998ecf8427e
745fcda37ffcd71c95c824972c842b91	1	4	4c614360da93	8ba8785bbbdee3d6a0edc7badbbe05ec	0	d41d8cd98f00b204e9800998ecf8427e
4d2ba128186be45047709f751cfb8a92	1	2	4b0086c408cf	2008b7c9b3b4f55b860b535dce51cb42	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	13	d4cd0dabcf4c	d4cd0dabcf4caa22ad92fab40844c786	100	d41d8cd98f00b204e9800998ecf8427e
6196483b3dee5dd3297963c3998e1de8	1	1	9d5ed678fe57	11735e1e14db3f61c60f93503504fb2b	0	d41d8cd98f00b204e9800998ecf8427e
4c04c494b0ff8f487ed4966ea0e499c6	0	0	84809c695116	4c04c494b0ff8f487ed4966ea0e499c6	\N	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	10	2c61ebff5a7f	2c61ebff5a7f675451467527df66788d	108	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	52	9a1158154dfa	9a1158154dfa42caddbd0694a4e9bdc8	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	4	4d3c52f19f3d	e8b69269b48511ef844ad77e5a11c88c	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	101	35b3855dc944	35b3855dc94445aa82615b66f73f5be9	0	d41d8cd98f00b204e9800998ecf8427e
4c04c494b0ff8f487ed4966ea0e499c6	1	1	df22f1712488	e9ad9c2394f7dc7b6a69fb43e52a7382	0	d41d8cd98f00b204e9800998ecf8427e
4c04c494b0ff8f487ed4966ea0e499c6	1	2	627fcdb6cc9a	849c829d658baaeff512d766b0db3cce	0	d41d8cd98f00b204e9800998ecf8427e
42d6b50d69620b5604ea1c1e6d4bb0cb	1	3	69691c7bdcc3	48451f836d09ff61c197967baed4babc	0	d41d8cd98f00b204e9800998ecf8427e
519e8203b65668c4ce5759ceea4da243	0	0	84809c695116	519e8203b65668c4ce5759ceea4da243	\N	d41d8cd98f00b204e9800998ecf8427e
0103b7ea15f866bb11c1759b46f61c7a	1	1	8cdb36f48677	8cdb36f48677373dbde5dd7ead8c731e	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	6	1679091c5a88	1679091c5a880faf6fb5e6087eb1b2dc	100	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	11	484c5aa99688	484c5aa99688af4038b3980324f1232c	103	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	11	6512bd43d9ca	9b86666dca5a2ed46d7a8bb78e8a62ad	0	d41d8cd98f00b204e9800998ecf8427e
5b7dce2e8e6b158650dd553068b571c0	1	5	d4cd0dabcf4c	316af6c21cc12f37b0f702350a5ee660	0	d41d8cd98f00b204e9800998ecf8427e
b61a3e9e5117789228714a7dbece5368	0	0	84809c695116	b61a3e9e5117789228714a7dbece5368	\N	d41d8cd98f00b204e9800998ecf8427e
482a0f9da73eaef2635fca46019e5dfe	1	2	4c614360da93	5dbbd802974831cd78ec4ecd34757d8e	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	28	33e75ff09dd6	33e75ff09dd601bbe69f351039152189	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	23	37693cfc7480	37693cfc748049e45d87b8c7d8b9aacd	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	31	c16a5320fa47	c16a5320fa475530d9583c34fd356ef5	0	d41d8cd98f00b204e9800998ecf8427e
58816eea1a4809ba16406b0216bb8f85	0	0	84809c695116	58816eea1a4809ba16406b0216bb8f85	\N	d41d8cd98f00b204e9800998ecf8427e
58816eea1a4809ba16406b0216bb8f85	1	1	44c29edb103a	723870a71f0e58861924f24b3c21840b	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	107	578ed5a4eecf	578ed5a4eecf5a15803abdc49f6152d6	0	d41d8cd98f00b204e9800998ecf8427e
145b109f5ab16b305c5a59400e8615bb	2	1	7fc56270e7a7	db0213a9873b04498446588ba91dce31	10	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	12	c20ad4d76fe9	c20ad4d76fe97759aa27a0c99bff6710	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	32	6364d3f0f495	6364d3f0f495b6ab9dcf8d3b5c6e0b01	0	d41d8cd98f00b204e9800998ecf8427e
f61d103ff565d935bbf5a2cd4ea0572f	1	2	0a5a4d738606	0a5a4d7386065c6c6ac19c303768c7e1	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	1	57c7d11cd493	57c7d11cd49333e3f722204c63016da9	103	d41d8cd98f00b204e9800998ecf8427e
4c04c494b0ff8f487ed4966ea0e499c6	1	3	3d296788f2a7	b61705f85f6a5787b3797b783d692360	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	13	c51ce410c124	7e062f1dcc551b1467bc92f88b92a0ef	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	92	92cc227532d1	01cb581b2f63ff0cfd654c0149304afc	\N	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	9	45c48cce2e2d	45c48cce2e2d7fbdea1afc51c7c6ad26	100	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	112	e7333d76e27e	e7333d76e27e6772a960a972a8d6598e	0	d41d8cd98f00b204e9800998ecf8427e
16844c1af98e046d58f641eedf0a1ada	1	3	21c2e59531c8	529e9e0beb5f85d1f132917c1a09860c	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	9	e6d96502596d	e6d96502596d7e7887b76646c5f615d9	103	d41d8cd98f00b204e9800998ecf8427e
745fcda37ffcd71c95c824972c842b91	1	3	5dbc98dcc983	b8ddc732d2e6fa4b613a97323be3e8db	0	d41d8cd98f00b204e9800998ecf8427e
6196483b3dee5dd3297963c3998e1de8	1	2	e1e1d3d40573	2424b5fe85d4c50cf04daf345531e28f	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	2	c81e728d9d4c	6ace0f5def42a2d78dd40e3ff384f27a	0	d41d8cd98f00b204e9800998ecf8427e
42c3093bc32d46b62274bfce2cf18745	1	2	651362597a2a	651362597a2a9a351479ea91ca5a18c3	0	d41d8cd98f00b204e9800998ecf8427e
0c6bd6bf4cb194fc5fb0c8a8384c94db	1	2	8cb2010d27e1	41c409697b108c7e798edef4f1533042	0	4c5c2b8f3c2bf42cae73d64c99100224
0c6bd6bf4cb194fc5fb0c8a8384c94db	1	3	3754385271c4	db5de5565ee5ad2c14507075fed51964	0	584ee0eb67264dc3586ee884872d25b8
16844c1af98e046d58f641eedf0a1ada	1	1	3a3ea00cfc35	49a2747735077fab5b2b0b96e67ac297	0	d41d8cd98f00b204e9800998ecf8427e
519e8203b65668c4ce5759ceea4da243	1	3	d6734e50b93c	145b109f5ab16b305c5a59400e8615bb	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	10	d3d9446802a4	d3d9446802a44259755d38e6d163e820	100	d41d8cd98f00b204e9800998ecf8427e
5e911021574e6ad2ca8ca34ce765daac	1	0	cfcd208495d5	cfcd208495d565ef66e7dff9f98764da	100	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	14	aab3238922bc	aab3238922bcc25a6f606eb525ffdc56	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	24	ba8eaeec35b5	ba8eaeec35b54c67fea9bb1645a489a8	105	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	9	45c48cce2e2d	59155a0c07f1932b45c944636b98e121	0	d41d8cd98f00b204e9800998ecf8427e
83ea8511c73499557778d89213f9e198	1	1	69691c7bdcc3	69691c7bdcc3ce6d5d8a1361f22d04ac	0	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	7	0ec74ac15567	8d7191ccf394448f6cfdc1e4b80d972a	0	fc23dfaadfa7b68a7f094c72b5758a09
fca8c2bcba518414832516ce6476b40c	1	3	eccbc87e4b5c	eccbc87e4b5ce2fe28308fd9f2a7baf3	100	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	62	44f683a84163	44f683a84163b3523afe57c2e008bc8c	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	12	c20ad4d76fe9	4c6ee2bc37257a2a073630221c2d9c4c	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	108	f4864963ac06	f4864963ac0643d1b73ec6580f283042	0	d41d8cd98f00b204e9800998ecf8427e
6196483b3dee5dd3297963c3998e1de8	0	0	84809c695116	6196483b3dee5dd3297963c3998e1de8	\N	d41d8cd98f00b204e9800998ecf8427e
5b7dce2e8e6b158650dd553068b571c0	1	4	a7a4ccc5e1a0	d8937cd60e571aa3ad628858dd9708bf	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	0	0	84809c695116	9505a3c7a360cb8a402d4474b4b86f93	\N	d41d8cd98f00b204e9800998ecf8427e
181f050e04dc4d9242f0471fbd5fbfa8	1	3	d4cd0dabcf4c	316af6c21cc12f37b0f702350a5ee660	0	d41d8cd98f00b204e9800998ecf8427e
16844c1af98e046d58f641eedf0a1ada	0	0	84809c695116	16844c1af98e046d58f641eedf0a1ada	\N	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	10	c65a87a5ac09	c65a87a5ac096ecfc724eff061c323c4	0	d41d8cd98f00b204e9800998ecf8427e
145b109f5ab16b305c5a59400e8615bb	2	3	8d9c307cb7f3	7fa3b767c460b54a2be4d49030b349c7	11	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	14	375dcc1c4dec	375dcc1c4dec844c30d1a9a33d6e04af	103	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	4	e3fd4fef7dd0	b58753386b87aa25b69608613251c246	0	23d72e6a6a8abd3881a0f5f358bcaf04
cb909cda78049dda3903065fca287799	0	0	84809c695116	cb909cda78049dda3903065fca287799	\N	d41d8cd98f00b204e9800998ecf8427e
745fcda37ffcd71c95c824972c842b91	1	1	0d61f8370cad	a2cb54446c3a304e0e3d4cd40a22e203	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	2	8c876c90f4c6	8c876c90f4c6139a53b8447406319327	0	d41d8cd98f00b204e9800998ecf8427e
0103b7ea15f866bb11c1759b46f61c7a	0	0	84809c695116	0103b7ea15f866bb11c1759b46f61c7a	\N	d41d8cd98f00b204e9800998ecf8427e
42d6b50d69620b5604ea1c1e6d4bb0cb	1	2	dfcf28d07345	ed9d2919c0128bd443607ebc36dadeef	0	d41d8cd98f00b204e9800998ecf8427e
58816eea1a4809ba16406b0216bb8f85	1	2	8bc2afe7028c	2894803c95e14523f0a402b6ba16d771	0	d41d8cd98f00b204e9800998ecf8427e
b61a3e9e5117789228714a7dbece5368	1	3	0d61f8370cad	55f4b4a94111759e08b3acb1acd12b8c	0	d41d8cd98f00b204e9800998ecf8427e
42d6b50d69620b5604ea1c1e6d4bb0cb	1	1	3a3ea00cfc35	bfc36dc3450c449d943b5134a322f668	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	8	ea03e4b16909	ea03e4b16909efe369d688a1636c27bc	0	d41d8cd98f00b204e9800998ecf8427e
4d2ba128186be45047709f751cfb8a92	0	0	84809c695116	4d2ba128186be45047709f751cfb8a92	\N	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	7	8f14e45fceea	904ccc9c77ff01a6d6e5cf55d1be50f8	0	d41d8cd98f00b204e9800998ecf8427e
42d6b50d69620b5604ea1c1e6d4bb0cb	0	0	84809c695116	42d6b50d69620b5604ea1c1e6d4bb0cb	\N	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	53	d82c8d1619ad	d82c8d1619ad8176d665453cfb2e55f0	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	5	e4da3b7fbbce	6479e0417e03c6981e3e058930cf5441	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	17	365f939403a7	365f939403a7e61514b0f74b6809290f	104	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	4	b6eb281e772f	b6eb281e772f7b8fc9404fba1fbbb06a	103	d41d8cd98f00b204e9800998ecf8427e
0c6bd6bf4cb194fc5fb0c8a8384c94db	1	1	af70c800d0e6	54dada75182ee1a6608d7fccf1618eb2	0	a57af889d26fdf589ef6aa49e258814a
745fcda37ffcd71c95c824972c842b91	1	2	69691c7bdcc3	0500ae38db900195ef518b07677330b3	0	d41d8cd98f00b204e9800998ecf8427e
519e8203b65668c4ce5759ceea4da243	1	1	44c29edb103a	723870a71f0e58861924f24b3c21840b	0	d41d8cd98f00b204e9800998ecf8427e
5b7dce2e8e6b158650dd553068b571c0	1	2	9f3bf0c1c225	cc816a50a5381aae77444c6e60aa1c39	0	d41d8cd98f00b204e9800998ecf8427e
83ea8511c73499557778d89213f9e198	1	2	5dbc98dcc983	5dbc98dcc983a70728bd082d1a47546e	0	d41d8cd98f00b204e9800998ecf8427e
145b109f5ab16b305c5a59400e8615bb	1	11	8d9c307cb7f3	7fa3b767c460b54a2be4d49030b349c7	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	15	9bf31c7ff062	c67f11495017fcdaaa97c67b1f8baa89	0	d41d8cd98f00b204e9800998ecf8427e
4c04c494b0ff8f487ed4966ea0e499c6	1	4	925cc8d2953e	559608508b42a01c1068fae4fcdc2aef	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	1	c4ca4238a0b9	c4ca4238a0b923820dcc509a6f75849b	100	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	23	e060bb629c10	e060bb629c10e1b143614cc1e9ccdc67	103	d41d8cd98f00b204e9800998ecf8427e
83ea8511c73499557778d89213f9e198	0	0	84809c695116	83ea8511c73499557778d89213f9e198	\N	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	103	ecab6653cedb	ecab6653cedb98ded1c7416c0d114df7	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	1	c4ca4238a0b9	4a4117283d87ddc9cad762448bd0dbb9	0	d41d8cd98f00b204e9800998ecf8427e
cb909cda78049dda3903065fca287799	1	2	52ffc801bb92	5e592eaba2cc166df83420c4f9b96233	0	f31ead525edda3fb6c1b74618dfc009b
f9e42beb02b035dca917ea56313d9070	1	18	6f4922f45568	b980fb232ec66ad7286ae420a2c39df3	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	20	ada53304c5b9	ada53304c5b9e4a839615b6e8f908eb6	112	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	0	0	84809c695116	b0a9df59c9eb73f0a47ca5bda803b36c	\N	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	3	93cd19caf9b4	93cd19caf9b411ebed943965a9ca83be	0	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	4	a87ff679a2f3	a87ff679a2f3e71d9181a67b7542122c	100	d41d8cd98f00b204e9800998ecf8427e
145b109f5ab16b305c5a59400e8615bb	0	0	3af1a2642071	145b109f5ab16b305c5a59400e8615bb	\N	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	111	78fe5b689568	78fe5b68956805618673ba3f04999ae8	0	d41d8cd98f00b204e9800998ecf8427e
42c3093bc32d46b62274bfce2cf18745	1	1	9759dd199006	9759dd1990064fc5fc63239a7e61582f	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	99	4a49075b1524	4a49075b15242d9e4d400b52a349983a	0	d41d8cd98f00b204e9800998ecf8427e
f61d103ff565d935bbf5a2cd4ea0572f	1	4	8d9c307cb7f3	8d9c307cb7f3c4a32822a51922d1ceaa	0	d41d8cd98f00b204e9800998ecf8427e
b61a3e9e5117789228714a7dbece5368	1	1	3a3ea00cfc35	d0208f7a44e3f71e0c8cc9bad00b8978	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	27	02e74f10e032	36720406ba7a6ed121d79b2c01e5b347	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	6	1679091c5a88	1610307b826a861f0e99a1357ef5dcc2	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	4	a87ff679a2f3	cf70935129ffddee8aa78e03d72d2623	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	100	b0c597f91004	b0c597f91004d4355059ffeee1f30393	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	3	5e4ac03d7827	5e4ac03d7827ca48ed305a0d80cd5aa1	107	d41d8cd98f00b204e9800998ecf8427e
f61d103ff565d935bbf5a2cd4ea0572f	0	0	84809c695116	f61d103ff565d935bbf5a2cd4ea0572f	\N	d41d8cd98f00b204e9800998ecf8427e
fca8c2bcba518414832516ce6476b40c	1	2	c81e728d9d4c	c81e728d9d4c2f636f067f89cc14862c	100	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	7	836cf97caaf2	836cf97caaf24bedd8f3c098073c0c9c	0	d41d8cd98f00b204e9800998ecf8427e
58816eea1a4809ba16406b0216bb8f85	1	3	d4cd0dabcf4c	316af6c21cc12f37b0f702350a5ee660	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	6	76acac1a31f3	76acac1a31f3ba26f0ce8adb1b8475e7	0	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	6	06202b87153d	06202b87153d246b5acbf8ed52301f6e	103	d41d8cd98f00b204e9800998ecf8427e
42c3093bc32d46b62274bfce2cf18745	0	0	84809c695116	42c3093bc32d46b62274bfce2cf18745	\N	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	105	f2f72863a847	f2f72863a84704b5c9ba7a8aa051f73d	0	d41d8cd98f00b204e9800998ecf8427e
b0a9df59c9eb73f0a47ca5bda803b36c	1	5	52899a58dee6	52899a58dee627d98edea18d1c701891	0	d41d8cd98f00b204e9800998ecf8427e
181f050e04dc4d9242f0471fbd5fbfa8	1	2	d516cfc947c9	e41fc1331bbd8c67e78253dfad0415a5	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	54	a684eceee76f	a684eceee76fc522773286a895bc8436	0	d41d8cd98f00b204e9800998ecf8427e
9505a3c7a360cb8a402d4474b4b86f93	1	13	c51ce410c124	c51ce410c124a10e0db5e4b97fc2af39	0	d41d8cd98f00b204e9800998ecf8427e
0103b7ea15f866bb11c1759b46f61c7a	1	2	0da5a4aed7fb	0da5a4aed7fbf15d6bf9bdf07d978e9c	0	d41d8cd98f00b204e9800998ecf8427e
5b7dce2e8e6b158650dd553068b571c0	0	0	84809c695116	5b7dce2e8e6b158650dd553068b571c0	\N	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	14	aab3238922bc	d702ac28e3610c9f7203c8202b218829	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	0	0	84809c695116	927cee1b0cb6553bbd0d4e67794636a3	0	d41d8cd98f00b204e9800998ecf8427e
519e8203b65668c4ce5759ceea4da243	1	2	8bc2afe7028c	2894803c95e14523f0a402b6ba16d771	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	8	c9f0f895fb98	5de01abf8969a7e70937b8bc9e1fbfa0	0	d41d8cd98f00b204e9800998ecf8427e
145b109f5ab16b305c5a59400e8615bb	2	2	5dbc98dcc983	86c70f8ed514ef4787300d0d20faf791	10	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	2	12	2708c3704f3c	2708c3704f3c6a7b3a9e685289b412aa	103	d41d8cd98f00b204e9800998ecf8427e
0c6bd6bf4cb194fc5fb0c8a8384c94db	1	4	5dc4f449b09b	03c66bef1ed91170020569b3a513140a	0	7145ef5b6b8705df3163800ab30d7ccb
fca8c2bcba518414832516ce6476b40c	1	5	e4da3b7fbbce	e4da3b7fbbce2345d7772b0674a318d5	100	d41d8cd98f00b204e9800998ecf8427e
NatCat-Zone	1	104	a441cb7c28e1	a441cb7c28e1f94b7d8e7e1be1f07310	0	d41d8cd98f00b204e9800998ecf8427e
f9e42beb02b035dca917ea56313d9070	1	16	c74d97b01eae	dcf37d1c46ab2950244d2f4cd4455641	0	d41d8cd98f00b204e9800998ecf8427e
\.



COPY test_sf_dd_land_vm (land_elem_nr, land_elem_bezei, land_typ, land_id, land_nr, land_bezei, land_bezei_krz, land_abc_kz, land_seg_qis_nr, land_seg_qis_bezei, land_seg_geo_nr, land_seg_geo_bezei, region_nr, region_bezei, sm_region_nr, sm_region_bezei, land_ges_nr, land_ges_bezei) FROM stdin;
528	cdcd6cea3c88c6365ace6f2cbb6e0cea	1	02	528	cdcd6cea3c88c6365ace6f2cbb6e0cea	cdcd6cea3c88c63	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
10	4f2dc75f7df87f32daaf1a049066dedd	2	e3	\N	\N	\N	N	\N	\N	\N	\N	10	4f2dc75f7df87f32daaf1a049066dedd	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
249	3a241561419368883ab837c0275bf3e6	1	91	249	3a241561419368883ab837c0275bf3e6	7b2f841ec255602	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
505	77f9068416363b761f0ddabbc066c4da	1	09	505	77f9068416363b761f0ddabbc066c4da	77f9068416363b7	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
503	08bb2cae0b3b214eaa739b43749f0f4e	1	c5	503	08bb2cae0b3b214eaa739b43749f0f4e	08bb2cae0b3b214	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
309	381758c21c32450659b9b2e41b039f5d	1	b8	309	381758c21c32450659b9b2e41b039f5d	381758c21c32450	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
21	50a367a077edcb55402efbf2aaaaa700	2	0d	\N	\N	\N	N	\N	\N	\N	\N	21	50a367a077edcb55402efbf2aaaaa700	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
337	018cb35f0b2986978434aef117d03cf5	1	f7	337	018cb35f0b2986978434aef117d03cf5	018cb35f0b29869	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
320	4e005a9168d7fb69836cceb044717e94	1	73	320	4e005a9168d7fb69836cceb044717e94	4e005a9168d7fb6	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
121	44e80c82723dfc7c9a3cd546b5ca662e	1	17	121	44e80c82723dfc7c9a3cd546b5ca662e	44e80c82723dfc7	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
238	4fbdd5b8f184018ee688b77d52622fe1	1	12	238	4fbdd5b8f184018ee688b77d52622fe1	4fbdd5b8f184018	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
131	9f977a220e59d3948ea953674ca0e634	1	b3	131	9f977a220e59d3948ea953674ca0e634	9f977a220e59d39	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
145	85250321967cc45cdbfab460eecce263	1	91	145	85250321967cc45cdbfab460eecce263	85250321967cc45	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
519	21e9696e5d0bdb290c923637d0a6d908	1	63	519	21e9696e5d0bdb290c923637d0a6d908	21e9696e5d0bdb2	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
342	89cacbbb559259549e77c30c075aaae0	1	c5	342	89cacbbb559259549e77c30c075aaae0	c0ef4281908ac9b	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
126	59240330332adfccfbe033ba96e84f20	1	9f	126	59240330332adfccfbe033ba96e84f20	59240330332adfc	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
216	1c64090b21e84e4f95825de3411a9c80	1	77	216	1c64090b21e84e4f95825de3411a9c80	1c64090b21e84e4	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
339	e5c01bfd90fc584b7ce848bde72dd28f	1	fa	339	e5c01bfd90fc584b7ce848bde72dd28f	e5c01bfd90fc584	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
405	8423048030ed9199cc169cea0c342ed1	1	7c	405	8423048030ed9199cc169cea0c342ed1	8423048030ed919	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
122	6fae36c4608b51bb19bbdf88dc8fcf59	1	7b	122	6fae36c4608b51bb19bbdf88dc8fcf59	6fae36c4608b51b	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
229	07f1ae345d8f693f4ed73dec830fb36e	1	07	229	07f1ae345d8f693f4ed73dec830fb36e	7bf5e34cc0c631a	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
410	c0d9fc493ecdd6e2e73b8bdd7eeed4fb	1	09	410	c0d9fc493ecdd6e2e73b8bdd7eeed4fb	c60e9d81c57bef2	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
302	243cc3954c8a3caa5725ab86276190bf	1	ad	302	243cc3954c8a3caa5725ab86276190bf	243cc3954c8a3ca	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
403	00d7d9ab3d750fa998492f715d69f010	1	b2	403	00d7d9ab3d750fa998492f715d69f010	00d7d9ab3d750fa	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
0	512ef7c688a2c8572d5e16f44e17e869	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
307	7973f8a3e674c89bb1af868180fb808a	1	a2	307	7973f8a3e674c89bb1af868180fb808a	7973f8a3e674c89	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
994	c9815f24891e54458775e6a27322b70a	1	57	994	c9815f24891e54458775e6a27322b70a	d965486a148eb61	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	994	c9815f24891e54458775e6a27322b70a	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
522	2dc06730702125f4ae091657856e2368	1	42	522	2dc06730702125f4ae091657856e2368	2dc06730702125f	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
232	e4dd8f0521e7c1fca2466b277185f57f	1	90	232	e4dd8f0521e7c1fca2466b277185f57f	e4dd8f0521e7c1f	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
233	d32484f02ae888fc9ca4bf6d3ec30654	1	36	233	d32484f02ae888fc9ca4bf6d3ec30654	fea35cd75b707f5	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
41	d11a2a99c7e255871b8fca6ca916ce5a	2	1d	\N	\N	\N	N	\N	\N	\N	\N	41	d11a2a99c7e255871b8fca6ca916ce5a	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
104	481a9a6891fdfdbcfb9b537f65da209c	1	ef	104	481a9a6891fdfdbcfb9b537f65da209c	481a9a6891fdfdb	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
231	d0674c07e05a2e48ccade7644623892f	1	2d	231	d0674c07e05a2e48ccade7644623892f	79fe4f23c9a223d	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
245	0272ba3b010fa9a51b9143223f28ed3f	1	27	245	0272ba3b010fa9a51b9143223f28ed3f	0272ba3b010fa9a	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
306	676de5ba893af6bbc683c93306aaf769	1	2e	306	676de5ba893af6bbc683c93306aaf769	676de5ba893af6b	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
114	f424832120571595fe1cb793d4259cd6	1	50	114	f424832120571595fe1cb793d4259cd6	f42483212057159	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
240	961bd6c053f32455098f9203f6f4b0cb	1	8a	240	961bd6c053f32455098f9203f6f4b0cb	1e5f526df8a3293	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
310	df5779b8899e0e8afc5164e6daec4876	1	30	310	df5779b8899e0e8afc5164e6daec4876	df5779b8899e0e8	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
502	84f2a141ab16901cf6233877001ce6b4	1	54	502	84f2a141ab16901cf6233877001ce6b4	84f2a141ab16901	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
317	b91510802bcc0c2c98129dd61f13d62a	1	a1	317	b91510802bcc0c2c98129dd61f13d62a	b91510802bcc0c2	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
15	10d17235369e14b7dea6b34527620118	2	0e	\N	\N	\N	N	\N	\N	\N	\N	15	10d17235369e14b7dea6b34527620118	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
110	b7fd90b0e7ac0861ffdb762da5fc20be	1	7b	110	b7fd90b0e7ac0861ffdb762da5fc20be	b7fd90b0e7ac086	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
22	8417532becd96ba9c77be4a2a5afe4f1	2	11	\N	\N	\N	N	\N	\N	\N	\N	22	8417532becd96ba9c77be4a2a5afe4f1	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
120	adc77a263ba8c6f516421c4e5982a543	1	84	120	adc77a263ba8c6f516421c4e5982a543	adc77a263ba8c6f	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
406	4f434617687953e66d4945cbcd0f7853	1	7b	406	4f434617687953e66d4945cbcd0f7853	4f434617687953e	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
332	fe10c79c9f1f63fddaba9d4cc57c9785	1	af	332	fe10c79c9f1f63fddaba9d4cc57c9785	fe10c79c9f1f63f	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
1	4b5f1c354f147e74ee9ce53c89645086	2	c1	\N	\N	\N	N	\N	\N	\N	\N	1	4b5f1c354f147e74ee9ce53c89645086	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
112	e6165388e7da4de2e7f4067be9757abc	1	10	112	e6165388e7da4de2e7f4067be9757abc	e6165388e7da4de	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
32	fa59b93f7634a29292e6ea5e8073fba1	2	f6	\N	\N	\N	N	\N	\N	\N	\N	32	fa59b93f7634a29292e6ea5e8073fba1	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
124	ff25664f11040a457d030ac391ddb195	1	c4	124	ff25664f11040a457d030ac391ddb195	ff25664f11040a4	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
219	92ebb5380c6133152cef40d8d65114d8	1	9b	219	92ebb5380c6133152cef40d8d65114d8	92ebb5380c61331	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
323	9e4fefb090c5e3726c02f82c0c43fc6d	1	e3	323	9e4fefb090c5e3726c02f82c0c43fc6d	9e4fefb090c5e37	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
103	ddf9673145c0e7248d1889674452188d	1	19	103	ddf9673145c0e7248d1889674452188d	ddf9673145c0e72	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
303	d85fbaa4e9c7bbe32ffd2c002823459a	1	51	303	d85fbaa4e9c7bbe32ffd2c002823459a	d85fbaa4e9c7bbe	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
117	be304cc24d32b6e48154e7720daffa9d	1	4b	117	be304cc24d32b6e48154e7720daffa9d	be304cc24d32b6e	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
34	35c050ad37a3a2526cfe8025846c86b3	2	a1	\N	\N	\N	N	\N	\N	\N	\N	34	35c050ad37a3a2526cfe8025846c86b3	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
316	53851a7a29c6001ec74ce64822c6c432	1	a6	316	53851a7a29c6001ec74ce64822c6c432	53851a7a29c6001	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
341	5069c0b464ec157966315b41f9ab4538	1	59	341	5069c0b464ec157966315b41f9ab4538	5069c0b464ec157	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
106	fd0ff296819dc61da4c30a3ed57fcce6	1	dd	106	fd0ff296819dc61da4c30a3ed57fcce6	fd0ff296819dc61	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
304	0772886437fdf3cc0aaf9cac5293b411	1	d3	304	0772886437fdf3cc0aaf9cac5293b411	0772886437fdf3c	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
116	41fb548634abb0dd1789fa72f515a8a1	1	08	116	41fb548634abb0dd1789fa72f515a8a1	41fb548634abb0d	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
335	79c27dd66581e491fd5a8d94db62ac51	1	91	335	79c27dd66581e491fd5a8d94db62ac51	79c27dd66581e49	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	33	14d07ec9a20b22a869cf51332e066056	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
533	370824caef878edd7874c226bf1fbc7f	1	c3	533	370824caef878edd7874c226bf1fbc7f	370824caef878ed	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
234	680f7261df2d9f68907ed68bb277ad2f	1	33	234	680f7261df2d9f68907ed68bb277ad2f	680f7261df2d9f6	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
401	9d49892430d385facb5990da4be25cfa	1	af	401	9d49892430d385facb5990da4be25cfa	9d49892430d385f	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
308	3c08b05a853446689e038b1d3471cfa5	1	8b	308	3c08b05a853446689e038b1d3471cfa5	3c08b05a8534466	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
136	cffbfdaf4e4ab6709eb96f55bc13541d	1	eb	136	cffbfdaf4e4ab6709eb96f55bc13541d	cffbfdaf4e4ab67	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
510	a41dda035671c6c0fc5fa1efe8db2dce	1	57	510	a41dda035671c6c0fc5fa1efe8db2dce	a41dda035671c6c	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
507	d4006719da48e72e6bd076c7b6379bd9	1	66	507	d4006719da48e72e6bd076c7b6379bd9	d4006719da48e72	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
248	b8a7aef8dfe15148756174ddb7ba1855	1	1a	248	b8a7aef8dfe15148756174ddb7ba1855	b8a7aef8dfe1514	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
200	0db90872750d507c431cafd0a81a6943	1	fd	200	0db90872750d507c431cafd0a81a6943	f75d91cdd36b85c	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	18	b980fb232ec66ad7286ae420a2c39df3	10000	512ef7c688a2c8572d5e16f44e17e869
500	57c45407f34346ac9480cbfa41053d4b	1	a6	500	57c45407f34346ac9480cbfa41053d4b	57c45407f34346a	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
223	e758a46e2d846cb7290b5acdab300871	1	b6	223	e758a46e2d846cb7290b5acdab300871	e758a46e2d846cb	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
247	520a3dbdaf8384e06e39074bdb43ecd3	1	36	247	520a3dbdaf8384e06e39074bdb43ecd3	520a3dbdaf8384e	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
33	14d07ec9a20b22a869cf51332e066056	2	c4	\N	\N	\N	N	\N	\N	\N	\N	33	14d07ec9a20b22a869cf51332e066056	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
119	182e2082638734efb9ec010d8a247c16	1	f4	119	182e2082638734efb9ec010d8a247c16	182e2082638734e	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
305	2523fd09aa0ae6e6ad3d3d2ed8f8c7a7	1	fb	305	2523fd09aa0ae6e6ad3d3d2ed8f8c7a7	2523fd09aa0ae6e	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
235	36c6c3ad40e4e9101092c14440078af4	1	f0	235	36c6c3ad40e4e9101092c14440078af4	36c6c3ad40e4e91	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	13	7e062f1dcc551b1467bc92f88b92a0ef	10000	512ef7c688a2c8572d5e16f44e17e869
226	e5a79d2b755220a7e69d7e015e0bab69	1	70	226	e5a79d2b755220a7e69d7e015e0bab69	e5a79d2b755220a	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
50	e0d829a023d4407c9ddd6ebcf2037202	2	56	\N	\N	\N	N	\N	\N	\N	\N	50	e0d829a023d4407c9ddd6ebcf2037202	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
246	d02a95f8f75b4c366861d9d37a1ad264	1	b8	246	d02a95f8f75b4c366861d9d37a1ad264	3a41eb240aaeb10	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
111	8655f406c434333976ba81a75c69ea1c	1	16	111	8655f406c434333976ba81a75c69ea1c	8655f406c434333	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
517	8067774087dc79f4db69e76a367bf94e	1	a8	517	8067774087dc79f4db69e76a367bf94e	8067774087dc79f	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
532	f7eec2e4b72372b40c989c9dbf6cc9f3	1	0d	532	f7eec2e4b72372b40c989c9dbf6cc9f3	f7eec2e4b72372b	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
998	55033a55e595b0adbb40653f9b3560c9	1	3b	998	55033a55e595b0adbb40653f9b3560c9	35e33c2f35c03eb	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	998	55033a55e595b0adbb40653f9b3560c9	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
241	39aa98db50836a6bc4d96d218f8cdf67	1	98	241	39aa98db50836a6bc4d96d218f8cdf67	39aa98db50836a6	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
527	dd9ab79b5973cd3fee04ae195a1e5940	1	08	527	dd9ab79b5973cd3fee04ae195a1e5940	dd9ab79b5973cd3	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
204	a38cbb23017269895ea4921bfe91e1df	1	32	204	a38cbb23017269895ea4921bfe91e1df	a38cbb230172698	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	13	7e062f1dcc551b1467bc92f88b92a0ef	10000	512ef7c688a2c8572d5e16f44e17e869
142	027bd29d069d2fdfaa1abe891fbaae92	1	d8	142	027bd29d069d2fdfaa1abe891fbaae92	027bd29d069d2fd	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
14	d359b50e49d6a21946a5d1f52db7c275	2	ed	\N	\N	\N	N	\N	\N	\N	\N	14	d359b50e49d6a21946a5d1f52db7c275	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
330	8a035bfda6c16c222a9edbcf7666a6ba	1	03	330	8a035bfda6c16c222a9edbcf7666a6ba	8a035bfda6c16c2	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
102	6d3934480b23c0ca3d164cf19fa11946	1	f4	102	6d3934480b23c0ca3d164cf19fa11946	6d3934480b23c0c	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
212	52a9aa2a43c6a8baa7537887d36a6f1a	1	fa	212	52a9aa2a43c6a8baa7537887d36a6f1a	52a9aa2a43c6a8b	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
30	dc06162350dd5c2d97f13dea0264a61a	2	91	\N	\N	\N	N	\N	\N	\N	\N	30	dc06162350dd5c2d97f13dea0264a61a	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
408	d30cb5a99f2e96f7a5623caf600f01f5	1	91	408	d30cb5a99f2e96f7a5623caf600f01f5	0d9e4ed17f2c1db	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	41	d11a2a99c7e255871b8fca6ca916ce5a	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
118	d33c571079f20a49e9c6040644319202	1	34	118	d33c571079f20a49e9c6040644319202	d33c571079f20a4	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
531	f555c6c205efc36daadede3688014ad8	1	3e	531	f555c6c205efc36daadede3688014ad8	f555c6c205efc36	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
133	75e699618865aca0dad11ecff805c1cc	1	62	133	75e699618865aca0dad11ecff805c1cc	75e699618865aca	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
17	f0f2292429f8b5604360a199e43d2eb0	2	30	\N	\N	\N	N	\N	\N	\N	\N	17	f0f2292429f8b5604360a199e43d2eb0	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
319	85db767e10d9c1d9b3a2956658420372	1	dd	319	85db767e10d9c1d9b3a2956658420372	85db767e10d9c1d	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
101	4b0b004d87f199727591fac72d3293a2	1	36	101	4b0b004d87f199727591fac72d3293a2	f72674018e843c1	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
336	f5621b859ff7b47aa78f3b6a3e5cce2f	1	fe	336	f5621b859ff7b47aa78f3b6a3e5cce2f	f5621b859ff7b47	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
203	a8dbb56e10212ca28720a5c1ca5a6aab	1	5a	203	a8dbb56e10212ca28720a5c1ca5a6aab	a8dbb56e10212ca	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
520	53bc5501e639292688fa56780570a1c1	1	d9	520	53bc5501e639292688fa56780570a1c1	53bc5501e639292	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
202	6b65600130f8f8d7b9d2c3a582a89f2e	1	a1	202	6b65600130f8f8d7b9d2c3a582a89f2e	6b65600130f8f8d	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
16	efc6e34e5a21855589e481e1c3f3cfde	2	d1	\N	\N	\N	N	\N	\N	\N	\N	16	efc6e34e5a21855589e481e1c3f3cfde	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
220	f762df3c480a157f4fa43e7ea4a10d33	1	3b	220	f762df3c480a157f4fa43e7ea4a10d33	f762df3c480a157	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
340	3d9ad9040c82917854cc797b95bbd4df	1	6f	340	3d9ad9040c82917854cc797b95bbd4df	3d9ad9040c82917	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
328	6fec1099f408109efe107a6333d6981b	1	87	328	6fec1099f408109efe107a6333d6981b	6fec1099f408109	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
12	cd6bc7d54665f4af8dc363a3373c6240	2	fb	\N	\N	\N	N	\N	\N	\N	\N	12	cd6bc7d54665f4af8dc363a3373c6240	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
253	1ed4fa84603a68bdffb5a8680ee30d74	1	10	253	1ed4fa84603a68bdffb5a8680ee30d74	1ed4fa84603a68b	N	\N	\N	\N	\N	20	00a58e6bc23b6232d61e077ae2059604	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
409	59a8168364bd0bcba54e3d419ac0675e	1	3b	409	59a8168364bd0bcba54e3d419ac0675e	59a8168364bd0bc	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
20	00a58e6bc23b6232d61e077ae2059604	2	91	\N	\N	\N	N	\N	\N	\N	\N	20	00a58e6bc23b6232d61e077ae2059604	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
192	a7231058a893e0e1254bda073366eb2c	1	d9	192	a7231058a893e0e1254bda073366eb2c	a7231058a893e0e	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
128	b897436a851d2d9d71907a5b9d18c65e	1	21	128	b897436a851d2d9d71907a5b9d18c65e	b897436a851d2d9	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
315	1e72b1dad9aabc8185b5f3f5d8e032b8	1	e2	315	1e72b1dad9aabc8185b5f3f5d8e032b8	1e72b1dad9aabc8	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
31	c31d3cdbcae617e253886b0f2ecfc4bf	2	d8	\N	\N	\N	N	\N	\N	\N	\N	31	c31d3cdbcae617e253886b0f2ecfc4bf	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
506	20dd1a74e0da4135babae61203017c34	1	f4	506	20dd1a74e0da4135babae61203017c34	64ee4e599a8810a	N	\N	\N	\N	\N	50	e0d829a023d4407c9ddd6ebcf2037202	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
321	a85de25532f765f7ff411acf44bd4234	1	1a	321	a85de25532f765f7ff411acf44bd4234	b6ae56d2d40c99f	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
115	f4da7c03a379efbf9c9edbaa2a8d369d	1	0c	115	f4da7c03a379efbf9c9edbaa2a8d369d	f4da7c03a379efb	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
239	a8ad431721c19f7ca388f087871b6431	1	17	239	a8ad431721c19f7ca388f087871b6431	f5ede49df3f454b	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
251	2121b053b6886e735add89f8b059afde	1	07	251	2121b053b6886e735add89f8b059afde	2121b053b6886e7	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
208	8c69bcdb2aef53b87ee64ae17f5aa9c0	1	9c	208	8c69bcdb2aef53b87ee64ae17f5aa9c0	8c69bcdb2aef53b	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	13	7e062f1dcc551b1467bc92f88b92a0ef	10000	512ef7c688a2c8572d5e16f44e17e869
312	114d705b6e339c5f4b5350890ffa0aed	1	ae	312	114d705b6e339c5f4b5350890ffa0aed	114d705b6e339c5	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
109	b027ff3f749fc2495187b8c583c2fa8e	1	a1	109	b027ff3f749fc2495187b8c583c2fa8e	b027ff3f749fc24	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
127	b143a1b51c69d39b574910cb5fa84f2a	1	68	127	b143a1b51c69d39b574910cb5fa84f2a	b143a1b51c69d39	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
40	ecc919b1c2b77740ffa77cda77176d07	2	8b	\N	\N	\N	N	\N	\N	\N	\N	40	ecc919b1c2b77740ffa77cda77176d07	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
334	513fe2a22a358c42c7b5f4dd4594ab25	1	b7	334	513fe2a22a358c42c7b5f4dd4594ab25	513fe2a22a358c4	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
244	d6d351a7fcc69a34465ee3618cdef40c	1	1d	244	d6d351a7fcc69a34465ee3618cdef40c	03b34d9efae3d8a	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
108	8b470f864495744fcd8c3dc7b370e889	1	a7	108	8b470f864495744fcd8c3dc7b370e889	8b470f864495744	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
51	17acb80a024000dc594ca93ccf4c4cfd	2	0d	\N	\N	\N	N	\N	\N	\N	\N	51	17acb80a024000dc594ca93ccf4c4cfd	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
313	bea090929a66e9937267d4a7e3be04c0	1	96	313	bea090929a66e9937267d4a7e3be04c0	bea090929a66e99	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
326	b2364513ce8c12fabce65038b3a6f4d8	1	5a	326	b2364513ce8c12fabce65038b3a6f4d8	b2364513ce8c12f	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
206	a180576f5a44c894bbbd9c97a2ef86e9	1	74	206	a180576f5a44c894bbbd9c97a2ef86e9	a180576f5a44c89	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
400	ecc919b1c2b77740ffa77cda77176d07	1	8b	400	ecc919b1c2b77740ffa77cda77176d07	ecc919b1c2b7774	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
523	83c1c9b5eaf851067e4cd19d00dc45ad	1	03	523	83c1c9b5eaf851067e4cd19d00dc45ad	83c1c9b5eaf8510	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
524	e80285000599357375c348f3f82a6978	1	9b	524	e80285000599357375c348f3f82a6978	e80285000599357	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
222	0bedab9aa28692c8f28a85d01d42b01a	1	a4	222	0bedab9aa28692c8f28a85d01d42b01a	0bedab9aa28692c	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
140	75ecb2a7edaf4e0ae9dcb65946cd5379	1	ee	140	75ecb2a7edaf4e0ae9dcb65946cd5379	75ecb2a7edaf4e0	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
525	508ac993db389e9277350983c5d496fd	1	99	525	508ac993db389e9277350983c5d496fd	508ac993db389e9	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
139	024ef7becd36034707cb17e6c91971ee	1	e7	139	024ef7becd36034707cb17e6c91971ee	024ef7becd36034	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
227	c5043aece9f017d318b9f7f1cf482db8	1	bc	227	c5043aece9f017d318b9f7f1cf482db8	c5043aece9f017d	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
504	8cad1b05c111f5c16ef8167c734068bc	1	da	504	8cad1b05c111f5c16ef8167c734068bc	2d3a542657dff34	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
107	e40dcd8dd2850fbd334941b55c0fac2b	1	10	107	e40dcd8dd2850fbd334941b55c0fac2b	fcc6842c20a69b1	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
224	2c921f0a6ef62def001b63b23a29f945	1	1c	224	2c921f0a6ef62def001b63b23a29f945	2c921f0a6ef62de	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
324	4ca1f6c156a91662412792d01bbc44b6	1	81	324	4ca1f6c156a91662412792d01bbc44b6	4ca1f6c156a9166	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
322	0cb33ad1b82531916cfa68d9eadaa2a8	1	75	322	0cb33ad1b82531916cfa68d9eadaa2a8	0cb33ad1b825319	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
143	fab620957c25aeab4366ad3c71566116	1	e7	143	fab620957c25aeab4366ad3c71566116	fab620957c25aea	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
13	7e67758d01470959aebbf4b2c82f7d7c	2	a1	\N	\N	\N	N	\N	\N	\N	\N	13	7e67758d01470959aebbf4b2c82f7d7c	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
516	1ac61e9893798a791cde6ea0447cd170	1	9a	516	1ac61e9893798a791cde6ea0447cd170	1ac61e9893798a7	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
333	83167e6fa26eb5343271db6778f183d8	1	75	333	83167e6fa26eb5343271db6778f183d8	83167e6fa26eb53	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
214	2fd70579e65de7d4af6b23d9fa19519b	1	01	214	2fd70579e65de7d4af6b23d9fa19519b	2fd70579e65de7d	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	13	7e062f1dcc551b1467bc92f88b92a0ef	10000	512ef7c688a2c8572d5e16f44e17e869
407	d3f8a82f9f0a9ef11da12f044e12d669	1	8f	407	d3f8a82f9f0a9ef11da12f044e12d669	0b47b5e765d62bd	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
243	251d62dd46fa604693ebcd9ea3a60754	1	a3	243	251d62dd46fa604693ebcd9ea3a60754	251d62dd46fa604	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
236	3cfe8f2a84ebc0a5e1707b4e50d2daf6	1	a7	236	3cfe8f2a84ebc0a5e1707b4e50d2daf6	3cfe8f2a84ebc0a	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
123	c2da2aca0b0b9198eaf9d35fe9c83766	1	5f	123	c2da2aca0b0b9198eaf9d35fe9c83766	c2da2aca0b0b919	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
501	1512741c3493826a58c162d5d2bb381d	1	7f	501	1512741c3493826a58c162d5d2bb381d	1512741c3493826	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
318	9df9f1156e86609b2ec294b065be043a	1	c4	318	9df9f1156e86609b2ec294b065be043a	9df9f1156e86609	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
105	2cceb0b5c65e259d2519ea446c87fb8c	1	03	105	2cceb0b5c65e259d2519ea446c87fb8c	2cceb0b5c65e259	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
190	a08bda53eb33f86e1e4869a2af3232dc	1	8f	190	a08bda53eb33f86e1e4869a2af3232dc	a08bda53eb33f86	N	\N	\N	\N	\N	10	4f2dc75f7df87f32daaf1a049066dedd	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
250	9f846038cf1e789a0b2adc7afc9e5820	1	15	250	9f846038cf1e789a0b2adc7afc9e5820	db71c09c4473941	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
52	4e7aa7442dc8fccc0997ee5add6de706	2	eb	\N	\N	\N	N	\N	\N	\N	\N	52	4e7aa7442dc8fccc0997ee5add6de706	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
113	3349cfa2f06130cdb05c1f14da235e03	1	22	113	3349cfa2f06130cdb05c1f14da235e03	3349cfa2f06130c	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
146	48795f5fee9bedac7e86933442fd3a0f	1	79	146	48795f5fee9bedac7e86933442fd3a0f	f7e4a98b7db3861	N	\N	\N	\N	\N	10	4f2dc75f7df87f32daaf1a049066dedd	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
211	bfd64a089b03558372aa05ecb073fff4	1	72	211	bfd64a089b03558372aa05ecb073fff4	bfd64a089b03558	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
144	2dc4b1947faf7f856cae0324b1ea82ce	1	3f	144	2dc4b1947faf7f856cae0324b1ea82ce	2dc4b1947faf7f8	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
125	7fd3501b939e155dc3fe071c01b5c08f	1	bf	125	7fd3501b939e155dc3fe071c01b5c08f	7fd3501b939e155	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
300	57566997ecc042908c284a50714d0b67	1	aa	300	57566997ecc042908c284a50714d0b67	57566997ecc0429	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	2	1610307b826a861f0e99a1357ef5dcc2	10000	512ef7c688a2c8572d5e16f44e17e869
314	aa794f3c1865ae26111ad7195c50e1f6	1	b9	314	aa794f3c1865ae26111ad7195c50e1f6	aa794f3c1865ae2	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
518	24ddaebbdb4135da03e8055c7b85f34a	1	7d	518	24ddaebbdb4135da03e8055c7b85f34a	24ddaebbdb4135d	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
301	f03b919de2cb8a36e9e404e0ad494627	1	e0	301	f03b919de2cb8a36e9e404e0ad494627	f03b919de2cb8a3	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
521	91924a0b38c5c672cd30086fabec48e2	1	59	521	91924a0b38c5c672cd30086fabec48e2	91924a0b38c5c67	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
11	1d4d18442904c3540ed53527479e8b8b	2	63	\N	\N	\N	N	\N	\N	\N	\N	11	1d4d18442904c3540ed53527479e8b8b	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
511	2cdd125ec51d569ee30a1a589feb0954	1	39	511	2cdd125ec51d569ee30a1a589feb0954	2cdd125ec51d569	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
514	5856863c4571429f5b7b11d1fa4ffdb1	1	36	514	5856863c4571429f5b7b11d1fa4ffdb1	5856863c4571429	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
18	08f2292b806aa0ff2f1ab4c9750d9c9d	2	1c	\N	\N	\N	N	\N	\N	\N	\N	18	08f2292b806aa0ff2f1ab4c9750d9c9d	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
135	752e09164fe8314789a9592228f0d79c	1	84	135	752e09164fe8314789a9592228f0d79c	752e09164fe8314	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
252	e43a56959d58a1af6a4eb574ab9e6528	1	91	252	e43a56959d58a1af6a4eb574ab9e6528	cb3064182409da0	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
526	5c048b595cf128ceb182fc5fb5a5d1a3	1	4a	526	5c048b595cf128ceb182fc5fb5a5d1a3	5c048b595cf128c	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
237	b05fff4940c02ced50fdf99735e098df	1	5a	237	b05fff4940c02ced50fdf99735e098df	b05fff4940c02ce	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	13	7e062f1dcc551b1467bc92f88b92a0ef	10000	512ef7c688a2c8572d5e16f44e17e869
529	810e643a03a88638eb8d4c74b153d96d	1	3f	529	810e643a03a88638eb8d4c74b153d96d	810e643a03a8863	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
191	8aa35343093a481b286617263f234842	1	eb	191	8aa35343093a481b286617263f234842	8aa35343093a481	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
24	d672fae414c2d3f355cd36880c863d6f	2	fe	\N	\N	\N	N	\N	\N	\N	\N	24	d672fae414c2d3f355cd36880c863d6f	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
129	c8427c7736d60967ecc89afb99ae4b65	1	8c	129	c8427c7736d60967ecc89afb99ae4b65	5eb61fb9bcd17a7	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
2	34b2e1b68f14269bdc2455d1e0cccb2e	2	c1	\N	\N	\N	N	\N	\N	\N	\N	2	34b2e1b68f14269bdc2455d1e0cccb2e	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
100	f20348cd8ac5ba4fca2aaa3e22f9c881	1	f3	100	f20348cd8ac5ba4fca2aaa3e22f9c881	f20348cd8ac5ba4	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
201	cf11da476a9fc9481d298a824f805638	1	11	201	cf11da476a9fc9481d298a824f805638	cf11da476a9fc94	A	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	11	9b86666dca5a2ed46d7a8bb78e8a62ad	10000	512ef7c688a2c8572d5e16f44e17e869
327	651ee8a0617682f985d20044eeec016c	1	9a	327	651ee8a0617682f985d20044eeec016c	651ee8a0617682f	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
225	5c809e9906b5c545224b1a2f25ddbc96	1	a9	225	5c809e9906b5c545224b1a2f25ddbc96	a7749be146d312b	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
404	913a3127f99130b7df68668bf1e100ee	1	1d	404	913a3127f99130b7df68668bf1e100ee	913a3127f99130b	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	40	ecc919b1c2b77740ffa77cda77176d07	4	5de01abf8969a7e70937b8bc9e1fbfa0	10000	512ef7c688a2c8572d5e16f44e17e869
130	184959bf87b77479427ed53d6c70ebd4	1	28	130	184959bf87b77479427ed53d6c70ebd4	184959bf87b7747	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	7	efa32d1e971e9d0ed2553a66f1548e50	10000	512ef7c688a2c8572d5e16f44e17e869
228	cdea6075efa225e2e4e3562bb9ea66c3	1	4e	228	cdea6075efa225e2e4e3562bb9ea66c3	cdea6075efa225e	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
134	30282a93380b4e7ababa727f40662a30	1	63	134	30282a93380b4e7ababa727f40662a30	30282a93380b4e7	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
311	1bece9d5e1aa32a40768f11de099980f	1	27	311	1bece9d5e1aa32a40768f11de099980f	1bece9d5e1aa32a	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
221	ac44917849d74d3c2600db7333d301af	1	3e	221	ac44917849d74d3c2600db7333d301af	e7fbe9fc68a6cd7	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
23	15c59d7cfcabf6a8ad3c69dc8537e45c	2	b9	\N	\N	\N	N	\N	\N	\N	\N	23	15c59d7cfcabf6a8ad3c69dc8537e45c	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
242	0154761b1c93a51bff3d20a0d53c00ab	1	42	242	0154761b1c93a51bff3d20a0d53c00ab	0154761b1c93a51	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
325	2469d71b0ba143433ca5732d5648b097	1	bc	325	2469d71b0ba143433ca5732d5648b097	2469d71b0ba1434	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
512	cf54e5fbddb1c8d7a65d1e0d3735f72f	1	10	512	cf54e5fbddb1c8d7a65d1e0d3735f72f	cf54e5fbddb1c8d	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	5	59155a0c07f1932b45c944636b98e121	10000	512ef7c688a2c8572d5e16f44e17e869
218	152080f754d9595d261660c937d55553	1	fa	218	152080f754d9595d261660c937d55553	152080f754d9595	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	11	9b86666dca5a2ed46d7a8bb78e8a62ad	10000	512ef7c688a2c8572d5e16f44e17e869
338	5c9f723cfcbceddb9c55a0d9994d4fa6	1	18	338	5c9f723cfcbceddb9c55a0d9994d4fa6	5c9f723cfcbcedd	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
141	07e9c77ae7a4342a00e7697e32502186	1	72	141	07e9c77ae7a4342a00e7697e32502186	07e9c77ae7a4342	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	1	6479e0417e03c6981e3e058930cf5441	10000	512ef7c688a2c8572d5e16f44e17e869
329	ca7ba13d1260a4d677eadbe24fc95e4f	1	b1	329	ca7ba13d1260a4d677eadbe24fc95e4f	ca7ba13d1260a4d	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	30	dc06162350dd5c2d97f13dea0264a61a	3	904ccc9c77ff01a6d6e5cf55d1be50f8	10000	512ef7c688a2c8572d5e16f44e17e869
132	9b6739233ac439e57a6003e39c3a9325	1	4d	132	9b6739233ac439e57a6003e39c3a9325	9b6739233ac439e	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	9	cf70935129ffddee8aa78e03d72d2623	10000	512ef7c688a2c8572d5e16f44e17e869
138	36fcb8a18ad5b78ea74131b230de40ae	1	60	138	36fcb8a18ad5b78ea74131b230de40ae	36fcb8a18ad5b78	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	8	4a4117283d87ddc9cad762448bd0dbb9	10000	512ef7c688a2c8572d5e16f44e17e869
147	1d8043230615ce2a731efc5c1a34935e	1	0e	147	1d8043230615ce2a731efc5c1a34935e	1d8043230615ce2	N	\N	\N	\N	\N	10	4f2dc75f7df87f32daaf1a049066dedd	\N	\N	10000	512ef7c688a2c8572d5e16f44e17e869
508	b2c563418b36455f3e620a86ce226387	1	ac	508	b2c563418b36455f3e620a86ce226387	41c4fd7c8e1a187	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
509	4bc0d60736367d85fd771171ba02692a	1	d5	509	4bc0d60736367d85fd771171ba02692a	4bc0d60736367d8	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	50	e0d829a023d4407c9ddd6ebcf2037202	6	e2beaebbb707494ef8742001c7911e66	10000	512ef7c688a2c8572d5e16f44e17e869
999	be084b4eb5b3c835cc96991e2f22fbb1	1	3b	999	be084b4eb5b3c835cc96991e2f22fbb1	f5d5ee1aa740d65	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	999	be084b4eb5b3c835cc96991e2f22fbb1	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
217	b93dbc808122ffa937e1c789ff7e71a9	1	83	217	b93dbc808122ffa937e1c789ff7e71a9	b93dbc808122ffa	C	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	14	b1f594ffdd6b01719e1208cfc211dda0	10000	512ef7c688a2c8572d5e16f44e17e869
137	486a4f5303807c02275f28b46a4e79cd	1	bb	137	486a4f5303807c02275f28b46a4e79cd	486a4f5303807c0	N	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	10	4f2dc75f7df87f32daaf1a049066dedd	10	6ace0f5def42a2d78dd40e3ff384f27a	10000	512ef7c688a2c8572d5e16f44e17e869
205	aefac68184f1b4a7dbc57d35a30665b2	1	da	205	aefac68184f1b4a7dbc57d35a30665b2	b02605efe8ce838	B	0	5982adce3bd1f8a983240b10ef190ab2	0	5982adce3bd1f8a983240b10ef190ab2	20	00a58e6bc23b6232d61e077ae2059604	12	4c6ee2bc37257a2a073630221c2d9c4c	10000	512ef7c688a2c8572d5e16f44e17e869
\.

select konst.dim_elem_bezei  as natcat_zone_elem_bezei,
		konst.dim_elem_bezei  as natcat_zone_elem_id,
		case when konst.dim_elem_lvl = 2 then (select land.land_nr from test_sf_dd_land_vm land where land.land_id=konst.dim_elem_bezei)     end as land_nr  
from
    test_r_rvv_stada_dim_konst konst     ,test_r_rvv_stada_dim_konst gesamt
where
    konst.dim_bezei     = 'NatCat-Zone'   and gesamt.dim_bezei    = 'NatCat-Zone'   and gesamt.dim_elem_lvl = 0;

-- test queries that should run on the master
create table mpp_bfv_1(col1 int, col2 text, col3 numeric);

-- this cannot go to the _setup file, because it is not propagated here
set optimizer_enable_indexscan = off;
set optimizer_enable_master_only_queries = on;

-- query that mentions no tables should have no motions
select count_operator('select substr(''abc'', 2)', 'Motion');

-- queries that mention only master only tables (such as catalog tables)
-- should have no motions
select count_operator('select relname from pg_class where relname = ''pg_class''', 'Motion');

select count_operator('select attname from pg_attribute where attname = ''attstorage''', 'Motion');

-- queries with master-only TVFs and no distributed trabes have no motions
select count_operator('select * from generate_series(1,10)', 'Motion');

-- start_ignore
-- queries over distributed tables should have motions
select count_operator('select col2 from mpp_bfv_1;', 'Motion');
-- end_ignore

-- this cannot go to the _teardown file, because it is not propagated here
reset optimizer_enable_indexscan;

create table mpp_bfv_2(a int, b text, primary key (a));

-- stop falling back to planner when catalog functions are encountered

explain select pg_column_size('mpp_bfv_2');

explain select pg_lock_status();

select pg_get_constraintdef(pg_constraint.oid) from pg_constraint, pg_class where conrelid=pg_class.oid and pg_class.relname='mpp_bfv_2';

--
-- Test detoasting of a long text field, when it comes directly from the QD
-- node without Motion nodes.
--

-- create a function with a very long function body, so that it gets
-- toasted (or compressed).
CREATE FUNCTION function_with_long_body() RETURNS text LANGUAGE sql
AS $function$
select $embeddedtext$
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
123456789012345678901234567890123456789012345678901234567890123456789012345
$embeddedtext$::text;
$function$;

-- Check that it's detoasted correctly when it's sent to the client, in
-- printtup()
select prosrc from pg_proc where proname = 'function_with_long_body';


--
-- Check for assertion failure that happened in VACUUM FULL of
-- pg_stat_last_operation. The VACUUM FULL of reindexing its indexes
-- inserted an entry to pg_stat_last_operation, but there's an assertion
-- that you don't try to insert into an index that's currently being
-- reindexed, or pending reindexing. This no longer happens, because
-- pg_stat_last_operation now only has one index, so that there is no
-- pending indexes left for it after indexing the first one.
--

-- first, delete all existing entries on pg_stat_last_operation, for the
-- table and its indexes. Otherwise, the update might be a HOT update,
-- and not touch the indexes.
set allow_system_table_mods=on;
delete from pg_stat_last_operation
  where classid='pg_class'::regclass and objid::regclass::text like 'pg_stat%last%';
set allow_system_table_mods=off;

-- VACUUM FULL should insert an entry, for building the index after rebuilding
-- the heap.
vacuum full pg_stat_last_operation;
select classid::regclass, objid::regclass, staactionname, stasubtype from pg_stat_last_operation
  where classid='pg_class'::regclass and objid::regclass::text like 'pg_stat%last%' and stasubtype != 'AUTO';
