<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

Apache Cloudberry (Incubating) welcomes contributions from anyone, new
and experienced! We appreciate your interest in contributing. This
guide will help you get started with the contribution.

## Code of Conduct

Everyone who participates in Cloudberry, either as a user or a
contributor, is obliged to follow the [Code of
Conduct](./CODE_OF_CONDUCT.md).

We strive to:

* Be open.
* Be empathetic, welcoming, friendly, and patient.
* Be collaborative.
* Be inquisitive.
* Be careful in the words that we choose.
* Be concise.
* Step down considerately.

## Find a Way to Contribute

There are many ways to contribute to Cloudberry. Here are some ways
you need to get started. The most common contributions include code,
documentation, and community support.

You can participate by:

* [Contributing code](https://cloudberry.apache.org/contribute/code).
* [Improving
  documentation](https://cloudberry.apache.org/contribute/doc).
* Helping out in the Slack channels, see [Slack
  Guide](https://cloudberry.apache.org/community/slack)
* Answering questions on [GitHub
  Discussions](https://github.com/apache/cloudberry/discussions/categories/q-a).
* Investigating [GitHub
  issues](https://github.com/apache/cloudberry/issues).
* [Reporting a new
  bug](https://github.com/apache/cloudberry/issues/new/choose).
* [Sharing ideas for new
  features](https://github.com/apache/cloudberry/discussions/new?category=ideas-feature-requests).
* Helping review [Pull
  Requests](https://github.com/apache/cloudberry/pulls) or
  [Proposals](https://github.com/apache/cloudberry/discussions/categories/proposal).
* Proposing your proposal, see [Proposal
  Guide](https://cloudberry.apache.org/contribute/proposal).
* [Reporting security issues](./SECURITY.md).
* Testing code, testing releases.
* Creating educational content (Blog posts, tutorials, videos, etc.)
* Spreading the word about Apache Cloudberry on social media(eg,
  Twitter, LinkedIn).
* ...
* More things to make Cloudberry better.

## Getting Help

Feel free to reach out to us in [Slack `#dev`
channels](https://cloudberry.apache.org/community/slack) or [GitHub
Discussions](https://github.com/apache/cloudberry/discussions) when
your contribution is blocked, especially when making your first
contribution. Don't be shy, we're happy to help.

Cloudberry cannot grow without the support from the community. Hope to
make our mission with you!

## Benefits of Contribution

There are many reasons to contribute to Cloudberry and open source
projects in general. Here are some of the benefits of participating:

* Growing your network. Working with Cloudberry in open source can
help connect you with people working on similar things. You can get
help or give help, and you might even make a real-life acquaintance!

* Improving your skills. When you work on a Cloudberry issue or Pull
Request, inevitably you'll learn more about how something works in our
project; either by asking questions and gathering info or by digging
deeper into the code yourself. There’s a skill-building benefit to
contributing to open source projects.

* Becoming an expert. You might start new to a project like Cloudberry
or PostgreSQL, and by building things and opening issues when you
encounter a new challenge or a bug, you’ll learn a ton over time. You
could find your knowledge of said project has grown so much that
you’ve become an expert.

* Speaking at conferences or more community events. With those skills
you’ve earned yourself working in open source, you can let other
people hear from you, and build your professional reputation through
these community activities.

* Getting free swag! By participating in GitHub and other community
channels, you can become eligible for free swag that the Cloudberry
team offers as a way to say thank you.

There are undoubtedly more benefits than those listed here. Hope you
enjoy your contribution to the Cloudberry community!
