/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.service;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.client.MatchResult;
import org.apache.bifromq.dist.client.UnmatchResult;
import org.apache.bifromq.mqtt.inbox.util.DelivererKeyUtil;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.mqtt.service.ILocalTopicRouter;
import org.apache.bifromq.sysprops.props.DeliverersPerMqttServer;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.util.TopicUtil;

public class LocalTopicRouter
implements ILocalTopicRouter {
    private static final int TOPIC_FILTER_BUCKET_NUM = (Integer)DeliverersPerMqttServer.INSTANCE.get();
    private final String serverId;
    private final IDistClient distClient;
    private final ConcurrentMap<TopicFilter, CompletableFuture<LocalRoutes>> routeMap = new ConcurrentHashMap<TopicFilter, CompletableFuture<LocalRoutes>>();

    public LocalTopicRouter(String serverId, IDistClient distClient) {
        this.serverId = serverId;
        this.distClient = distClient;
    }

    @Override
    public CompletableFuture<MatchResult> addTopicRoute(long reqId, String tenantId, String topicFilter, long incarnation, String channelId) {
        assert (!TopicUtil.isSharedSubscription((String)topicFilter));
        int bucketId = this.topicFilterBucketId(channelId);
        CompletableFuture toReturn = this.routeMap.compute(new TopicFilter(tenantId, topicFilter, bucketId), (k, v) -> {
            if (v == null || v.isCompletedExceptionally()) {
                LocalRoutes localRoutes = new LocalRoutes(k.bucketId);
                return this.distClient.addRoute(reqId, k.tenantId, TopicUtil.from((String)k.topicFilter), localRoutes.localReceiverId(), DelivererKeyUtil.toDelivererKey((String)k.tenantId, (String)localRoutes.localReceiverId(), (String)this.serverId), 0, localRoutes.incarnation()).thenApply(matchResult -> {
                    if (matchResult == MatchResult.OK) {
                        localRoutes.routesInfo.put(channelId, incarnation);
                        return localRoutes;
                    }
                    throw new AddRouteException((MatchResult)matchResult);
                });
            }
            CompletableFuture updated = new CompletableFuture();
            v.whenComplete((routeList, e) -> {
                if (e != null) {
                    updated.completeExceptionally((Throwable)e);
                } else {
                    routeList.routesInfo.put(channelId, incarnation);
                    updated.complete(routeList);
                }
            });
            return updated;
        });
        return toReturn.handle((routeList, e) -> {
            if (e != null) {
                this.routeMap.remove(new TopicFilter(tenantId, topicFilter, bucketId), toReturn);
                if (e instanceof AddRouteException) {
                    return ((AddRouteException)e).matchResult;
                }
                return MatchResult.ERROR;
            }
            return MatchResult.OK;
        });
    }

    @Override
    public CompletableFuture<UnmatchResult> removeTopicRoute(long reqId, String tenantId, String topicFilter, long incarnation, String channelId) {
        assert (!TopicUtil.isSharedSubscription((String)topicFilter));
        int bucketId = this.topicFilterBucketId(channelId);
        CompletableFuture toReturn = this.routeMap.computeIfPresent(new TopicFilter(tenantId, topicFilter, bucketId), (k, v) -> {
            CompletableFuture updated = new CompletableFuture();
            v.whenComplete((localRoutes, e) -> {
                if (e != null) {
                    updated.completeExceptionally((Throwable)e);
                } else {
                    localRoutes.routesInfo.remove(channelId, incarnation);
                    if (localRoutes.routesInfo.isEmpty()) {
                        this.distClient.removeRoute(reqId, k.tenantId, TopicUtil.from((String)k.topicFilter), localRoutes.localReceiverId(), DelivererKeyUtil.toDelivererKey((String)k.tenantId, (String)localRoutes.localReceiverId(), (String)this.serverId), 0, localRoutes.incarnation()).whenComplete((unmatchResult, t) -> {
                            if (t != null) {
                                updated.completeExceptionally((Throwable)t);
                            } else {
                                updated.completeExceptionally(new RemoveRouteException((UnmatchResult)unmatchResult));
                            }
                        });
                    } else {
                        updated.complete(localRoutes);
                    }
                }
            });
            return updated;
        });
        if (toReturn == null) {
            return CompletableFuture.completedFuture(UnmatchResult.OK);
        }
        return toReturn.handle((r, e) -> {
            if (e != null) {
                this.routeMap.remove(new TopicFilter(tenantId, topicFilter, bucketId), toReturn);
                if (e instanceof RemoveRouteException) {
                    return ((RemoveRouteException)e).unmatchResult;
                }
                return UnmatchResult.ERROR;
            }
            return UnmatchResult.OK;
        });
    }

    @Override
    public Optional<CompletableFuture<? extends ILocalTopicRouter.ILocalRoutes>> getTopicRoutes(String tenantId, MatchInfo matchInfo) {
        int bucketId = LocalRoutes.parseBucketId(matchInfo.getReceiverId());
        CompletableFuture routesFuture = (CompletableFuture)this.routeMap.get(new TopicFilter(tenantId, matchInfo.getMatcher().getMqttTopicFilter(), bucketId));
        return Optional.ofNullable(routesFuture);
    }

    private int topicFilterBucketId(String key) {
        int bucketId = key.hashCode() % TOPIC_FILTER_BUCKET_NUM;
        if (bucketId < 0) {
            bucketId = (bucketId + TOPIC_FILTER_BUCKET_NUM) % TOPIC_FILTER_BUCKET_NUM;
        }
        return bucketId;
    }

    private record TopicFilter(String tenantId, String topicFilter, int bucketId) {
    }

    private static class LocalRoutes
    implements ILocalTopicRouter.ILocalRoutes {
        private static final int BUCKET_ID_LENGTH = 5;
        private final String localReceiverId;
        private final Map<String, Long> routesInfo = new ConcurrentHashMap<String, Long>();
        private final long incarnation = System.nanoTime();

        private LocalRoutes(int bucketId) {
            this.localReceiverId = ILocalDistService.localize(String.format("%05d", bucketId) + this.incarnation);
        }

        public static int parseBucketId(String localReceiverId) {
            String receiverId = ILocalDistService.parseReceiverId(localReceiverId);
            return Integer.parseInt(receiverId.substring(0, 5));
        }

        @Override
        public String localReceiverId() {
            return this.localReceiverId;
        }

        @Override
        public Map<String, Long> routesInfo() {
            return this.routesInfo;
        }

        @Override
        public long incarnation() {
            return this.incarnation;
        }
    }

    private static class RemoveRouteException
    extends RuntimeException {
        final UnmatchResult unmatchResult;

        private RemoveRouteException(UnmatchResult unmatchResult) {
            this.unmatchResult = unmatchResult;
        }
    }

    private static class AddRouteException
    extends RuntimeException {
        final MatchResult matchResult;

        private AddRouteException(MatchResult matchResult) {
            this.matchResult = matchResult;
        }
    }
}

