/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.hinter;

import java.util.concurrent.atomic.AtomicInteger;

class RecordEstimation {
    private final AtomicInteger recordTotalSize = new AtomicInteger();
    private final AtomicInteger totalCount = new AtomicInteger();
    private final boolean isDelete;

    RecordEstimation(boolean isDelete) {
        this.isDelete = isDelete;
    }

    void addRecordSize(int recordSize) {
        this.recordTotalSize.addAndGet(recordSize);
        this.totalCount.incrementAndGet();
    }

    int avgRecordSize() {
        return this.recordTotalSize.get() / this.totalCount.get();
    }

    int tombstoneSize() {
        return this.isDelete ? this.recordTotalSize.get() : 0;
    }
}

