/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import org.apache.bifromq.basecrdt.core.internal.EventHistoryUtil;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.core.util.LatticeIndexUtil;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.Replacement;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.proto.StateLattice;
import org.apache.bifromq.basecrdt.util.Formatter;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class InMemReplicaStateLattice
implements IReplicaStateLattice {
    private final Logger log;
    private final Replica ownerReplica;
    private final AtomicLong event = new AtomicLong(0L);
    private final ConcurrentMap<ByteString, NavigableMap<Long, Long>> latticeIndex = Maps.newConcurrentMap();
    private final ConcurrentMap<ByteString, NavigableMap<Long, Long>> historyIndex = Maps.newConcurrentMap();
    private final Map<Event, EventInfo> eventDAG = Maps.newHashMapWithExpectedSize((int)1024);
    private final Duration historyExpire;
    private final long maxCompactionDuration;

    InMemReplicaStateLattice(String storeId, Replica ownerReplica, Duration historyExpire, Duration maxCompactionTime) {
        this.ownerReplica = ownerReplica;
        this.log = MDCLogger.getLogger(InMemReplicaStateLattice.class, (String[])new String[]{"store", storeId, "replica", Formatter.print(ownerReplica)});
        this.historyExpire = historyExpire;
        this.maxCompactionDuration = maxCompactionTime.toNanos();
    }

    @Override
    public int size() {
        return this.eventDAG.size();
    }

    @Override
    public Duration historyDuration() {
        return this.historyExpire;
    }

    @Override
    public long nextEvent() {
        return this.event.incrementAndGet();
    }

    @Override
    public Iterator<StateLattice> lattices() {
        return new AbstractIterator<StateLattice>(){
            private final Iterator<Event> eventItr;
            {
                this.eventItr = Iterators.concat(InMemReplicaStateLattice.this.latticeIndex.entrySet().stream().map(e -> InMemReplicaStateLattice.this.from((ByteString)e.getKey(), (NavigableMap)e.getValue())).iterator());
            }

            protected StateLattice computeNext() {
                if (this.eventItr.hasNext()) {
                    Event event = this.eventItr.next();
                    return InMemReplicaStateLattice.this.eventDAG.get((Object)event).lattice.get();
                }
                return (StateLattice)this.endOfData();
            }
        };
    }

    @Override
    public IReplicaStateLattice.JoinDiff join(Iterable<Replacement> deltas) {
        final HashSet adds = Sets.newHashSet();
        final HashSet removes = Sets.newHashSet();
        this.join(deltas, adds, removes);
        return new IReplicaStateLattice.JoinDiff(){

            @Override
            public Iterable<StateLattice> adds() {
                return adds;
            }

            @Override
            public Iterable<StateLattice> removes() {
                return removes;
            }
        };
    }

    private void join(Iterable<Replacement> delta, Set<StateLattice> adds, Set<StateLattice> rems) {
        for (Replacement replacement : delta) {
            assert (replacement.getDotsCount() > 0);
            Dot dot = replacement.getDots(0);
            Event event = Event.from(dot);
            EventInfo eventInfo = this.eventDAG.get(event);
            if (eventInfo == null) {
                eventInfo = EventInfo.from(dot);
                this.eventDAG.put(event, eventInfo);
                if (dot.hasLattice()) {
                    adds.add(dot.getLattice());
                    LatticeIndexUtil.remember(this.latticeIndex, dot.getReplicaId(), dot.getVer());
                } else {
                    LatticeIndexUtil.remember(this.historyIndex, dot.getReplicaId(), dot.getVer());
                }
            } else if (eventInfo.lattice.isPresent()) {
                if (!dot.hasLattice()) {
                    rems.add(eventInfo.lattice.get());
                    eventInfo.eol();
                    EventHistoryUtil.forget(this.latticeIndex, dot.getReplicaId(), dot.getVer());
                    LatticeIndexUtil.remember(this.historyIndex, dot.getReplicaId(), dot.getVer());
                } else assert (eventInfo.lattice.get().equals(dot.getLattice())) : "Inconsistent lattice";
            }
            for (int i = 1; i < replacement.getDotsCount(); ++i) {
                Event prevEvent = Event.from(replacement.getDots(i - 1));
                EventInfo prevInfo = this.eventDAG.get(prevEvent);
                Dot currentDot = replacement.getDots(i);
                Event currentEvent = Event.from(currentDot);
                EventInfo currentInfo = this.eventDAG.get(currentEvent);
                if (currentInfo == null) {
                    currentInfo = EventInfo.from(currentDot);
                    currentInfo.eol();
                    this.eventDAG.put(currentEvent, currentInfo);
                    LatticeIndexUtil.remember(this.historyIndex, currentEvent.replicaId, currentEvent.ver);
                } else if (currentInfo.lattice.isPresent()) {
                    rems.add(currentInfo.lattice.get());
                    currentInfo.eol();
                    EventHistoryUtil.forget(this.latticeIndex, currentEvent.replicaId, currentEvent.ver);
                    LatticeIndexUtil.remember(this.historyIndex, currentEvent.replicaId, currentEvent.ver);
                }
                prevInfo.replacing.add(currentEvent);
                currentInfo.replacedBy.add(prevEvent);
            }
        }
    }

    @Override
    public Optional<Iterable<Replacement>> delta(Map<ByteString, NavigableMap<Long, Long>> coveredLatticeIndex, Map<ByteString, NavigableMap<Long, Long>> coveredHistoryIndex, int maxLattices) {
        EventInfo eventInfo;
        Event event;
        Iterator<Event> itr;
        NavigableMap coveredLattices;
        HashSet replacements = Sets.newHashSet();
        block0: for (ByteString byteString : this.randomize(this.latticeIndex.keySet())) {
            NavigableMap latticeRanges = (NavigableMap)this.latticeIndex.get(byteString);
            coveredLattices = coveredLatticeIndex.getOrDefault(byteString, Collections.emptyNavigableMap());
            NavigableMap<Long, Long> coveredHistory = coveredHistoryIndex.getOrDefault(byteString, Collections.emptyNavigableMap());
            NavigableMap<Long, Long> newLatticeRanges = EventHistoryUtil.diff(EventHistoryUtil.diff(latticeRanges, coveredLattices), coveredHistory);
            itr = this.from(byteString, newLatticeRanges);
            while (itr.hasNext()) {
                event = itr.next();
                if (maxLattices <= 0) break block0;
                eventInfo = this.eventDAG.get(event);
                assert (eventInfo != null && eventInfo.lattice.isPresent());
                this.subDAG(event, replacements, coveredLatticeIndex, coveredHistoryIndex);
                --maxLattices;
            }
        }
        block2: for (Map.Entry entry : this.randomize(coveredLatticeIndex.entrySet())) {
            ByteString replicaId = (ByteString)entry.getKey();
            coveredLattices = (NavigableMap)entry.getValue();
            NavigableMap<Long, Long> latticeRanges = this.latticeIndex.getOrDefault(replicaId, Collections.emptyNavigableMap());
            NavigableMap<Long, Long> remLatticeRanges = EventHistoryUtil.diff(coveredLattices, latticeRanges);
            itr = this.from(replicaId, remLatticeRanges);
            while (itr.hasNext()) {
                event = itr.next();
                eventInfo = this.eventDAG.get(event);
                if (eventInfo == null) continue;
                assert (eventInfo.lattice.isEmpty());
                for (Event replacedByEvent : this.replacedByEvents(event)) {
                    if (!this.eventDAG.get((Object)replacedByEvent).lattice.isEmpty() || maxLattices <= 0) break block2;
                    this.subDAG(replacedByEvent, replacements, coveredLatticeIndex, coveredHistoryIndex);
                    --maxLattices;
                }
            }
        }
        if (!replacements.isEmpty()) {
            return Optional.of(replacements);
        }
        return Optional.empty();
    }

    @Override
    public Map<ByteString, NavigableMap<Long, Long>> latticeIndex() {
        return this.latticeIndex;
    }

    @Override
    public Map<ByteString, NavigableMap<Long, Long>> historyIndex() {
        return this.historyIndex;
    }

    @Override
    public boolean compact() {
        try {
            boolean nextCompactNeeded = false;
            long start = System.nanoTime();
            block2: for (ByteString replicaId : this.historyIndex.keySet()) {
                if (!this.historyIndex.containsKey(replicaId)) continue;
                Iterator<Event> eventItr = this.from(replicaId, Maps.newTreeMap((SortedMap)((SortedMap)this.historyIndex.get(replicaId))));
                while (eventItr.hasNext()) {
                    Event event = eventItr.next();
                    if (this.truncate(event)) {
                        nextCompactNeeded = true;
                    }
                    if (System.nanoTime() - start <= this.maxCompactionDuration) continue;
                    nextCompactNeeded = true;
                    continue block2;
                }
            }
            return nextCompactNeeded;
        }
        catch (Throwable e) {
            this.log.error("Compaction error", e);
            return false;
        }
    }

    private <E> Iterable<E> randomize(Iterable<E> iterable) {
        ArrayList shuffled = Lists.newArrayList(iterable);
        Collections.shuffle(shuffled);
        return shuffled;
    }

    private boolean truncate(Event event) {
        EventInfo eventInfo = this.eventDAG.get(event);
        if (eventInfo == null) {
            return false;
        }
        if (!this.truncatable(event)) {
            return false;
        }
        if (System.nanoTime() - eventInfo.ts > this.historyExpire.toNanos()) {
            this.eventDAG.remove(event);
            EventHistoryUtil.forget(this.historyIndex, event.replicaId, event.ver);
            ArrayList<Event> relateEvents = new ArrayList<Event>();
            boolean moreToTruncate = false;
            for (Event replacedByEvent : eventInfo.replacedBy) {
                this.eventDAG.get((Object)replacedByEvent).replacing.remove(event);
                relateEvents.add(replacedByEvent);
            }
            for (Event replacingEvent : eventInfo.replacing) {
                this.eventDAG.get((Object)replacingEvent).replacedBy.remove(event);
                relateEvents.add(replacingEvent);
            }
            for (Event relate : relateEvents) {
                if (!this.truncate(relate)) continue;
                moreToTruncate = true;
            }
            return moreToTruncate;
        }
        return true;
    }

    private boolean truncatable(Event event) {
        EventInfo eventInfo = this.eventDAG.get(event);
        if (eventInfo.lattice.isPresent()) {
            return false;
        }
        for (Event replacedByEvent : eventInfo.replacedBy) {
            EventInfo replacedByEventInfo = this.eventDAG.get(replacedByEvent);
            if (replacedByEventInfo.lattice.isPresent()) {
                return false;
            }
            if (!replacedByEventInfo.replacedBy.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private Iterator<Event> from(ByteString replicaId, NavigableMap<Long, Long> ranges) {
        return Iterators.transform((Iterator)Iterators.concat(Maps.newTreeMap(ranges).entrySet().stream().map(r -> LongStream.rangeClosed((Long)r.getKey(), (Long)r.getValue()).iterator()).iterator()), i -> Event.from(replicaId, i));
    }

    private void subDAG(Event event, Set<Replacement> replacements, Map<ByteString, NavigableMap<Long, Long>> coveredLatticeIndex, Map<ByteString, NavigableMap<Long, Long>> coveredHistoryIndex) {
        LinkedList toVisits = Lists.newLinkedList(Collections.singleton(event));
        LinkedList events = Lists.newLinkedList();
        block0: while (!toVisits.isEmpty()) {
            Event current = (Event)toVisits.remove(0);
            EventInfo eventInfo = this.eventDAG.get(current);
            events.add(current);
            if (eventInfo.replacing.isEmpty() || EventHistoryUtil.isRemembering(coveredLatticeIndex, current.replicaId, current.ver) || EventHistoryUtil.isRemembering(coveredHistoryIndex, current.replicaId, current.ver)) {
                replacements.add(Replacement.newBuilder().addAllDots(events.stream().map(e -> {
                    EventInfo info = this.eventDAG.get(e);
                    return info.lattice.map(stateLattice -> ProtoUtils.dot(e.replicaId, e.ver, stateLattice)).orElseGet(() -> ProtoUtils.dot(e.replicaId, e.ver));
                }).collect(Collectors.toList())).build());
                if (toVisits.isEmpty()) continue;
                Event nextVisitEvent = (Event)toVisits.getFirst();
                EventInfo nextVisitEventInfo = this.eventDAG.get(nextVisitEvent);
                while (!events.isEmpty()) {
                    events.removeLast();
                    Event lastEvent = (Event)events.getLast();
                    if (!nextVisitEventInfo.replacedBy.contains(lastEvent)) continue;
                    continue block0;
                }
                continue;
            }
            eventInfo.replacing.forEach(toVisits::addFirst);
        }
    }

    private Iterable<Event> replacedByEvents(Event event) {
        EventInfo eventInfo = this.eventDAG.get(event);
        assert (eventInfo != null);
        if (eventInfo.replacedBy.isEmpty()) {
            return Collections.singleton(event);
        }
        return Iterables.concat((Iterable)eventInfo.replacedBy.stream().map(this::replacedByEvents).collect(Collectors.toSet()));
    }

    private static class Event {
        final ByteString replicaId;
        final long ver;

        private Event(ByteString replicaId, long ver) {
            this.replicaId = replicaId;
            this.ver = ver;
        }

        private Event(Dot dot) {
            this.replicaId = dot.getReplicaId();
            this.ver = dot.getVer();
        }

        static Event from(ByteString replicaId, long ver) {
            return new Event(replicaId, ver);
        }

        static Event from(Dot dot) {
            return new Event(dot);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Event)) {
                return false;
            }
            Event other = (Event)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.ver != other.ver) {
                return false;
            }
            ByteString this$replicaId = this.replicaId;
            ByteString other$replicaId = other.replicaId;
            return !(this$replicaId == null ? other$replicaId != null : !this$replicaId.equals(other$replicaId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Event;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $ver = this.ver;
            result = result * 59 + (int)($ver >>> 32 ^ $ver);
            ByteString $replicaId = this.replicaId;
            result = result * 59 + ($replicaId == null ? 43 : $replicaId.hashCode());
            return result;
        }
    }

    private static class EventInfo {
        final Set<Event> replacing = Sets.newHashSet();
        final Set<Event> replacedBy = Sets.newHashSet();
        Optional<StateLattice> lattice;
        long ts;

        private EventInfo() {
            this.lattice = Optional.empty();
            this.ts = System.nanoTime();
        }

        private EventInfo(StateLattice lattice) {
            this.lattice = Optional.of(lattice);
            this.ts = Long.MAX_VALUE;
        }

        static EventInfo from(Dot dot) {
            return dot.hasLattice() ? new EventInfo(dot.getLattice()) : new EventInfo();
        }

        void eol() {
            this.lattice = Optional.empty();
            this.ts = System.nanoTime();
        }
    }
}

