/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.OptionalInt;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GeometryGetter<G, V extends G>
extends ValueGetter<V> {
    private final Geometries<G> geometryFactory;
    private final CoordinateReferenceSystem defaultCRS;
    private final BinaryEncoding encoding;

    GeometryGetter(Geometries<G> geometryFactory, Class<V> geometryClass, CoordinateReferenceSystem defaultCRS, BinaryEncoding encoding) {
        super(geometryClass);
        this.geometryFactory = geometryFactory;
        this.defaultCRS = defaultCRS;
        this.encoding = encoding;
    }

    @Override
    public V getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws Exception {
        OptionalInt srid;
        byte[] wkb = this.encoding.getBytes(source, columnIndex);
        if (wkb == null) {
            return null;
        }
        GeometryWrapper geom = this.geometryFactory.parseWKB(ByteBuffer.wrap(wkb));
        CoordinateReferenceSystem crs = this.defaultCRS;
        if (stmts != null && (srid = geom.getSRID()).isPresent()) {
            crs = stmts.fetchCRS(srid.getAsInt());
        }
        if (crs != null) {
            geom.setCoordinateReferenceSystem(crs);
        }
        return (V)this.valueType.cast(this.geometryFactory.getGeometry(geom));
    }
}

