/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.impl.WeakReferenceThreadMap;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.impl.AuditContextUpdater;
import org.apache.hadoop.fs.s3a.commit.impl.CommitOperations;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.util.concurrent.HadoopThreadPoolExecutor;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitContext
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CommitContext.class);
    private final CommitOperations commitOperations;
    private final JobContext jobContext;
    private final WeakReferenceThreadMap<JsonSerialization<PendingSet>> pendingSetSerializer = new WeakReferenceThreadMap(k -> PendingSet.serializer(), null);
    private final WeakReferenceThreadMap<JsonSerialization<SinglePendingCommit>> singleCommitSerializer = new WeakReferenceThreadMap(k -> SinglePendingCommit.serializer(), null);
    private PoolSubmitter outerSubmitter;
    private PoolSubmitter innerSubmitter;
    private final Configuration conf;
    private final String jobId;
    private final AuditContextUpdater auditContextUpdater;
    private final int committerThreads;
    private final boolean collectIOStatistics;
    private final IOStatisticsContext ioStatisticsContext;

    public CommitContext(CommitOperations commitOperations, JobContext jobContext, int committerThreads, IOStatisticsContext ioStatisticsContext) {
        this.commitOperations = commitOperations;
        this.jobContext = jobContext;
        this.conf = jobContext.getConfiguration();
        JobID contextJobID = jobContext.getJobID();
        this.jobId = contextJobID != null ? contextJobID.toString() : "job-without-id-at-" + System.currentTimeMillis();
        this.collectIOStatistics = this.conf.getBoolean("fs.s3a.committer.experimental.collect.iostatistics", false);
        this.ioStatisticsContext = Objects.requireNonNull(ioStatisticsContext);
        this.auditContextUpdater = new AuditContextUpdater(jobContext);
        this.auditContextUpdater.updateCurrentAuditContext();
        this.committerThreads = committerThreads;
        this.buildSubmitters();
    }

    public CommitContext(CommitOperations commitOperations, Configuration conf, String jobId, int committerThreads, IOStatisticsContext ioStatisticsContext) {
        this.commitOperations = commitOperations;
        this.jobContext = null;
        this.conf = conf;
        this.jobId = jobId;
        this.collectIOStatistics = false;
        this.ioStatisticsContext = Objects.requireNonNull(ioStatisticsContext);
        this.auditContextUpdater = new AuditContextUpdater(jobId);
        this.auditContextUpdater.updateCurrentAuditContext();
        this.committerThreads = committerThreads;
        this.buildSubmitters();
    }

    private synchronized void buildSubmitters() {
        if (this.committerThreads != 0) {
            this.outerSubmitter = new PoolSubmitter(this.buildThreadPool(this.committerThreads));
        }
    }

    private ExecutorService buildThreadPool(int numThreads) {
        if (numThreads < 0) {
            numThreads *= -Runtime.getRuntime().availableProcessors();
        }
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (Object)"Cannot create a thread pool with no threads");
        LOG.debug("creating thread pool of size {}", (Object)numThreads);
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("s3a-committer-pool-" + this.jobId + "-%d").build();
        return new HadoopThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue(), factory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void commitOrFail(SinglePendingCommit commit) throws IOException {
        this.commitOperations.commitOrFail(commit);
    }

    public CommitOperations.MaybeIOE commit(SinglePendingCommit commit, String origin) {
        return this.commitOperations.commit(commit, origin);
    }

    public void abortSingleCommit(SinglePendingCommit commit) throws IOException {
        this.commitOperations.abortSingleCommit(commit);
    }

    public void revertCommit(SinglePendingCommit commit) throws IOException {
        this.commitOperations.revertCommit(commit);
    }

    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        this.commitOperations.abortMultipartCommit(destKey, uploadId);
    }

    @Override
    public synchronized void close() throws IOException {
        this.destroyThreadPools();
        this.auditContextUpdater.resetCurrentAuditContext();
    }

    public String toString() {
        return "CommitContext{}";
    }

    public JobContext getJobContext() {
        return this.jobContext;
    }

    public synchronized TaskPool.Submitter getOuterSubmitter() {
        return this.outerSubmitter;
    }

    public synchronized TaskPool.Submitter getInnerSubmitter() {
        if (this.innerSubmitter == null && this.committerThreads > 0) {
            this.innerSubmitter = new PoolSubmitter(this.buildThreadPool(this.committerThreads));
        }
        return this.innerSubmitter;
    }

    public JsonSerialization<SinglePendingCommit> getSinglePendingFileSerializer() {
        return (JsonSerialization)this.singleCommitSerializer.getForCurrentThread();
    }

    public JsonSerialization<PendingSet> getPendingSetSerializer() {
        return (JsonSerialization)this.pendingSetSerializer.getForCurrentThread();
    }

    private synchronized void destroyThreadPools() {
        try {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.outerSubmitter, this.innerSubmitter});
        }
        finally {
            this.outerSubmitter = null;
            this.innerSubmitter = null;
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean isCollectIOStatistics() {
        return this.collectIOStatistics;
    }

    public IOStatisticsContext getIOStatisticsContext() {
        return this.ioStatisticsContext;
    }

    public void switchToIOStatisticsContext() {
        IOStatisticsContext.setThreadIOStatisticsContext((IOStatisticsContext)this.ioStatisticsContext);
    }

    public void maybeResetIOStatisticsContext() {
        if (this.collectIOStatistics) {
            LOG.info("Resetting IO statistics context {}", (Object)this.ioStatisticsContext.getID());
            this.ioStatisticsContext.reset();
        }
    }

    private final class PoolSubmitter
    implements TaskPool.Submitter,
    Closeable {
        private ExecutorService executor;

        private PoolSubmitter(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.executor != null) {
                HadoopExecutors.shutdown((ExecutorService)this.executor, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            }
            this.executor = null;
        }

        public Future<?> submit(Runnable task) {
            return this.executor.submit(() -> {
                CommitContext.this.auditContextUpdater.updateCurrentAuditContext();
                try {
                    task.run();
                }
                finally {
                    CommitContext.this.auditContextUpdater.resetCurrentAuditContext();
                }
            });
        }
    }
}

