/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoderosm;

import java.util.function.Function;
import org.apache.baremaps.geocoderosm.OsmTags;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderOsmDocumentMapper
implements Function<Element, Document> {
    private static final Logger logger = LoggerFactory.getLogger(GeocoderOsmDocumentMapper.class);

    @Override
    public Document apply(Element element) {
        Document document = new Document();
        document.add((IndexableField)new StoredField("osm_id", element.getId()));
        document.add((IndexableField)new StoredField("osm_type", element.getClass().getSimpleName()));
        if (element.getTags().containsKey(OsmTags.NAME.key())) {
            document.add((IndexableField)new TextField(OsmTags.NAME.key(), element.getTags().get(OsmTags.NAME.key()).toString(), Field.Store.YES));
        }
        if (element instanceof Node) {
            Node node = (Node)element;
            document.add((IndexableField)LatLonShape.createIndexableFields((String)"polygon", (double)node.getLat(), (double)node.getLon())[0]);
            document.add((IndexableField)new StoredField("latitude", node.getLat().doubleValue()));
            document.add((IndexableField)new StoredField("longitude", node.getLon().doubleValue()));
        }
        if (element.getGeometry() != null && element.getGeometry().getGeometryType().equals("LineString")) {
            logger.debug("Geometry linestring ignored as not supported by Lucene Polygon.fromGeoJson: {}", (Object)element);
        }
        if (element.getGeometry() != null && !element.getGeometry().getGeometryType().equals("Point") && !element.getGeometry().getGeometryType().equals("LineString")) {
            GeoJsonWriter geojsonWriter = new GeoJsonWriter();
            geojsonWriter.setEncodeCRS(false);
            String geojson = geojsonWriter.write(element.getGeometry());
            try {
                Polygon[] polygons;
                for (Polygon polygon : polygons = Polygon.fromGeoJSON((String)geojson)) {
                    for (Field field : LatLonShape.createIndexableFields((String)"polygon", (Polygon)polygon)) {
                        document.add((IndexableField)field);
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Geometry ({}) failed indexing caused by: {}", (Object)element, (Object)e);
            }
        }
        if (element.getTags().containsKey(OsmTags.POPULATION.key())) {
            long population = Long.parseLong(element.getTags().get(OsmTags.POPULATION.key()).toString());
            document.add((IndexableField)new NumericDocValuesField(OsmTags.POPULATION.key(), population));
            document.add((IndexableField)new StoredField(OsmTags.POPULATION.key(), population));
        }
        return document;
    }
}

