/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RouteBuilder;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingPredicate;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingResultBuilder;
import com.linecorp.armeria.server.RoutingResultType;
import com.linecorp.armeria.server.RoutingStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class DefaultRoute
implements Route {
    private final PathMapping pathMapping;
    private final Set<HttpMethod> methods;
    private final Set<MediaType> consumes;
    private final Set<MediaType> produces;
    private final List<RoutingPredicate<QueryParams>> paramPredicates;
    private final List<RoutingPredicate<HttpHeaders>> headerPredicates;
    private final boolean isFallback;
    private final List<Route> excludedRoutes;
    private final int hashCode;
    private final int complexity;

    DefaultRoute(PathMapping pathMapping, Set<HttpMethod> methods, Set<MediaType> consumes, Set<MediaType> produces, List<RoutingPredicate<QueryParams>> paramPredicates, List<RoutingPredicate<HttpHeaders>> headerPredicates, boolean isFallback, List<Route> excludedRoutes) {
        this.pathMapping = Objects.requireNonNull(pathMapping, "pathMapping");
        Preconditions.checkArgument(!Objects.requireNonNull(methods, "methods").isEmpty(), "methods is empty.");
        this.methods = Sets.immutableEnumSet(methods);
        this.consumes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(consumes, "consumes"));
        this.produces = ImmutableSet.copyOf((Collection)Objects.requireNonNull(produces, "produces"));
        this.paramPredicates = ImmutableList.copyOf((Collection)Objects.requireNonNull(paramPredicates, "paramPredicates"));
        this.headerPredicates = ImmutableList.copyOf((Collection)Objects.requireNonNull(headerPredicates, "headerPredicates"));
        this.isFallback = isFallback;
        this.excludedRoutes = Objects.requireNonNull(excludedRoutes, "excludedRoutes").stream().map(excludedRoute -> excludedRoute.toBuilder().fallback(true).build()).collect(ImmutableList.toImmutableList());
        this.hashCode = Objects.hash(this.pathMapping, this.methods, this.consumes, this.produces, this.paramPredicates, this.headerPredicates, this.isFallback, this.excludedRoutes);
        int complexity = 0;
        if (!consumes.isEmpty()) {
            ++complexity;
        }
        if (!produces.isEmpty()) {
            complexity += 2;
        }
        if (!paramPredicates.isEmpty()) {
            complexity += 4;
        }
        if (!headerPredicates.isEmpty()) {
            complexity += 8;
        }
        if (!excludedRoutes.isEmpty()) {
            complexity += 16;
        }
        this.complexity = complexity;
    }

    @Override
    public RoutingResult apply(RoutingContext routingCtx, boolean isRouteDecorator) {
        List<MediaType> acceptTypes;
        RoutingResultBuilder builder = this.pathMapping.apply(Objects.requireNonNull(routingCtx, "routingCtx"));
        if (builder == null) {
            return RoutingResult.empty();
        }
        if (!this.methods.contains((Object)routingCtx.method())) {
            if (isRouteDecorator) {
                return RoutingResult.empty();
            }
            if (routingCtx.deferredStatusException() == null) {
                this.deferStatusException(routingCtx, HttpStatus.METHOD_NOT_ALLOWED);
            }
            return DefaultRoute.emptyOrCorsPreflightResult(routingCtx, builder);
        }
        MediaType contentType = routingCtx.contentType();
        boolean contentTypeMatched = false;
        if (contentType == null) {
            if (this.consumes.isEmpty()) {
                contentTypeMatched = true;
            }
        } else if (!this.consumes.isEmpty()) {
            Object consumeType;
            Iterator<MediaType> iterator = this.consumes.iterator();
            while (iterator.hasNext() && !(contentTypeMatched = contentType.belongsTo((MediaType)(consumeType = iterator.next())))) {
            }
            if (!contentTypeMatched) {
                if (isRouteDecorator) {
                    return RoutingResult.empty();
                }
                this.deferStatusException(routingCtx, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
                return DefaultRoute.emptyOrCorsPreflightResult(routingCtx, builder);
            }
        }
        if ((acceptTypes = routingCtx.acceptTypes()).isEmpty()) {
            if (contentTypeMatched && this.produces.isEmpty()) {
                builder.score(Integer.MAX_VALUE);
            }
            for (MediaType mediaType : this.produces) {
                if (DefaultRoute.isAnyType(mediaType)) continue;
                builder.negotiatedResponseMediaType(mediaType);
                break;
            }
        } else if (!this.produces.isEmpty()) {
            boolean found = false;
            for (MediaType produceType : this.produces) {
                for (int i = 0; i < acceptTypes.size(); ++i) {
                    MediaType acceptType = acceptTypes.get(i);
                    if (!produceType.belongsTo(acceptType)) continue;
                    int score = i == 0 ? Integer.MAX_VALUE : -1 * i;
                    builder.score(score);
                    if (!DefaultRoute.isAnyType(produceType)) {
                        builder.negotiatedResponseMediaType(produceType);
                    }
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (!found) {
                if (isRouteDecorator) {
                    return RoutingResult.empty();
                }
                this.deferStatusException(routingCtx, HttpStatus.NOT_ACCEPTABLE);
                return DefaultRoute.emptyOrCorsPreflightResult(routingCtx, builder);
            }
        }
        if (routingCtx.requiresMatchingParamsPredicates() && !this.paramPredicates.isEmpty()) {
            for (RoutingPredicate<QueryParams> routingPredicate : this.paramPredicates) {
                if (routingPredicate.test(routingCtx.params())) continue;
                return RoutingResult.empty();
            }
        }
        if (routingCtx.requiresMatchingHeadersPredicates() && !this.headerPredicates.isEmpty()) {
            for (RoutingPredicate<HttpHeaders> routingPredicate : this.headerPredicates) {
                if (routingPredicate.test(routingCtx.headers())) continue;
                return RoutingResult.empty();
            }
        }
        if (!this.excludedRoutes.isEmpty()) {
            for (Route route : this.excludedRoutes) {
                if (!route.apply(routingCtx, isRouteDecorator).isPresent()) continue;
                return RoutingResult.excluded();
            }
        }
        return builder.build();
    }

    private void deferStatusException(RoutingContext routingCtx, HttpStatus httpStatus) {
        if (this.isFallback) {
            return;
        }
        routingCtx.deferStatusException(HttpStatusException.of(httpStatus));
    }

    private static RoutingResult emptyOrCorsPreflightResult(RoutingContext routingCtx, RoutingResultBuilder builder) {
        if (routingCtx.status() == RoutingStatus.CORS_PREFLIGHT) {
            return builder.type(RoutingResultType.CORS_PREFLIGHT).build();
        }
        return RoutingResult.empty();
    }

    private static boolean isAnyType(MediaType contentType) {
        return "*".equals(contentType.type()) || "*".equals(contentType.subtype());
    }

    @Override
    public Set<String> paramNames() {
        return this.pathMapping.paramNames();
    }

    @Override
    public String patternString() {
        return this.pathMapping.patternString();
    }

    @Override
    public RoutePathType pathType() {
        return this.pathMapping.pathType();
    }

    @Override
    public List<String> paths() {
        return this.pathMapping.paths();
    }

    @Override
    public int complexity() {
        return this.complexity;
    }

    @Override
    public Set<HttpMethod> methods() {
        return this.methods;
    }

    @Override
    public Set<MediaType> consumes() {
        return this.consumes;
    }

    @Override
    public Set<MediaType> produces() {
        return this.produces;
    }

    @Override
    public boolean isFallback() {
        return this.isFallback;
    }

    @Override
    public List<Route> excludedRoutes() {
        return this.excludedRoutes;
    }

    @Override
    public RouteBuilder toBuilder() {
        return new RouteBuilder().pathMapping(this.pathMapping).methods(this.methods).consumes(this.consumes).produces(this.produces).matchesParams(this.paramPredicates).matchesHeaders(this.headerPredicates).fallback(this.isFallback).exclude(this.excludedRoutes);
    }

    @Override
    public Route withPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        if ("/".equals(prefix)) {
            return this;
        }
        return new DefaultRoute(this.pathMapping.withPrefix(prefix), this.methods, this.consumes, this.produces, this.paramPredicates, this.headerPredicates, this.isFallback, this.excludedRoutes);
    }

    @Override
    public boolean isCacheable() {
        return this.paramPredicates.isEmpty() && this.headerPredicates.isEmpty() && this.excludedRoutes().isEmpty();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRoute)) {
            return false;
        }
        DefaultRoute that = (DefaultRoute)o;
        return Objects.equals(this.pathMapping, that.pathMapping) && this.methods.equals(that.methods) && this.consumes.equals(that.consumes) && this.produces.equals(that.produces) && this.headerPredicates.equals(that.headerPredicates) && this.paramPredicates.equals(that.paramPredicates) && this.isFallback == that.isFallback && this.excludedRoutes.equals(that.excludedRoutes);
    }

    public String toString() {
        return this.patternString();
    }
}

