/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.jctools.queues;

import com.linecorp.armeria.internal.shaded.jctools.queues.MpscArrayQueue;
import com.linecorp.armeria.internal.shaded.jctools.queues.MpscCompoundQueueL0Pad;
import com.linecorp.armeria.internal.shaded.jctools.util.Pow2;
import com.linecorp.armeria.internal.shaded.jctools.util.RangeUtil;

abstract class MpscCompoundQueueColdFields<E>
extends MpscCompoundQueueL0Pad<E> {
    protected final int parallelQueues;
    protected final int parallelQueuesMask;
    protected final MpscArrayQueue<E>[] queues;

    MpscCompoundQueueColdFields(int capacity, int queueParallelism) {
        this.parallelQueues = Pow2.isPowerOfTwo(queueParallelism) ? queueParallelism : Pow2.roundToPowerOfTwo(queueParallelism) / 2;
        this.parallelQueuesMask = this.parallelQueues - 1;
        this.queues = new MpscArrayQueue[this.parallelQueues];
        int fullCapacity = Pow2.roundToPowerOfTwo(capacity);
        RangeUtil.checkGreaterThanOrEqual(fullCapacity, this.parallelQueues, "fullCapacity");
        for (int i = 0; i < this.parallelQueues; ++i) {
            this.queues[i] = new MpscArrayQueue(fullCapacity / this.parallelQueues);
        }
    }
}

