package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.ogcapi.model.PropertiesSchemaPropertiesValue;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Attributes of the features or rangetypes of a coverage. Defined by a subset of the JSON Schema for the properties of a feature
 **/
@ApiModel(description = "Attributes of the features or rangetypes of a coverage. Defined by a subset of the JSON Schema for the properties of a feature")
@JsonTypeName("propertiesSchema")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class PropertiesSchema   {
  public enum TypeEnum {

    OBJECT(String.valueOf("object"));


    private String value;

    TypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TypeEnum fromString(String s) {
        for (TypeEnum b : TypeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TypeEnum fromValue(String value) {
        for (TypeEnum b : TypeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TypeEnum type;
  private @Valid List<String> required = null;
  private @Valid Map<String, PropertiesSchemaPropertiesValue> properties = new HashMap<>();

  /**
   **/
  public PropertiesSchema type(TypeEnum type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Implements &#39;multiplicity&#39; by citing property &#39;name&#39; defined as &#39;additionalProperties&#39;
   **/
  public PropertiesSchema required(List<String> required) {
    this.required = required;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'multiplicity' by citing property 'name' defined as 'additionalProperties'")
  @JsonProperty("required")
 @Size(min=1)  public List<String> getRequired() {
    return required;
  }

  @JsonProperty("required")
  public void setRequired(List<String> required) {
    this.required = required;
  }

  public PropertiesSchema addRequiredItem(String requiredItem) {
    if (this.required == null) {
      this.required = new ArrayList<>();
    }

    this.required.add(requiredItem);
    return this;
  }

  public PropertiesSchema removeRequiredItem(String requiredItem) {
    if (requiredItem != null && this.required != null) {
      this.required.remove(requiredItem);
    }

    return this;
  }
  /**
   **/
  public PropertiesSchema properties(Map<String, PropertiesSchemaPropertiesValue> properties) {
    this.properties = properties;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("properties")
  @NotNull
  public Map<String, PropertiesSchemaPropertiesValue> getProperties() {
    return properties;
  }

  @JsonProperty("properties")
  public void setProperties(Map<String, PropertiesSchemaPropertiesValue> properties) {
    this.properties = properties;
  }

  public PropertiesSchema putPropertiesItem(String key, PropertiesSchemaPropertiesValue propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }

    this.properties.put(key, propertiesItem);
    return this;
  }

  public PropertiesSchema removePropertiesItem(PropertiesSchemaPropertiesValue propertiesItem) {
    if (propertiesItem != null && this.properties != null) {
      this.properties.remove(propertiesItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertiesSchema propertiesSchema = (PropertiesSchema) o;
    return Objects.equals(this.type, propertiesSchema.type) &&
        Objects.equals(this.required, propertiesSchema.required) &&
        Objects.equals(this.properties, propertiesSchema.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, required, properties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertiesSchema {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

