package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.baremaps.ogcapi.model.ExtentSpatial;
import org.apache.baremaps.ogcapi.model.ExtentTemporal;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The extent module only addresses spatial and temporal extents. This module extends extent by specifying how intervals and crs properties can be used to specify additional geometries.
 **/
@ApiModel(description = "The extent module only addresses spatial and temporal extents. This module extends extent by specifying how intervals and crs properties can be used to specify additional geometries.")
@JsonTypeName("extent-uad")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class ExtentUad   {
  private @Valid ExtentSpatial spatial;
  private @Valid ExtentTemporal temporal;

  /**
   **/
  public ExtentUad spatial(ExtentSpatial spatial) {
    this.spatial = spatial;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("spatial")
  public ExtentSpatial getSpatial() {
    return spatial;
  }

  @JsonProperty("spatial")
  public void setSpatial(ExtentSpatial spatial) {
    this.spatial = spatial;
  }

  /**
   **/
  public ExtentUad temporal(ExtentTemporal temporal) {
    this.temporal = temporal;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("temporal")
  public ExtentTemporal getTemporal() {
    return temporal;
  }

  @JsonProperty("temporal")
  public void setTemporal(ExtentTemporal temporal) {
    this.temporal = temporal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtentUad extentUad = (ExtentUad) o;
    return Objects.equals(this.spatial, extentUad.spatial) &&
        Objects.equals(this.temporal, extentUad.temporal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(spatial, temporal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtentUad {\n");
    
    sb.append("    spatial: ").append(toIndentedString(spatial)).append("\n");
    sb.append("    temporal: ").append(toIndentedString(temporal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

