/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.utils.BiHttpLifecycleObserver;
import io.servicetalk.http.utils.LoggingHttpLifecycleObserver;
import io.servicetalk.logging.api.LogLevel;

public final class HttpLifecycleObservers {
    private HttpLifecycleObservers() {
    }

    public static HttpLifecycleObserver logging(String loggerName, LogLevel logLevel) {
        return new LoggingHttpLifecycleObserver(loggerName, logLevel);
    }

    public static HttpLifecycleObserver combine(HttpLifecycleObserver first, HttpLifecycleObserver second) {
        return new BiHttpLifecycleObserver(first, second);
    }

    public static HttpLifecycleObserver combine(HttpLifecycleObserver first, HttpLifecycleObserver second, HttpLifecycleObserver ... others) {
        BiHttpLifecycleObserver bi = new BiHttpLifecycleObserver(first, second);
        if (others.length > 0) {
            for (HttpLifecycleObserver observer : others) {
                bi = new BiHttpLifecycleObserver(bi, observer);
            }
        }
        return bi;
    }
}

