/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeExecutionRejectedException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobMasterLeaveAware;
import org.apache.ignite.compute.ComputeUserUndeclaredException;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridJobContextImpl;
import org.apache.ignite.internal.GridJobExecuteResponse;
import org.apache.ignite.internal.GridJobSessionImpl;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.job.GridJobEventListener;
import org.apache.ignite.internal.processors.job.GridJobHoldListener;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.service.GridServiceNotFoundException;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class GridJobWorker
extends GridWorker
implements GridTimeoutObject {
    private static final ThreadLocal<Boolean> HOLD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private final long createTime;
    private volatile long startTime;
    private volatile long finishTime;
    private final GridKernalContext ctx;
    private final Object jobTopic;
    private final Object taskTopic;
    private byte[] jobBytes;
    private final ClusterNode taskNode;
    private final boolean internal;
    private final IgniteLogger log;
    private final Marshaller marsh;
    private final GridJobSessionImpl ses;
    private final GridJobContextImpl jobCtx;
    private final GridJobEventListener evtLsnr;
    private final GridDeployment dep;
    private final AtomicBoolean finishing = new AtomicBoolean();
    private final AtomicBoolean masterLeaveGuard = new AtomicBoolean();
    private volatile boolean timedOut;
    private volatile boolean sysCancelled;
    private volatile boolean sysStopping;
    private volatile boolean isStarted;
    private ComputeJob job;
    private final AtomicInteger held = new AtomicInteger();
    private final GridJobHoldListener holdLsnr;
    private final GridReservable partsReservation;
    private final AffinityTopologyVersion reqTopVer;
    private final String execName;
    private final SecurityContext secCtx;

    GridJobWorker(GridKernalContext ctx, GridDeployment dep, long createTime, GridJobSessionImpl ses, GridJobContextImpl jobCtx, byte[] jobBytes, ComputeJob job, ClusterNode taskNode, boolean internal, GridJobEventListener evtLsnr, GridJobHoldListener holdLsnr, GridReservable partsReservation, AffinityTopologyVersion reqTopVer, String execName) {
        super(ctx.igniteInstanceName(), "grid-job-worker", ctx.log(GridJobWorker.class));
        assert (ctx != null);
        assert (ses != null);
        assert (jobCtx != null);
        assert (taskNode != null);
        assert (evtLsnr != null);
        assert (dep != null);
        assert (holdLsnr != null);
        this.ctx = ctx;
        this.createTime = createTime;
        this.evtLsnr = evtLsnr;
        this.dep = dep;
        this.ses = ses;
        this.jobCtx = jobCtx;
        this.jobBytes = jobBytes;
        this.taskNode = taskNode;
        this.internal = internal;
        this.holdLsnr = holdLsnr;
        this.partsReservation = partsReservation;
        this.reqTopVer = reqTopVer;
        this.execName = execName;
        if (job != null) {
            this.job = job;
        }
        this.log = U.logger(ctx, logRef, this);
        this.marsh = ctx.config().getMarshaller();
        UUID locNodeId = ctx.discovery().localNode().id();
        this.jobTopic = GridTopic.TOPIC_JOB.topic(ses.getJobId(), locNodeId);
        this.taskTopic = GridTopic.TOPIC_TASK.topic(ses.getJobId(), locNodeId);
        this.secCtx = ctx.security().securityContext();
    }

    @Nullable
    public ComputeJob getJob() {
        return this.job;
    }

    public GridDeployment getDeployment() {
        return this.dep;
    }

    boolean isSystemCanceled() {
        return this.sysCancelled;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public GridReservable getPartsReservation() {
        return this.partsReservation;
    }

    public IgniteUuid getJobId() {
        IgniteUuid jobId = this.ses.getJobId();
        assert (jobId != null);
        return jobId;
    }

    public ComputeJobContext getJobContext() {
        return this.jobCtx;
    }

    Object getJobTopic() {
        return this.jobTopic;
    }

    Object getTaskTopic() {
        return this.taskTopic;
    }

    public GridJobSessionImpl getSession() {
        return this.ses;
    }

    public boolean isFinishing() {
        return this.finishing.get();
    }

    public ClusterNode getTaskNode() {
        return this.taskNode;
    }

    long getExecuteTime() {
        long startTime0 = this.startTime;
        long finishTime0 = this.finishTime;
        return startTime0 == 0L ? 0L : (finishTime0 == 0L ? U.currentTimeMillis() - startTime0 : finishTime0 - startTime0);
    }

    long getQueuedTime() {
        long startTime0 = this.startTime;
        return startTime0 == 0L ? U.currentTimeMillis() - this.createTime : startTime0 - this.createTime;
    }

    @Override
    public long endTime() {
        return this.ses.getEndTime();
    }

    @Override
    public IgniteUuid timeoutId() {
        IgniteUuid jobId = this.ses.getJobId();
        assert (jobId != null);
        return jobId;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public void onTimeout() {
        if (this.finishing.get()) {
            return;
        }
        this.timedOut = true;
        U.warn(this.log, "Job has timed out: " + this.ses);
        this.cancel();
        if (!this.internal && this.ctx.event().isRecordable(46)) {
            this.recordEvent(46, "Job has timed out: " + this.job);
        }
    }

    public void onStopping() {
        this.sysStopping = true;
    }

    public boolean held() {
        return this.held.get() > 0;
    }

    public boolean hold() {
        HOLD.set(true);
        boolean res = this.holdLsnr.onHeld(this);
        if (res) {
            this.held.incrementAndGet();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initialize(GridDeployment dep, Class<?> taskCls) {
        assert (dep != null);
        IgniteException ex = null;
        try {
            if (this.job == null) {
                MarshallerUtils.jobSenderVersion(this.taskNode.version());
                try {
                    this.job = (ComputeJob)U.unmarshal(this.marsh, this.jobBytes, U.resolveClassLoader(dep.classLoader(), this.ctx.config()));
                }
                finally {
                    MarshallerUtils.jobSenderVersion(null);
                }
                this.jobBytes = null;
            }
            this.ctx.resource().inject(dep, taskCls, this.job, this.ses, this.jobCtx);
            if (!this.internal && this.ctx.event().isRecordable(49)) {
                this.recordEvent(49, "Job got queued for computation.");
            }
            this.job = SecurityUtils.sandboxedProxy(this.ctx, ComputeJob.class, this.job);
        }
        catch (IgniteCheckedException e) {
            if (this.log.isDebugEnabled()) {
                U.error(this.log, "Failed to initialize job [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']', e);
            }
            ex = new IgniteException(e);
        }
        catch (Throwable e) {
            ex = this.handleThrowable(e);
            assert (ex != null);
            if (e instanceof Error) {
                throw e;
            }
        }
        finally {
            if (ex != null) {
                this.finishJob(null, ex, true);
            }
        }
        return ex == null;
    }

    @Override
    protected void body() {
        assert (this.job != null);
        this.startTime = U.currentTimeMillis();
        this.isStarted = true;
        this.evtLsnr.onJobStarted(this);
        if (!this.internal && this.ctx.event().isRecordable(44)) {
            this.recordEvent(44, null);
        }
        this.execute0(true);
    }

    public void execute() {
        this.execute0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute0(boolean skipNtf) {
        HOLD.set(false);
        try {
            IgniteException ex;
            Object res;
            boolean sndRes;
            block48: {
                if (this.partsReservation != null) {
                    try {
                        if (!this.partsReservation.reserve()) {
                            this.finishJob(null, null, true, true);
                            return;
                        }
                    }
                    catch (Exception e) {
                        IgniteException ex2 = new IgniteException("Failed to lock partitions [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']', e);
                        U.error(this.log, "Failed to lock partitions [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']', e);
                        this.finishJob(null, ex2, true);
                        return;
                    }
                }
                if (this.isCancelled()) {
                    super.cancel();
                }
                if (!skipNtf) {
                    if (this.holdLsnr.onUnheld(this)) {
                        this.held.decrementAndGet();
                    } else {
                        if (!this.log.isDebugEnabled()) return;
                        this.log.debug("Ignoring job execution (job was not held).");
                        return;
                    }
                }
                sndRes = true;
                res = null;
                ex = null;
                try {
                    this.ctx.job().currentTaskSession(this.ses);
                    if (this.reqTopVer != null) {
                        GridQueryProcessor.setRequestAffinityTopologyVersion(this.reqTopVer);
                    }
                    if (this.isTimedOut()) {
                        sndRes = false;
                        break block48;
                    }
                    res = U.wrapThreadLoader(this.dep.classLoader(), new Callable<Object>(){

                        @Override
                        @Nullable
                        public Object call() {
                            try {
                                if (GridJobWorker.this.internal && GridJobWorker.this.ctx.config().isPeerClassLoadingEnabled()) {
                                    GridJobWorker.this.ctx.job().internal(true);
                                }
                                Object object = GridJobWorker.this.job.execute();
                                return object;
                            }
                            finally {
                                if (GridJobWorker.this.internal && GridJobWorker.this.ctx.config().isPeerClassLoadingEnabled()) {
                                    GridJobWorker.this.ctx.job().internal(false);
                                }
                            }
                        }
                    });
                    if (!this.log.isDebugEnabled()) break block48;
                    this.log.debug(S.toString("Job execution has successfully finished", "job", (Object)this.job, false, "res", res, true));
                }
                catch (IgniteException e) {
                    if (this.sysStopping && e.hasCause(IgniteInterruptedCheckedException.class, InterruptedException.class)) {
                        ex = this.handleThrowable(e);
                        assert (ex != null);
                    } else {
                        if (X.hasCause((Throwable)e, InterruptedException.class)) {
                            if (this.log.isDebugEnabled()) {
                                U.error(this.log, "Job was cancelled [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']', e);
                            }
                        } else if (X.hasCause((Throwable)e, GridServiceNotFoundException.class) || X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                            if (this.log.isDebugEnabled()) {
                                LT.error(this.log, e, "Failed to execute job [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']');
                            }
                        } else {
                            String msg = "Failed to execute job [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']';
                            if (X.hasCause((Throwable)e, OutOfMemoryError.class)) {
                                U.error(this.log, msg, e);
                                this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                            } else if (this.log.isDebugEnabled()) {
                                U.error(this.log, msg, e);
                            }
                        }
                        ex = e;
                    }
                    if (!HOLD.get().booleanValue()) {
                        this.finishJob(res, ex, sndRes);
                    } else {
                        HOLD.set(false);
                    }
                    this.ctx.job().currentTaskSession(null);
                    if (this.reqTopVer == null) return;
                    GridQueryProcessor.setRequestAffinityTopologyVersion(null);
                    return;
                }
                catch (Throwable e2) {
                    ex = this.handleThrowable(e2);
                    assert (ex != null);
                    if (e2 instanceof Error) {
                        throw (Error)e2;
                    }
                    if (!HOLD.get().booleanValue()) {
                        this.finishJob(res, ex, sndRes);
                    } else {
                        HOLD.set(false);
                    }
                    this.ctx.job().currentTaskSession(null);
                    if (this.reqTopVer == null) return;
                    {
                        catch (Throwable throwable) {
                            if (!HOLD.get().booleanValue()) {
                                this.finishJob(res, ex, sndRes);
                            } else {
                                HOLD.set(false);
                            }
                            this.ctx.job().currentTaskSession(null);
                            if (this.reqTopVer == null) throw throwable;
                            GridQueryProcessor.setRequestAffinityTopologyVersion(null);
                            throw throwable;
                        }
                    }
                    GridQueryProcessor.setRequestAffinityTopologyVersion(null);
                    return;
                }
            }
            if (!HOLD.get().booleanValue()) {
                this.finishJob(res, ex, sndRes);
            } else {
                HOLD.set(false);
            }
            this.ctx.job().currentTaskSession(null);
            if (this.reqTopVer == null) return;
            GridQueryProcessor.setRequestAffinityTopologyVersion(null);
            return;
        }
        finally {
            if (this.partsReservation != null) {
                this.partsReservation.release();
            }
        }
    }

    private IgniteException handleThrowable(Throwable e) {
        String msg = null;
        IgniteException ex = null;
        if (e instanceof InterruptedException && !this.sysStopping) {
            msg = "Failed to execute job due to interrupted exception.";
            ex = new IgniteException(msg, e);
        } else if ((e instanceof NoClassDefFoundError || e instanceof ClassNotFoundException) && this.ctx.config().isPeerClassLoadingEnabled()) {
            msg = "Failed to execute job due to class or resource loading exception (make sure that task originating node is still in grid and requested class is in the task class path) [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']';
            ex = new ComputeUserUndeclaredException(msg, e);
        } else if (this.sysStopping && X.hasCause(e, InterruptedException.class, IgniteInterruptedCheckedException.class)) {
            msg = "Job got interrupted due to system stop (will attempt failover).";
            ex = new ComputeExecutionRejectedException(e);
        }
        if (msg == null) {
            msg = "Failed to execute job due to unexpected runtime exception [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ", err=" + e.getMessage() + ']';
            ex = new ComputeUserUndeclaredException(msg, e);
        }
        assert (msg != null);
        assert (ex != null);
        if (this.log.isDebugEnabled()) {
            U.error(this.log, msg, e);
        }
        return ex;
    }

    @Override
    public void cancel() {
        this.cancel(false);
    }

    public void cancel(boolean sys) {
        block6: {
            try {
                super.cancel();
                final ComputeJob job0 = this.job;
                if (sys) {
                    this.sysCancelled = true;
                }
                if (job0 != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Cancelling job: " + this.ses);
                    }
                    U.wrapThreadLoader(this.dep.classLoader(), new IgniteRunnable(){

                        @Override
                        public void run() {
                            try (OperationSecurityContext c = GridJobWorker.this.ctx.security().withContext(GridJobWorker.this.secCtx);){
                                job0.cancel();
                            }
                        }
                    });
                }
                if (!this.internal && this.ctx.event().isRecordable(50)) {
                    this.recordEvent(50, "Job was cancelled: " + job0);
                }
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to cancel job due to undeclared user exception [jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ']', e);
                if (!(e instanceof Error)) break block6;
                throw e;
            }
        }
    }

    public String executorName() {
        return this.execName;
    }

    private void recordEvent(int evtType, @Nullable String msg) {
        assert (this.ctx.event().isRecordable(evtType));
        assert (!this.internal);
        JobEvent evt = new JobEvent();
        evt.jobId(this.ses.getJobId());
        evt.message(msg);
        evt.node(this.ctx.discovery().localNode());
        evt.taskName(this.ses.getTaskName());
        evt.taskClassName(this.ses.getTaskClassName());
        evt.taskSessionId(this.ses.getId());
        evt.type(evtType);
        evt.taskNode(this.taskNode);
        evt.taskSubjectId(this.ses.subjectId());
        this.ctx.event().record(evt);
    }

    void finishJob(@Nullable Object res, @Nullable IgniteException ex, boolean sndReply) {
        this.finishJob(res, ex, sndReply, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void finishJob(@Nullable Object res, @Nullable IgniteException ex, boolean sndReply, boolean retry) {
        block48: {
            if (!this.finishing.compareAndSet(false, true)) {
                return;
            }
            if (sndReply) {
                sndReply = !this.sysCancelled;
            }
            ClusterNode sndNode = this.ctx.discovery().node(this.taskNode.id());
            this.finishTime = U.currentTimeMillis();
            Collection<IgniteBiTuple<Integer, String>> evts = null;
            try {
                if (this.ses.isFullSupport()) {
                    this.evtLsnr.onBeforeJobResponseSent(this);
                }
                if (!this.isTimedOut()) {
                    if (sndReply) {
                        if (sndNode == null) {
                            this.onMasterNodeLeft();
                            U.warn(this.log, "Failed to reply to sender node because it left grid [nodeId=" + this.taskNode.id() + ", ses=" + this.ses + ", jobId=" + this.ses.getJobId() + ", job=" + this.job + ']');
                            if (!this.internal && this.ctx.event().isRecordable(48)) {
                                evts = this.addEvent(evts, 48, "Job reply failed (task node left grid): " + this.job);
                            }
                            break block48;
                        }
                        try {
                            void var8_13;
                            byte[] resBytes = null;
                            Object var8_10 = null;
                            byte[] attrBytes = null;
                            boolean loc = this.ctx.localNodeId().equals(sndNode.id()) && !this.ctx.config().isMarshalLocalJobs();
                            Map<Object, Object> attrs = this.jobCtx.getAttributes();
                            if (!loc) {
                                try {
                                    resBytes = U.marshal(this.marsh, res);
                                }
                                catch (IgniteCheckedException e) {
                                    resBytes = U.marshal(this.marsh, null);
                                    if (ex != null) {
                                        ex.addSuppressed(e);
                                    } else {
                                        ex = U.convertException(e);
                                    }
                                    this.logError("Failed to serialize job response [nodeId=" + this.taskNode.id() + ", ses=" + this.ses + ", jobId=" + this.ses.getJobId() + ", job=" + this.job + ", resCls=" + (res == null ? null : res.getClass()) + ']', e);
                                }
                                try {
                                    attrBytes = U.marshal(this.marsh, attrs);
                                }
                                catch (IgniteCheckedException e) {
                                    attrBytes = U.marshal(this.marsh, Collections.emptyMap());
                                    if (ex != null) {
                                        ex.addSuppressed(e);
                                    } else {
                                        ex = U.convertException(e);
                                    }
                                    this.logError("Failed to serialize job attributes [nodeId=" + this.taskNode.id() + ", ses=" + this.ses + ", jobId=" + this.ses.getJobId() + ", job=" + this.job + ", attrs=" + attrs + ']', e);
                                }
                                try {
                                    byte[] byArray = U.marshal(this.marsh, (Object)ex);
                                }
                                catch (IgniteCheckedException e) {
                                    String msg = "Failed to serialize job exception [nodeId=" + this.taskNode.id() + ", ses=" + this.ses + ", jobId=" + this.ses.getJobId() + ", job=" + this.job + ", msg=\"" + e.getMessage() + "\"]";
                                    ex = new IgniteException(msg);
                                    this.logError(msg, e);
                                    byte[] byArray = U.marshal(this.marsh, (Object)ex);
                                }
                            }
                            if (ex != null) {
                                if (this.isStarted) {
                                    if (!this.internal && this.ctx.event().isRecordable(48)) {
                                        evts = this.addEvent(evts, 48, "Job failed due to exception [ex=" + ex + ", job=" + this.job + ']');
                                    }
                                } else if (!this.internal && this.ctx.event().isRecordable(47)) {
                                    evts = this.addEvent(evts, 47, "Job has not been started [ex=" + ex + ", job=" + this.job + ']');
                                }
                            } else if (!this.internal && this.ctx.event().isRecordable(45)) {
                                evts = this.addEvent(evts, 45, null);
                            }
                            GridJobExecuteResponse jobRes = new GridJobExecuteResponse(this.ctx.localNodeId(), this.ses.getId(), this.ses.getJobId(), (byte[])var8_13, loc ? ex : null, resBytes, loc ? res : null, attrBytes, loc ? attrs : null, this.isCancelled(), retry ? this.ctx.cache().context().exchange().readyAffinityVersion() : null);
                            long timeout = this.ses.getEndTime() - U.currentTimeMillis();
                            if (timeout <= 0L) {
                                timeout = 1L;
                            }
                            if (this.ses.isFullSupport()) {
                                this.ctx.io().sendOrderedMessage(sndNode, this.taskTopic, jobRes, this.internal ? (byte)3 : 2, timeout, false);
                                break block48;
                            }
                            if (this.ctx.localNodeId().equals(sndNode.id())) {
                                this.ctx.task().processJobExecuteResponse(this.ctx.localNodeId(), jobRes);
                                break block48;
                            }
                            this.ctx.io().sendToGridTopic(sndNode, GridTopic.TOPIC_TASK, (Message)jobRes, this.internal ? (byte)3 : 2);
                        }
                        catch (IgniteCheckedException e) {
                            if (e instanceof ClusterTopologyCheckedException || this.isDeadNode(this.taskNode.id())) {
                                this.onMasterNodeLeft();
                                U.warn(this.log, "Failed to reply to sender node because it left grid [nodeId=" + this.taskNode.id() + ", jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ", job=" + this.job + ']');
                            } else {
                                this.logError("Error sending reply for job [nodeId=" + sndNode.id() + ", jobId=" + this.ses.getJobId() + ", ses=" + this.ses + ", job=" + this.job + ']', e);
                            }
                            if (!this.internal && this.ctx.event().isRecordable(48)) {
                                evts = this.addEvent(evts, 48, "Failed to send reply for job [nodeId=" + this.taskNode.id() + ", job=" + this.job + ']');
                            }
                            break block48;
                        }
                        catch (Exception e) {
                            String string = "Failed to send reply for job [nodeId=" + this.taskNode.id() + ", job=" + this.job + ']';
                            this.logError(string, e);
                            if (!this.internal && this.ctx.event().isRecordable(48)) {
                                evts = this.addEvent(evts, 48, string);
                            }
                            break block48;
                        }
                    }
                    if (ex != null) {
                        if (this.isStarted) {
                            if (!this.internal && this.ctx.event().isRecordable(48)) {
                                evts = this.addEvent(evts, 48, "Job failed due to exception [ex=" + ex + ", job=" + this.job + ']');
                            }
                        } else if (!this.internal && this.ctx.event().isRecordable(47)) {
                            evts = this.addEvent(evts, 47, "Job has not been started [ex=" + ex + ", job=" + this.job + ']');
                        }
                    } else if (!this.internal && this.ctx.event().isRecordable(45)) {
                        evts = this.addEvent(evts, 45, null);
                    }
                    break block48;
                }
                if (!this.internal && this.ctx.event().isRecordable(48)) {
                    evts = this.addEvent(evts, 48, "Job failed due to timeout: " + this.job);
                }
            }
            finally {
                if (evts != null) {
                    for (IgniteBiTuple igniteBiTuple : evts) {
                        this.recordEvent((Integer)igniteBiTuple.get1(), (String)igniteBiTuple.get2());
                    }
                }
                this.evtLsnr.onJobFinished(this);
            }
        }
    }

    private void logError(String msg, @Nullable Throwable e) {
        if (e != null && (this.log.isDebugEnabled() || !X.hasCause(e, NodeStoppingException.class))) {
            U.error(this.log, msg, e);
        }
    }

    boolean onMasterNodeLeft() {
        if (this.job instanceof ComputeJobMasterLeaveAware) {
            if (this.masterLeaveGuard.compareAndSet(false, true)) {
                try {
                    ((ComputeJobMasterLeaveAware)((Object)this.job)).onMasterNodeLeft(this.ses.session());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Successfully executed ComputeJobMasterLeaveAware.onMasterNodeLeft() callback [nodeId=" + this.taskNode.id() + ", jobId=" + this.ses.getJobId() + ", job=" + this.job + ']');
                    }
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to execute ComputeJobMasterLeaveAware.onMasterNodeLeft() callback [nodeId=" + this.taskNode.id() + ", jobId=" + this.ses.getJobId() + ", job=" + this.job + ']', e);
                }
            }
            return true;
        }
        return false;
    }

    Collection<IgniteBiTuple<Integer, String>> addEvent(@Nullable Collection<IgniteBiTuple<Integer, String>> evts, Integer evt, @Nullable String msg) {
        assert (this.ctx.event().isRecordable(evt));
        assert (!this.internal);
        if (evts == null) {
            evts = new ArrayList<IgniteBiTuple<Integer, String>>();
        }
        evts.add(F.t(evt, msg));
        return evts;
    }

    private boolean isDeadNode(UUID uid) {
        return this.ctx.discovery().node(uid) == null || !this.ctx.discovery().pingNodeNoError(uid);
    }

    public int hashCode() {
        IgniteUuid jobId = this.ses.getJobId();
        assert (jobId != null);
        return jobId.hashCode();
    }

    @Override
    public String toString() {
        return S.toString(GridJobWorker.class, this);
    }
}

