/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridReflectionCache
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private static final Comparator<Field> FIELD_NAME_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field f1, Field f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    private static final Comparator<Method> METHOD_NAME_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method m1, Method m2) {
            return m1.getName().compareTo(m2.getName());
        }
    };
    public static final int DFLT_REFLECTION_CACHE_SIZE = 128;
    private static final int CACHE_SIZE = Integer.getInteger("IGNITE_REFLECTION_CACHE_SIZE", 128);
    private ConcurrentMap<Class, List<Field>> fields = new GridBoundedConcurrentLinkedHashMap<Class, List<Field>>(CACHE_SIZE, CACHE_SIZE);
    private ConcurrentMap<Class, List<Method>> mtds = new GridBoundedConcurrentLinkedHashMap<Class, List<Method>>(CACHE_SIZE, CACHE_SIZE);
    private IgnitePredicate<Field> fp;
    private IgnitePredicate<Method> mp;

    public GridReflectionCache() {
    }

    public GridReflectionCache(@Nullable IgnitePredicate<Field> fp, @Nullable IgnitePredicate<Method> mp) {
        this.fp = fp;
        this.mp = mp;
    }

    @Nullable
    public Object firstFieldValue(Object o) throws IgniteCheckedException {
        assert (o != null);
        Field f = this.firstField(o.getClass());
        if (f != null) {
            try {
                return f.get(o);
            }
            catch (IllegalAccessException e) {
                throw new IgniteCheckedException("Failed to access field for object [field=" + f + ", obj=" + o + "]", e);
            }
        }
        return null;
    }

    @Nullable
    public Object firstMethodValue(Object o) throws IgniteCheckedException {
        assert (o != null);
        Method m = this.firstMethod(o.getClass());
        if (m != null) {
            try {
                return m.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IgniteCheckedException("Failed to invoke method for object [mtd=" + m + ", obj=" + o + "]", e);
            }
        }
        return null;
    }

    @Nullable
    public Field firstField(Class<?> cls) {
        assert (cls != null);
        List<Field> l = this.fields(cls);
        return l.isEmpty() ? null : l.get(0);
    }

    @Nullable
    public Method firstMethod(Class<?> cls) {
        assert (cls != null);
        List<Method> l = this.methods(cls);
        return l.isEmpty() ? null : l.get(0);
    }

    public List<Field> fields(Class<?> cls) {
        assert (cls != null);
        ArrayList fieldsList = (ArrayList)this.fields.get(cls);
        if (fieldsList == null) {
            fieldsList = new ArrayList();
            for (Class<?> c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                ArrayList<Field> l = new ArrayList<Field>();
                for (Field f : c.getDeclaredFields()) {
                    if (this.fp != null && !this.fp.apply(f)) continue;
                    f.setAccessible(true);
                    l.add(f);
                }
                if (l.isEmpty()) continue;
                Collections.sort(l, FIELD_NAME_COMPARATOR);
                fieldsList.addAll(l);
            }
            this.fields.putIfAbsent(cls, fieldsList);
        }
        return fieldsList;
    }

    public List<Method> methods(Class<?> cls) {
        assert (cls != null);
        ArrayList mtdsList = (ArrayList)this.mtds.get(cls);
        if (mtdsList == null) {
            mtdsList = new ArrayList();
            for (Class<?> c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                ArrayList<Method> l = new ArrayList<Method>();
                for (Method m : c.getDeclaredMethods()) {
                    if (this.mp != null && !this.mp.apply(m)) continue;
                    m.setAccessible(true);
                    l.add(m);
                }
                if (l.isEmpty()) continue;
                Collections.sort(l, METHOD_NAME_COMPARATOR);
                mtdsList.addAll(l);
            }
            this.mtds.putIfAbsent(cls, mtdsList);
        }
        return mtdsList;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fp);
        out.writeObject(this.mp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fp = (IgnitePredicate)in.readObject();
        this.mp = (IgnitePredicate)in.readObject();
    }
}

