/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class Cloner {
    private final RelOptCluster cluster;
    private List<IgniteReceiver> remotes;

    Cloner(RelOptCluster cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fragment go(Fragment src) {
        try {
            this.remotes = new ArrayList<IgniteReceiver>();
            IgniteRel newRoot = this.visit(src.root());
            Fragment fragment = new Fragment(src.fragmentId(), newRoot, List.copyOf(this.remotes), src.serialized(), src.mapping());
            return fragment;
        }
        finally {
            this.remotes = null;
        }
    }

    public static IgniteRel clone(IgniteRel r) {
        Cloner c = new Cloner(r.getCluster());
        return c.visit(r);
    }

    private IgniteRel collect(IgniteRel rel) {
        if (rel instanceof IgniteReceiver && this.remotes != null) {
            this.remotes.add((IgniteReceiver)rel);
        }
        return rel;
    }

    public IgniteRel visit(IgniteRel rel) {
        return this.collect(rel.clone(this.cluster, Commons.transform(rel.getInputs(), rel0 -> this.visit((IgniteRel)rel0))));
    }
}

