/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.calcite.message.ExecutionContextAware;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class QueryBatchAcknowledgeMessage
implements ExecutionContextAware {
    private UUID queryId;
    private long fragmentId;
    private long exchangeId;
    private int batchId;

    public QueryBatchAcknowledgeMessage() {
    }

    public QueryBatchAcknowledgeMessage(UUID queryId, long fragmentId, long exchangeId, int batchId) {
        this.queryId = queryId;
        this.fragmentId = fragmentId;
        this.exchangeId = exchangeId;
        this.batchId = batchId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    public long exchangeId() {
        return this.exchangeId;
    }

    public int batchId() {
        return this.batchId;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("batchId", this.batchId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("exchangeId", this.exchangeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("fragmentId", this.fragmentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeUuid("queryId", this.queryId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.batchId = reader.readInt("batchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.exchangeId = reader.readLong("exchangeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.fragmentId = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.queryId = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchAcknowledgeMessage.class);
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_ACKNOWLEDGE_MESSAGE;
    }

    public byte fieldsCount() {
        return 4;
    }
}

