/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.calcite.message.CalciteMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class InboxCloseMessage
implements CalciteMessage {
    private UUID queryId;
    private long fragmentId;
    private long exchangeId;

    public InboxCloseMessage() {
    }

    public InboxCloseMessage(UUID queryId, long fragmentId, long exchangeId) {
        this.queryId = queryId;
        this.fragmentId = fragmentId;
        this.exchangeId = exchangeId;
    }

    public UUID queryId() {
        return this.queryId;
    }

    public long fragmentId() {
        return this.fragmentId;
    }

    public long exchangeId() {
        return this.exchangeId;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("exchangeId", this.exchangeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("fragmentId", this.fragmentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeUuid("queryId", this.queryId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.exchangeId = reader.readLong("exchangeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.fragmentId = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.queryId = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(InboxCloseMessage.class);
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_INBOX_CANCEL_MESSAGE;
    }

    public byte fieldsCount() {
        return 3;
    }
}

