/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeCondition;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class TreeIndexIterable<Row>
implements Iterable<Row> {
    private final TreeIndex<Row> idx;
    private final RangeIterable<Row> ranges;

    TreeIndexIterable(TreeIndex<Row> idx, RangeIterable<Row> ranges) {
        this.idx = idx;
        this.ranges = ranges;
    }

    @Override
    public synchronized Iterator<Row> iterator() {
        if (this.ranges == null) {
            return new CursorIteratorImpl(this.idx.find(null, null, true, true));
        }
        IgniteClosure & Serializable clo = (IgniteClosure & Serializable)range -> new CursorIteratorImpl(this.idx.find(range.lower(), range.upper(), range.lowerInclude(), range.upperInclude()));
        if (!this.ranges.multiBounds()) {
            Iterator it = this.ranges.iterator();
            if (it.hasNext()) {
                return (Iterator)clo.apply((Object)((RangeCondition)it.next()));
            }
            return Collections.emptyIterator();
        }
        return F.flat((Iterable)F.iterator(this.ranges, (IgniteClosure)clo, (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]));
    }

    private class CursorIteratorImpl
    extends GridIteratorAdapter<Row> {
        private final GridCursor<Row> cursor;
        private Row next;

        private CursorIteratorImpl(GridCursor<Row> cursor) {
            this.cursor = cursor;
        }

        public boolean hasNextX() throws IgniteCheckedException {
            this.advance();
            return this.next != null;
        }

        public Row nextX() throws IgniteCheckedException {
            this.advance();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object res = this.next;
            this.next = null;
            return res;
        }

        public void removeX() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        private void advance() throws IgniteCheckedException {
            assert (this.cursor != null);
            if (this.next != null) {
                return;
            }
            while (this.next == null && this.cursor.next()) {
                this.next = this.cursor.get();
            }
        }
    }
}

