/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Function;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.transactions.TransactionChanges;
import org.apache.ignite.internal.processors.query.calcite.exec.AbstractCacheColumnsScan;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.KeyFilteringCursor;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class TableScan<Row>
extends AbstractCacheColumnsScan<Row> {
    public TableScan(ExecutionContext<Row> ectx, CacheTableDescriptor desc, int[] parts, @Nullable ImmutableBitSet requiredColumns) {
        super(ectx, desc, parts, requiredColumns);
    }

    @Override
    protected Iterator<Row> createIterator() {
        return new IteratorImpl();
    }

    private class IteratorImpl
    extends GridIteratorAdapter<Row> {
        private final Queue<GridDhtLocalPartition> parts;
        private GridCursor<? extends CacheDataRow> cur;
        private final TransactionChanges<CacheDataRow> txChanges;
        private Iterator<CacheDataRow> txIter = Collections.emptyIterator();
        private Row next;

        private IteratorImpl() {
            assert (TableScan.this.reserved != null);
            this.parts = new ArrayDeque<GridDhtLocalPartition>(TableScan.this.reserved);
            this.txChanges = F.isEmpty(TableScan.this.ectx.getQryTxEntries()) ? TransactionChanges.empty() : TableScan.this.ectx.transactionChanges(TableScan.this.cctx.cacheId(), TableScan.this.cctx.isReplicated() ? null : TableScan.this.parts, Function.identity(), null);
        }

        public boolean hasNextX() throws IgniteCheckedException {
            this.advance();
            return this.next != null;
        }

        public Row nextX() throws IgniteCheckedException {
            this.advance();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object next = this.next;
            this.next = null;
            return next;
        }

        public void removeX() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        private void advance() throws IgniteCheckedException {
            assert (this.parts != null);
            if (this.next != null) {
                return;
            }
            while (true) {
                CacheDataRow row;
                if (this.cur == null) {
                    GridDhtLocalPartition part = this.parts.poll();
                    if (part == null) break;
                    this.cur = part.dataStore().cursor(TableScan.this.cctx.cacheId());
                    if (!this.txChanges.changedKeysEmpty()) {
                        this.cur = new KeyFilteringCursor<CacheDataRow>(this.cur, this.txChanges, CacheSearchRow::key);
                        this.txIter = F.iterator0((Iterable)this.txChanges.newAndUpdatedEntries(), (boolean)true, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)e -> e.key().partition() == part.id()});
                    }
                }
                if (this.cur.next()) {
                    row = (CacheDataRow)this.cur.get();
                } else {
                    CacheDataRow cacheDataRow = row = this.txIter.hasNext() ? this.txIter.next() : null;
                }
                if (row != null) {
                    if (row.expireTime() > 0L && row.expireTime() <= U.currentTimeMillis() || !TableScan.this.desc.match(row)) continue;
                    this.next = TableScan.this.desc.toRow(TableScan.this.ectx, row, TableScan.this.factory, TableScan.this.requiredColumns);
                    break;
                }
                this.cur = null;
            }
        }
    }
}

