/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.util.StringUtils;

public class CreateUser
extends DefineCommand {
    private String userName;
    private boolean admin;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean ifNotExists;
    private String comment;

    public CreateUser(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(Expression expression) {
        this.password = expression;
    }

    static void setSaltAndHash(User user, Session session, Expression expression, Expression expression2) {
        user.setSaltAndHash(CreateUser.getByteArray(session, expression), CreateUser.getByteArray(session, expression2));
    }

    private static byte[] getByteArray(Session session, Expression expression) {
        String string = expression.optimize(session).getValue(session).getString();
        return string == null ? new byte[]{} : StringUtils.convertHexToBytes(string);
    }

    static void setPassword(User user, Session session, Expression expression) {
        String string = expression.optimize(session).getValue(session).getString();
        char[] cArray = string == null ? new char[]{} : string.toCharArray();
        String string2 = user.getName();
        byte[] byArray = string2.length() == 0 && cArray.length == 0 ? new byte[]{} : SHA256.getKeyPasswordHash(string2, cArray);
        user.setUserPasswordHash(byArray);
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (database.findRole(this.userName) != null) {
            throw DbException.get(90069, this.userName);
        }
        if (database.findUser(this.userName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90033, this.userName);
        }
        int n = this.getObjectId();
        User user = new User(database, n, this.userName, false);
        user.setAdmin(this.admin);
        user.setComment(this.comment);
        if (this.hash != null && this.salt != null) {
            CreateUser.setSaltAndHash(user, this.session, this.salt, this.hash);
        } else if (this.password != null) {
            CreateUser.setPassword(user, this.session, this.password);
        } else {
            throw DbException.throwInternalError();
        }
        database.addDatabaseObject(this.session, user);
        return 0;
    }

    public void setSalt(Expression expression) {
        this.salt = expression;
    }

    public void setHash(Expression expression) {
        this.hash = expression;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public int getType() {
        return 32;
    }
}

