/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RelEnumTypes {
    private static final ImmutableMap<String, Enum<?>> ENUM_BY_NAME;

    private RelEnumTypes() {
    }

    private static void register(ImmutableMap.Builder<String, Enum<?>> builder, Class<? extends Enum> aClass) {
        for (Enum enumConstant : (Enum[])Nullness.castNonNull((Object)aClass.getEnumConstants())) {
            builder.put((Object)enumConstant.name(), (Object)enumConstant);
        }
    }

    public static @Nullable Object fromEnum(@Nullable Object value) {
        return value instanceof Enum ? RelEnumTypes.fromEnum((Enum)value) : value;
    }

    public static String fromEnum(Enum enumValue) {
        if (ENUM_BY_NAME.get((Object)enumValue.name()) != enumValue) {
            throw new AssertionError((Object)("cannot serialize enum value to JSON: " + enumValue.getDeclaringClass().getCanonicalName() + "." + enumValue));
        }
        return enumValue.name();
    }

    static <E extends Enum<E>> @NonNull E toEnum(String name) {
        return (E)((Enum)Objects.requireNonNull(ENUM_BY_NAME.get((Object)name)));
    }

    static {
        ImmutableMap.Builder enumByName = ImmutableMap.builder();
        RelEnumTypes.register(enumByName, JoinConditionType.class);
        RelEnumTypes.register(enumByName, JoinType.class);
        RelEnumTypes.register(enumByName, RexUnknownAs.class);
        RelEnumTypes.register(enumByName, SqlExplain.Depth.class);
        RelEnumTypes.register(enumByName, SqlExplainFormat.class);
        RelEnumTypes.register(enumByName, SqlExplainLevel.class);
        RelEnumTypes.register(enumByName, SqlInsertKeyword.class);
        RelEnumTypes.register(enumByName, SqlJsonConstructorNullClause.class);
        RelEnumTypes.register(enumByName, SqlJsonQueryWrapperBehavior.class);
        RelEnumTypes.register(enumByName, SqlJsonValueEmptyOrErrorBehavior.class);
        RelEnumTypes.register(enumByName, SqlMatchRecognize.AfterOption.class);
        RelEnumTypes.register(enumByName, SqlSelectKeyword.class);
        RelEnumTypes.register(enumByName, SqlTrimFunction.Flag.class);
        RelEnumTypes.register(enumByName, TimeUnitRange.class);
        RelEnumTypes.register(enumByName, TableModify.Operation.class);
        ENUM_BY_NAME = enumByName.build();
    }
}

