/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultSelect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryParserResult {
    private final QueryDescriptor qryDesc;
    private final QueryParameters qryParams;
    private final SqlFieldsQuery remainingQry;
    private final List<JdbcParameterMeta> paramsMeta;
    private final QueryParserResultSelect select;
    private final QueryParserResultDml dml;
    private final QueryParserResultCommand cmd;

    public QueryParserResult(QueryDescriptor qryDesc, QueryParameters qryParams, SqlFieldsQuery remainingQry, @NotNull List<JdbcParameterMeta> paramsMeta, @Nullable QueryParserResultSelect select, @Nullable QueryParserResultDml dml, @Nullable QueryParserResultCommand cmd) {
        assert (paramsMeta != null);
        this.qryDesc = qryDesc;
        this.qryParams = qryParams;
        this.remainingQry = remainingQry;
        this.paramsMeta = paramsMeta;
        this.select = select;
        this.dml = dml;
        this.cmd = cmd;
    }

    public QueryDescriptor queryDescriptor() {
        return this.qryDesc;
    }

    public QueryParameters queryParameters() {
        return this.qryParams;
    }

    @Nullable
    public SqlFieldsQuery remainingQuery() {
        return this.remainingQry;
    }

    @Nullable
    public QueryParserResultSelect select() {
        return this.select;
    }

    @Nullable
    public QueryParserResultDml dml() {
        return this.dml;
    }

    @Nullable
    public QueryParserResultCommand command() {
        return this.cmd;
    }

    public boolean isSelect() {
        return this.select != null;
    }

    public boolean isDml() {
        return this.dml != null;
    }

    public boolean isCommand() {
        return this.cmd != null;
    }

    public int parametersCount() {
        return this.paramsMeta.size();
    }

    @NotNull
    public List<JdbcParameterMeta> parametersMeta() {
        return this.paramsMeta;
    }
}

