/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.prometheus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Distribution;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class PrometheusExportUtils {
    @VisibleForTesting
    static final String SAMPLE_SUFFIX_BUCKET = "_bucket";
    @VisibleForTesting
    static final String SAMPLE_SUFFIX_COUNT = "_count";
    @VisibleForTesting
    static final String SAMPLE_SUFFIX_SUM = "_sum";
    @VisibleForTesting
    static final String LABEL_NAME_BUCKET_BOUND = "le";
    @VisibleForTesting
    static final String LABEL_NAME_QUANTILE = "quantile";

    static Collector.MetricFamilySamples createMetricFamilySamples(Metric metric, String namespace) {
        MetricDescriptor metricDescriptor = metric.getMetricDescriptor();
        String name = PrometheusExportUtils.getNamespacedName(metricDescriptor.getName(), namespace);
        Collector.Type type = PrometheusExportUtils.getType(metricDescriptor.getType());
        List<String> labelNames = PrometheusExportUtils.convertToLabelNames(metricDescriptor.getLabelKeys());
        ArrayList samples = Lists.newArrayList();
        for (TimeSeries timeSeries : metric.getTimeSeriesList()) {
            for (Point point : timeSeries.getPoints()) {
                samples.addAll(PrometheusExportUtils.getSamples(name, labelNames, timeSeries.getLabelValues(), point.getValue()));
            }
        }
        return new Collector.MetricFamilySamples(name, type, metricDescriptor.getDescription(), (List)samples);
    }

    static Collector.MetricFamilySamples createDescribableMetricFamilySamples(MetricDescriptor metricDescriptor, String namespace) {
        String name = PrometheusExportUtils.getNamespacedName(metricDescriptor.getName(), namespace);
        Collector.Type type = PrometheusExportUtils.getType(metricDescriptor.getType());
        List<String> labelNames = PrometheusExportUtils.convertToLabelNames(metricDescriptor.getLabelKeys());
        if (PrometheusExportUtils.containsDisallowedLeLabelForHistogram(labelNames, type)) {
            throw new IllegalStateException("Prometheus Histogram cannot have a label named 'le', because it is a reserved label for bucket boundaries. Please remove this key from your view.");
        }
        if (PrometheusExportUtils.containsDisallowedQuantileLabelForSummary(labelNames, type)) {
            throw new IllegalStateException("Prometheus Summary cannot have a label named 'quantile', because it is a reserved label. Please remove this key from your view.");
        }
        return new Collector.MetricFamilySamples(name, type, metricDescriptor.getDescription(), Collections.emptyList());
    }

    private static String getNamespacedName(String metricName, String namespace) {
        if (!namespace.isEmpty()) {
            if (!namespace.endsWith("/") && !namespace.endsWith("_")) {
                namespace = namespace + '_';
            }
            metricName = namespace + metricName;
        }
        return Collector.sanitizeMetricName((String)metricName);
    }

    @VisibleForTesting
    static Collector.Type getType(MetricDescriptor.Type type) {
        if (type == MetricDescriptor.Type.CUMULATIVE_INT64 || type == MetricDescriptor.Type.CUMULATIVE_DOUBLE) {
            return Collector.Type.COUNTER;
        }
        if (type == MetricDescriptor.Type.GAUGE_INT64 || type == MetricDescriptor.Type.GAUGE_DOUBLE) {
            return Collector.Type.GAUGE;
        }
        if (type == MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION || type == MetricDescriptor.Type.GAUGE_DISTRIBUTION) {
            return Collector.Type.HISTOGRAM;
        }
        if (type == MetricDescriptor.Type.SUMMARY) {
            return Collector.Type.SUMMARY;
        }
        return Collector.Type.UNTYPED;
    }

    @VisibleForTesting
    static List<Collector.MetricFamilySamples.Sample> getSamples(final String name, final List<String> labelNames, List<LabelValue> labelValuesList, Value value) {
        Preconditions.checkArgument((labelNames.size() == labelValuesList.size() ? 1 : 0) != 0, (Object)"Keys and Values don't have same size.");
        final ArrayList samples = Lists.newArrayList();
        final ArrayList<String> labelValues = new ArrayList<String>(labelValuesList.size());
        for (LabelValue labelValue : labelValuesList) {
            String val = labelValue == null ? "" : labelValue.getValue();
            labelValues.add(val == null ? "" : val);
        }
        return (List)value.match((Function)new Function<Double, List<Collector.MetricFamilySamples.Sample>>(){

            public List<Collector.MetricFamilySamples.Sample> apply(Double arg) {
                samples.add(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, arg.doubleValue()));
                return samples;
            }
        }, (Function)new Function<Long, List<Collector.MetricFamilySamples.Sample>>(){

            public List<Collector.MetricFamilySamples.Sample> apply(Long arg) {
                samples.add(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, (double)arg.longValue()));
                return samples;
            }
        }, (Function)new Function<Distribution, List<Collector.MetricFamilySamples.Sample>>(){

            public List<Collector.MetricFamilySamples.Sample> apply(Distribution arg) {
                Distribution.BucketOptions bucketOptions = arg.getBucketOptions();
                List boundaries = new ArrayList();
                if (bucketOptions != null) {
                    boundaries = (List)bucketOptions.match((Function)new Function<Distribution.BucketOptions.ExplicitOptions, List<Double>>(){

                        public List<Double> apply(Distribution.BucketOptions.ExplicitOptions arg) {
                            return arg.getBucketBoundaries();
                        }
                    }, Functions.throwIllegalArgumentException());
                }
                ArrayList<String> labelNamesWithLe = new ArrayList<String>(labelNames);
                labelNamesWithLe.add(PrometheusExportUtils.LABEL_NAME_BUCKET_BOUND);
                long cumulativeCount = 0L;
                for (int i = 0; i < arg.getBuckets().size(); ++i) {
                    ArrayList<String> labelValuesWithLe = new ArrayList<String>(labelValues);
                    String bucketBoundary = Collector.doubleToGoString((double)(i < boundaries.size() ? (Double)boundaries.get(i) : Double.POSITIVE_INFINITY));
                    labelValuesWithLe.add(bucketBoundary);
                    samples.add(new Collector.MetricFamilySamples.Sample(name + PrometheusExportUtils.SAMPLE_SUFFIX_BUCKET, labelNamesWithLe, labelValuesWithLe, (double)(cumulativeCount += ((Distribution.Bucket)arg.getBuckets().get(i)).getCount())));
                }
                samples.add(new Collector.MetricFamilySamples.Sample(name + PrometheusExportUtils.SAMPLE_SUFFIX_COUNT, labelNames, labelValues, (double)arg.getCount()));
                samples.add(new Collector.MetricFamilySamples.Sample(name + PrometheusExportUtils.SAMPLE_SUFFIX_SUM, labelNames, labelValues, arg.getSum()));
                return samples;
            }
        }, (Function)new Function<Summary, List<Collector.MetricFamilySamples.Sample>>(){

            public List<Collector.MetricFamilySamples.Sample> apply(Summary arg) {
                Double sum;
                Long count = arg.getCount();
                if (count != null) {
                    samples.add(new Collector.MetricFamilySamples.Sample(name + PrometheusExportUtils.SAMPLE_SUFFIX_COUNT, labelNames, labelValues, (double)count.longValue()));
                }
                if ((sum = arg.getSum()) != null) {
                    samples.add(new Collector.MetricFamilySamples.Sample(name + PrometheusExportUtils.SAMPLE_SUFFIX_SUM, labelNames, labelValues, sum.doubleValue()));
                }
                List valueAtPercentiles = arg.getSnapshot().getValueAtPercentiles();
                ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(labelNames);
                labelNamesWithQuantile.add(PrometheusExportUtils.LABEL_NAME_QUANTILE);
                for (Summary.Snapshot.ValueAtPercentile valueAtPercentile : valueAtPercentiles) {
                    ArrayList<String> labelValuesWithQuantile = new ArrayList<String>(labelValues);
                    labelValuesWithQuantile.add(Collector.doubleToGoString((double)(valueAtPercentile.getPercentile() / 100.0)));
                    samples.add(new Collector.MetricFamilySamples.Sample(name, labelNamesWithQuantile, labelValuesWithQuantile, valueAtPercentile.getValue()));
                }
                return samples;
            }
        }, Functions.throwIllegalArgumentException());
    }

    @VisibleForTesting
    static List<String> convertToLabelNames(List<LabelKey> labelKeys) {
        ArrayList<String> labelNames = new ArrayList<String>(labelKeys.size());
        for (LabelKey labelKey : labelKeys) {
            labelNames.add(Collector.sanitizeMetricName((String)labelKey.getKey()));
        }
        return labelNames;
    }

    static boolean containsDisallowedLeLabelForHistogram(List<String> labelNames, Collector.Type type) {
        if (!Collector.Type.HISTOGRAM.equals((Object)type)) {
            return false;
        }
        for (String label : labelNames) {
            if (!LABEL_NAME_BUCKET_BOUND.equals(label)) continue;
            return true;
        }
        return false;
    }

    static boolean containsDisallowedQuantileLabelForSummary(List<String> labelNames, Collector.Type type) {
        if (!Collector.Type.SUMMARY.equals((Object)type)) {
            return false;
        }
        for (String label : labelNames) {
            if (!LABEL_NAME_QUANTILE.equals(label)) continue;
            return true;
        }
        return false;
    }

    private PrometheusExportUtils() {
    }
}

