/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup.cmdline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    private static final Color VALUE_BORDER_COLOR = new Color(0xCDCDCD);
    private static final DateTimeFormatter RELEASE_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private static AboutDialog aboutDlg;
    private final String appName;
    private final String bannerSpec;
    private final String ver;
    private final LocalDate release;
    private final String copyright;
    private final GridBagConstraints gbc;
    private final Action closeAct = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (SwingUtilities.isEventDispatchThread());
            AboutDialog.this.dispose();
        }
    };
    private final JButton closeBtn = new JButton(this.closeAct);

    AboutDialog(String appName, String bannerSpec, String ver, LocalDate release, String copyright) {
        this.appName = appName;
        this.bannerSpec = bannerSpec;
        this.ver = ver;
        this.release = release;
        this.copyright = copyright;
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.initDialog();
    }

    private JPanel initComponents() {
        JPanel content = new JPanel(new BorderLayout(0, 5));
        content.add((Component)this.createBannerPanel(), "North");
        content.add((Component)this.createLicensePanel(), "Center");
        content.add((Component)this.createButtonPanel(), "South");
        return content;
    }

    private JPanel createBannerPanel() {
        JPanel bannerPanel = new JPanel(new FlowLayout(0, 10, 5));
        bannerPanel.setBackground(Color.WHITE);
        try {
            URL url = new URL(this.bannerSpec);
            BufferedImage image = ImageIO.read(url);
            bannerPanel.add(new JLabel(new ImageIcon(image)));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new BoxLayout(msgPanel, 1));
        msgPanel.setBackground(Color.WHITE);
        msgPanel.add(new JLabel("<html><b>About Ignite</b></html>"));
        msgPanel.add(Box.createVerticalStrut(5));
        msgPanel.add(new JLabel(this.appName));
        bannerPanel.add(msgPanel);
        return bannerPanel;
    }

    private GridBagConstraints gbcStrut() {
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 0;
        this.gbc.insets = new Insets(5, 0, 0, 0);
        return this.gbc;
    }

    private GridBagConstraints gbcSeparator() {
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 0;
        this.gbc.insets = new Insets(5, 10, 10, 10);
        return this.gbc;
    }

    private GridBagConstraints gbcLicenseLabel() {
        this.gbc.gridx = 0;
        this.gbc.gridwidth = -1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 10, 5, 0);
        return this.gbc;
    }

    private GridBagConstraints gbcLicenseField() {
        this.gbc.gridx = 1;
        this.gbc.gridwidth = -1;
        this.gbc.weightx = 400.0;
        this.gbc.insets = new Insets(0, 10, 5, 10);
        return this.gbc;
    }

    private JPanel createLicensePanel() {
        JPanel licPanel = new JPanel(new GridBagLayout());
        licPanel.add(Box.createVerticalGlue(), this.gbcStrut());
        this.addAboutItem(licPanel, "Version:", this.ver);
        this.addAboutItem(licPanel, "Release Date:", RELEASE_DATE_FORMATTER.format(this.release));
        this.addAboutItem(licPanel, "Copyright:", this.copyright);
        return licPanel;
    }

    private JPanel createButtonPanel() {
        this.closeBtn.setAction(this.closeAct);
        this.closeBtn.setToolTipText("<html><b>Closes</b> Dialog</html>");
        JPanel btnPanel = new JPanel();
        btnPanel.add(this.closeBtn);
        return btnPanel;
    }

    private void initDialog() {
        this.setContentPane(this.initComponents());
        this.pack();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.closeBtn);
        this.setEscAction(this.closeAct);
        this.setModal(true);
        this.setResizable(false);
    }

    private void addAboutItem(JComponent c, String name, Object val) {
        this.addAboutItem(c, name, val, null);
    }

    private void addAboutItem(JComponent c, String name, Object val, Border border) {
        String v = val != null ? val.toString() : "n/a";
        String tip = String.format("<html><b>%s</b> &#10159; %s</html>", name, val);
        JLabel lb = new JLabel(name);
        lb.setToolTipText(tip);
        JLabel field = new JLabel(v);
        field.setOpaque(true);
        field.setBackground(Color.WHITE);
        field.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(VALUE_BORDER_COLOR, 1), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        field.setToolTipText(tip);
        if (border != null) {
            field.setBorder(border);
        }
        c.add((Component)lb, this.gbcLicenseLabel());
        c.add((Component)field, this.gbcLicenseField());
    }

    private void setEscAction(ActionListener act) {
        assert (act != null);
        this.getRootPane().registerKeyboardAction(act, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static void centerShow(final String appName, final String bannerSpec, final String ver, final LocalDate release, final String copyright) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (aboutDlg == null) {
                    try {
                        aboutDlg = new AboutDialog(appName, bannerSpec, ver, release, copyright);
                        aboutDlg.setLocationRelativeTo(null);
                        aboutDlg.setVisible(true);
                    }
                    finally {
                        aboutDlg = null;
                    }
                } else {
                    aboutDlg.setLocationRelativeTo(null);
                    aboutDlg.toFront();
                }
            }
        });
    }
}

