/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.sharedfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsCheckpointData;

final class SharedFsUtils {
    private SharedFsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SharedFsCheckpointData read(File file, Marshaller m, IgniteLogger log) throws IOException, IgniteCheckedException {
        assert (file != null);
        assert (m != null);
        assert (log != null);
        FileInputStream in = new FileInputStream(file);
        try {
            SharedFsCheckpointData sharedFsCheckpointData = (SharedFsCheckpointData)U.unmarshal(m, in, U.gridClassLoader());
            return sharedFsCheckpointData;
        }
        finally {
            U.close(in, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(File file, SharedFsCheckpointData data, Marshaller m, IgniteLogger log) throws IOException, IgniteCheckedException {
        assert (file != null);
        assert (m != null);
        assert (data != null);
        assert (log != null);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            U.marshal(m, data, out);
        }
        finally {
            U.close(out, log);
        }
    }
}

