/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlIndexColumn;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class SqlCreateIndexCommand
implements SqlCommand {
    private String schemaName;
    private String tblName;
    private String idxName;
    private boolean ifNotExists;
    private boolean spatial;
    private int parallel;
    @GridToStringInclude
    private Collection<SqlIndexColumn> cols;
    @GridToStringExclude
    private Set<String> colNames;
    private int inlineSize = -1;

    public SqlCreateIndexCommand() {
    }

    public SqlCreateIndexCommand(String schemaName, @Nullable String tblName, String idxName, boolean ifNotExists, Collection<SqlIndexColumn> cols, boolean spatial, int parallel, int inlineSize) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.idxName = idxName;
        this.ifNotExists = ifNotExists;
        this.spatial = spatial;
        this.parallel = parallel;
        this.inlineSize = inlineSize;
        this.cols = cols;
        this.colNames = new HashSet<String>();
        for (SqlIndexColumn col : cols) {
            if (this.colNames.add(col.name())) continue;
            throw new IllegalArgumentException("Column already defined: " + col.name());
        }
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String indexName() {
        return this.idxName;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public int parallel() {
        return this.parallel;
    }

    public boolean spatial() {
        return this.spatial;
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    public SqlCreateIndexCommand spatial(boolean spatial) {
        this.spatial = spatial;
        return this;
    }

    public Collection<SqlIndexColumn> columns() {
        return this.cols != null ? this.cols : Collections.emptySet();
    }

    @Override
    public SqlCommand parse(SqlLexer lex) {
        this.ifNotExists = SqlParserUtils.parseIfNotExists(lex);
        this.idxName = SqlCreateIndexCommand.parseIndexName(lex);
        SqlParserUtils.skipIfMatchesKeyword(lex, "ON");
        SqlQualifiedName tblQName = SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
        this.schemaName = tblQName.schemaName();
        this.tblName = tblQName.name();
        this.parseColumnList(lex);
        this.parseIndexProperties(lex);
        return this;
    }

    @Nullable
    private static String parseIndexName(SqlLexer lex) {
        if (SqlParserUtils.matchesKeyword(lex.lookAhead(), "ON")) {
            return null;
        }
        return SqlParserUtils.parseIdentifier(lex, "IF");
    }

    private void parseColumnList(SqlLexer lex) {
        if (!lex.shift() || lex.tokenType() != SqlLexerTokenType.PARENTHESIS_LEFT) {
            throw SqlParserUtils.errorUnexpectedToken(lex, "(");
        }
        do {
            this.parseIndexColumn(lex);
        } while (!SqlParserUtils.skipCommaOrRightParenthesis(lex));
    }

    private void parseIndexColumn(SqlLexer lex) {
        String name = SqlParserUtils.parseIdentifier(lex, new String[0]);
        boolean desc = false;
        SqlLexerToken nextToken = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(nextToken, "ASC") || SqlParserUtils.matchesKeyword(nextToken, "DESC")) {
            lex.shift();
            if (SqlParserUtils.matchesKeyword(lex, "DESC")) {
                desc = true;
            }
        }
        this.addColumn(lex, new SqlIndexColumn(name, desc));
    }

    private void addColumn(SqlLexer lex, SqlIndexColumn col) {
        if (this.cols == null) {
            this.cols = new LinkedList<SqlIndexColumn>();
            this.colNames = new HashSet<String>();
        }
        if (!this.colNames.add(col.name())) {
            throw SqlParserUtils.error(lex, "Column already defined: " + col.name());
        }
        this.cols.add(col);
    }

    private void parseIndexProperties(SqlLexer lex) {
        SqlLexerToken token;
        HashSet<String> foundProps = new HashSet<String>();
        block8: while ((token = lex.lookAhead()).tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (token.token()) {
                case "PARALLEL": {
                    this.parallel = this.getIntProperty(lex, "PARALLEL", foundProps);
                    if (this.parallel >= 0) continue block8;
                    throw SqlParserUtils.error(lex, "Illegal PARALLEL value. Should be positive: " + this.parallel);
                }
                case "INLINE_SIZE": {
                    this.inlineSize = this.getIntProperty(lex, "INLINE_SIZE", foundProps);
                    if (this.inlineSize >= 0) continue block8;
                    throw SqlParserUtils.error(lex, "Illegal INLINE_SIZE value. Should be positive: " + this.inlineSize);
                }
            }
            return;
        }
    }

    private Integer getIntProperty(SqlLexer lex, String keyword, Set<String> foundProps) {
        if (foundProps.contains(keyword)) {
            throw SqlParserUtils.error(lex, "Only one " + keyword + " clause may be specified.");
        }
        foundProps.add(keyword);
        lex.shift();
        return SqlParserUtils.parseInt(lex);
    }

    public String toString() {
        return S.toString(SqlCreateIndexCommand.class, this);
    }
}

