/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

final class DistributedMetaStorageHistoryItem
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final DistributedMetaStorageHistoryItem[] EMPTY_ARRAY = new DistributedMetaStorageHistoryItem[0];
    @GridToStringInclude
    private String[] keys;
    @GridToStringInclude
    private byte[][] valBytesArr;
    private transient long longHash;

    public DistributedMetaStorageHistoryItem() {
    }

    public DistributedMetaStorageHistoryItem(String key, byte[] valBytes) {
        this.keys = new String[]{key};
        this.valBytesArr = new byte[][]{valBytes};
    }

    public DistributedMetaStorageHistoryItem(String[] keys, byte[][] valBytesArr) {
        assert (keys.length > 0);
        assert (keys.length == valBytesArr.length);
        this.keys = keys;
        this.valBytesArr = valBytesArr;
    }

    public long estimateSize() {
        int len = this.keys.length;
        long size = 8L + 8L * (long)len;
        for (int i = 0; i < len; ++i) {
            size += (long)(this.keys[i].length() * 2 + (this.valBytesArr[i] == null ? 0 : this.valBytesArr[i].length));
        }
        return size;
    }

    public String[] keys() {
        return this.keys;
    }

    public byte[][] valuesBytesArray() {
        return this.valBytesArr;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            U.writeString(out, this.keys[i]);
            U.writeByteArray(out, this.valBytesArr[i]);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException {
        int len = in.readInt();
        this.keys = new String[len];
        this.valBytesArr = new byte[len][];
        for (int i = 0; i < len; ++i) {
            this.keys[i] = U.readString(in);
            this.valBytesArr[i] = U.readByteArray(in);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedMetaStorageHistoryItem item = (DistributedMetaStorageHistoryItem)o;
        return Arrays.equals(this.keys, item.keys) && Arrays.deepEquals((Object[])this.valBytesArr, (Object[])item.valBytesArr);
    }

    public int hashCode() {
        return Long.hashCode(this.longHash());
    }

    public long longHash() {
        long hash = this.longHash;
        if (hash == 0L) {
            hash = 1L;
            for (String key : this.keys) {
                hash = hash * 31L + (long)key.hashCode();
            }
            for (byte[] valBytes : this.valBytesArr) {
                if (valBytes == null) {
                    hash *= 31L;
                    continue;
                }
                for (byte b : valBytes) {
                    hash = hash * 31L + (long)b;
                }
            }
            if (hash == 0L) {
                hash = 1L;
            }
            this.longHash = hash;
        }
        return hash;
    }

    public String toString() {
        return S.toString(DistributedMetaStorageHistoryItem.class, this);
    }
}

