/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCachePlainVersionedEntry<K, V>
implements GridCacheVersionedEntryEx<K, V> {
    @GridToStringInclude
    protected K key;
    @GridToStringInclude
    protected V val;
    private final long ttl;
    private final long expireTime;
    private final GridCacheVersion ver;
    private final boolean isStartVer;

    public GridCachePlainVersionedEntry(K key, @Nullable V val, long ttl, long expireTime, GridCacheVersion ver) {
        this(key, val, ttl, expireTime, ver, false);
    }

    public GridCachePlainVersionedEntry(K key, V val, long ttl, long expireTime, GridCacheVersion ver, boolean isStartVer) {
        this.key = key;
        this.val = val;
        this.ttl = ttl;
        this.expireTime = expireTime;
        this.ver = ver;
        this.isStartVer = isStartVer;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value(CacheObjectValueContext ctx) {
        return this.val;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public byte dataCenterId() {
        return this.ver.dataCenterId();
    }

    @Override
    public int topologyVersion() {
        return this.ver.topologyVersion();
    }

    @Override
    public long order() {
        return this.ver.order();
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    @Override
    public boolean isStartVersion() {
        return this.isStartVer;
    }

    public String toString() {
        return S.toString(GridCachePlainVersionedEntry.class, this);
    }
}

