/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class WALPointer
implements Serializable,
Comparable<WALPointer> {
    private static final long serialVersionUID = 0L;
    public static final int POINTER_SIZE = 16;
    private final long idx;
    private final int fileOff;
    private int len;

    public WALPointer(long idx, int fileOff, int len) {
        this.idx = idx;
        this.fileOff = fileOff;
        this.len = len;
    }

    public long index() {
        return this.idx;
    }

    public int fileOffset() {
        return this.fileOff;
    }

    public int length() {
        return this.len;
    }

    public void length(int len) {
        this.len = len;
    }

    public WALPointer next() {
        if (this.len == 0) {
            throw new IllegalStateException("Failed to calculate next WAL pointer (this pointer is a terminal): " + this);
        }
        return new WALPointer(this.idx, this.fileOff + this.len, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WALPointer)) {
            return false;
        }
        WALPointer that = (WALPointer)o;
        return this.idx == that.idx && this.fileOff == that.fileOff;
    }

    public int hashCode() {
        int res = (int)(this.idx ^ this.idx >>> 32);
        res = 31 * res + this.fileOff;
        return res;
    }

    @Override
    public int compareTo(@NotNull WALPointer o) {
        int res = Long.compare(this.idx, o.idx);
        return res == 0 ? Integer.compare(this.fileOff, o.fileOff) : res;
    }

    public String toString() {
        return S.toString(WALPointer.class, this);
    }
}

