/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheLockCandidatesList;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public final class GridCacheMvcc {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static volatile IgniteLogger log;
    private static final Comparator<GridCacheVersion> SER_VER_COMPARATOR;
    @GridToStringExclude
    private final GridCacheContext<?, ?> cctx;
    @GridToStringInclude
    private LinkedList<GridCacheMvccCandidate> locs;
    @GridToStringInclude
    private LinkedList<GridCacheMvccCandidate> rmts;

    public GridCacheMvcc(GridCacheContext<?, ?> cctx) {
        assert (cctx != null);
        this.cctx = cctx;
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridCacheMvcc.class);
        }
    }

    @Nullable
    GridCacheMvccCandidate anyOwner() {
        GridCacheMvccCandidate owner = this.localOwner();
        if (owner == null) {
            owner = this.remoteOwner();
        }
        return owner;
    }

    @Nullable
    public CacheLockCandidates allOwners() {
        CacheLockCandidates owners = this.localOwners();
        if (owners == null) {
            owners = this.remoteOwner();
        }
        return owners;
    }

    @Nullable
    private GridCacheMvccCandidate remoteOwner() {
        if (this.rmts != null) {
            assert (!this.rmts.isEmpty());
            GridCacheMvccCandidate first = this.rmts.getFirst();
            return first.used() && first.owner() ? first : null;
        }
        return null;
    }

    @Nullable
    public CacheLockCandidates localOwners() {
        if (this.locs != null) {
            assert (!this.locs.isEmpty());
            CacheLockCandidates owners = null;
            GridCacheMvccCandidate first = this.locs.getFirst();
            if (first.read()) {
                for (GridCacheMvccCandidate cand : this.locs) {
                    if (cand.owner()) {
                        assert (cand.read()) : this;
                        if (owners != null) {
                            CacheLockCandidatesList list;
                            if (owners.size() == 1) {
                                GridCacheMvccCandidate owner = owners.candidate(0);
                                list = new CacheLockCandidatesList();
                                owners = list;
                                ((CacheLockCandidatesList)owners).add(owner);
                            } else {
                                list = (CacheLockCandidatesList)owners;
                            }
                            list.add(cand);
                        } else {
                            owners = cand;
                        }
                    }
                    if (cand.read()) continue;
                    break;
                }
            } else if (first.owner()) {
                owners = first;
            }
            return owners;
        }
        return null;
    }

    @Nullable
    GridCacheMvccCandidate localOwner() {
        if (this.locs != null) {
            assert (!this.locs.isEmpty());
            GridCacheMvccCandidate first = this.locs.getFirst();
            return first.owner() ? first : null;
        }
        return null;
    }

    @Nullable
    private GridCacheMvccCandidate candidate(Iterable<GridCacheMvccCandidate> cands, GridCacheVersion ver) {
        assert (ver != null);
        if (cands != null) {
            for (GridCacheMvccCandidate c : cands) {
                if (!c.version().equals(ver)) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    private GridCacheMvccCandidate localCandidate(long threadId, boolean reentry) {
        if (this.locs != null) {
            for (GridCacheMvccCandidate cand : this.locs) {
                if (!cand.isHeldByThread(threadId) || cand.reentry() && !reentry) continue;
                return cand;
            }
        }
        return null;
    }

    private boolean compareSerializableVersion(GridCacheMvccCandidate cand, GridCacheMvccCandidate newCand) {
        assert (cand.serializable() && newCand.serializable());
        GridCacheVersion candOrder = cand.serializableOrder();
        assert (candOrder != null) : cand;
        GridCacheVersion newCandOrder = newCand.serializableOrder();
        assert (newCandOrder != null) : newCand;
        int cmp = SER_VER_COMPARATOR.compare(candOrder, newCandOrder);
        assert (cmp != 0);
        return cmp < 0;
    }

    private boolean add0(GridCacheMvccCandidate cand) {
        assert (cand != null);
        if (cand.local()) {
            if (this.locs == null) {
                this.locs = new LinkedList();
            }
            if (!cand.nearLocal()) {
                if (!this.locs.isEmpty()) {
                    if (cand.serializable()) {
                        Iterator<GridCacheMvccCandidate> it = this.locs.descendingIterator();
                        if (cand.read()) {
                            while (it.hasNext()) {
                                GridCacheMvccCandidate c = it.next();
                                if (!c.serializable()) {
                                    return false;
                                }
                                if (c.read()) continue;
                                if (!this.compareSerializableVersion(c, cand)) {
                                    return false;
                                }
                                break;
                            }
                        } else {
                            while (it.hasNext()) {
                                GridCacheMvccCandidate c = it.next();
                                if (!c.serializable() || !this.compareSerializableVersion(c, cand)) {
                                    return false;
                                }
                                if (c.read()) continue;
                                break;
                            }
                        }
                        this.locs.addLast(cand);
                        return true;
                    }
                    GridCacheMvccCandidate first = this.locs.getFirst();
                    if (first.owner() && !cand.dhtLocal() && first.hasSameHolderAs(cand)) {
                        assert (!first.serializable());
                        cand.setOwner();
                        cand.setReady();
                        cand.setReentry();
                        this.locs.addFirst(cand);
                        return true;
                    }
                    ListIterator<GridCacheMvccCandidate> it = this.locs.listIterator(this.locs.size());
                    while (it.hasPrevious()) {
                        GridCacheMvccCandidate c = it.previous();
                        assert (!c.version().equals(cand.version())) : "Versions can't match [existing=" + c + ", new=" + cand + "]";
                        if (c.owner() || c.serializable()) {
                            assert (cand.dhtLocal() || !c.hasSameHolderAs(cand));
                            it.next();
                            it.add(cand);
                            return true;
                        }
                        if (!c.version().isLess(cand.version())) continue;
                        it.next();
                        it.add(cand);
                        return true;
                    }
                }
                this.locs.addFirst(cand);
            } else {
                this.locs.add(cand);
            }
        } else {
            assert (!cand.serializable() && !cand.read()) : cand;
            if (this.rmts == null) {
                this.rmts = new LinkedList();
            }
            assert (!cand.owner() || this.localOwners() == null) : "Cannot have local and remote owners at the same time [cand=" + cand + ", locs=" + this.locs + ", rmts=" + this.rmts + "]";
            GridCacheMvccCandidate cur = this.candidate(this.rmts, cand.version());
            if (cur != null) {
                if (cand.owner()) {
                    cur.setOwner();
                }
                return true;
            }
            this.rmts.add(cand);
        }
        return true;
    }

    private void remove0(GridCacheVersion ver, boolean preferLoc) {
        if (preferLoc) {
            if (!this.remove0(this.locs, ver)) {
                this.remove0(this.rmts, ver);
            }
        } else if (!this.remove0(this.rmts, ver)) {
            this.remove0(this.locs, ver);
        }
        if (this.locs != null && this.locs.isEmpty()) {
            this.locs = null;
        }
        if (this.rmts != null && this.rmts.isEmpty()) {
            this.rmts = null;
        }
    }

    private boolean remove0(Collection<GridCacheMvccCandidate> col, GridCacheVersion ver) {
        if (col != null) {
            Iterator<GridCacheMvccCandidate> it = col.iterator();
            while (it.hasNext()) {
                GridCacheMvccCandidate cand = it.next();
                if (!cand.version().equals(ver)) continue;
                cand.setUsed();
                cand.setRemoved();
                it.remove();
                this.reassign();
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty(GridCacheVersion ... exclude) {
        if (this.locs == null && this.rmts == null) {
            return true;
        }
        if (this.locs != null) {
            assert (!this.locs.isEmpty());
            if (F.isEmpty(exclude)) {
                return false;
            }
            for (GridCacheMvccCandidate cand : this.locs) {
                if (U.containsObjectArray(exclude, cand.version(), new Object[0])) continue;
                return false;
            }
        }
        if (this.rmts != null) {
            assert (!this.rmts.isEmpty());
            if (F.isEmpty(exclude)) {
                return false;
            }
            for (GridCacheMvccCandidate cand : this.rmts) {
                if (U.containsObjectArray(exclude, cand.version(), new Object[0])) continue;
                return false;
            }
        }
        return true;
    }

    public void orderCompleted(GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        assert (baseVer != null);
        if (this.rmts != null && !F.isEmpty(committedVers)) {
            LinkedList<Object> mvAfter = null;
            int maxIdx = -1;
            Iterator<GridCacheMvccCandidate> it = this.rmts.listIterator(this.rmts.size());
            while (it.hasPrevious()) {
                GridCacheMvccCandidate cur = it.previous();
                if (!cur.version().equals(baseVer) && committedVers.contains(cur.version())) {
                    cur.setOwner();
                    assert (this.localOwners() == null || this.localOwner().nearLocal()) : "Cannot not have local owner and remote completed transactions at the same time [baseVer=" + baseVer + ", committedVers=" + committedVers + ", rolledbackVers=" + rolledbackVers + ", localOwner=" + this.localOwner() + ", locs=" + this.locs + ", rmts=" + this.rmts + "]";
                    if (maxIdx < 0) {
                        maxIdx = it.nextIndex();
                    }
                } else if (maxIdx >= 0 && cur.version().isGreaterEqual(baseVer) && --maxIdx >= 0) {
                    if (mvAfter == null) {
                        mvAfter = new LinkedList<Object>();
                    }
                    it.remove();
                    mvAfter.addFirst(cur);
                }
                if (cur.owner() || !cur.version().equals(baseVer) || !committedVers.contains(cur.version())) continue;
                cur.setOwner();
            }
            if (maxIdx >= 0 && mvAfter != null) {
                it = this.rmts.listIterator(maxIdx + 1);
                for (GridCacheMvccCandidate gridCacheMvccCandidate : mvAfter) {
                    it.add(gridCacheMvccCandidate);
                }
            }
            if (!F.isEmpty(rolledbackVers)) {
                it = this.rmts.iterator();
                while (it.hasNext()) {
                    GridCacheMvccCandidate cand = it.next();
                    if (!rolledbackVers.contains(cand.version())) continue;
                    cand.setUsed();
                    it.remove();
                }
                if (this.rmts.isEmpty()) {
                    this.rmts = null;
                }
            }
        }
    }

    public void markOwned(GridCacheVersion baseVer, GridCacheVersion owned) {
        GridCacheMvccCandidate baseCand;
        if (owned == null) {
            return;
        }
        if (this.rmts != null && (baseCand = this.candidate(this.rmts, baseVer)) != null) {
            baseCand.ownerVersion(owned);
        }
    }

    @Nullable
    public GridCacheMvccCandidate addLocal(GridCacheEntryEx parent, long threadId, GridCacheVersion ver, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) {
        return this.addLocal(parent, null, null, threadId, ver, timeout, null, reenter, tx, implicitSingle, false, read);
    }

    @Nullable
    public GridCacheMvccCandidate addLocal(GridCacheEntryEx parent, @Nullable UUID nearNodeId, @Nullable GridCacheVersion nearVer, long threadId, GridCacheVersion ver, long timeout, @Nullable GridCacheVersion serOrder, boolean reenter, boolean tx, boolean implicitSingle, boolean dhtLoc, boolean read) {
        GridCacheMvccCandidate owner;
        if (log.isDebugEnabled()) {
            log.debug("Adding local candidate [mvcc=" + this + ", parent=" + parent + ", threadId=" + threadId + ", ver=" + ver + ", timeout=" + timeout + ", reenter=" + reenter + ", tx=" + tx + "]");
        }
        if (!dhtLoc && !reenter && (owner = this.localOwner()) != null && owner.isHeldByThreadOrVer(threadId, ver)) {
            return null;
        }
        if (!(timeout >= 0L || this.locs == null && this.rmts == null || (owner = this.localOwner()) != null && owner.isHeldByThreadOrVer(threadId, ver))) {
            return null;
        }
        UUID locNodeId = this.cctx.nodeId();
        GridCacheMvccCandidate cand = new GridCacheMvccCandidate(parent, locNodeId, nearNodeId, nearVer, threadId, ver, true, false, tx, implicitSingle, false, dhtLoc, serOrder, read);
        if (serOrder == null) {
            boolean add = this.add0(cand);
            assert (add) : cand;
        } else if (!this.add0(cand)) {
            return null;
        }
        return cand;
    }

    public GridCacheMvccCandidate addRemote(GridCacheEntryEx parent, UUID nodeId, @Nullable UUID otherNodeId, long threadId, GridCacheVersion ver, boolean tx, boolean implicitSingle, boolean nearLoc) {
        GridCacheMvccCandidate cand = new GridCacheMvccCandidate(parent, nodeId, otherNodeId, null, threadId, ver, false, false, tx, implicitSingle, nearLoc, false, null, false);
        this.addRemote(cand);
        return cand;
    }

    public GridCacheMvccCandidate addNearLocal(GridCacheEntryEx parent, UUID nodeId, @Nullable UUID otherNodeId, long threadId, GridCacheVersion ver, boolean tx, boolean implicitSingle, boolean read) {
        GridCacheMvccCandidate cand = new GridCacheMvccCandidate(parent, nodeId, otherNodeId, null, threadId, ver, true, false, tx, implicitSingle, true, false, null, read);
        this.add0(cand);
        return cand;
    }

    private void addRemote(GridCacheMvccCandidate cand) {
        assert (!cand.local());
        if (log.isDebugEnabled()) {
            log.debug("Adding remote candidate [mvcc=" + this + ", cand=" + cand + "]");
        }
        this.cctx.versions().onReceived(cand.nodeId(), cand.version());
        this.add0(cand);
    }

    @Nullable
    public CacheLockCandidates readyLocal(GridCacheVersion ver) {
        GridCacheMvccCandidate cand = this.candidate(ver);
        if (cand == null) {
            return this.allOwners();
        }
        assert (cand.local());
        return this.readyLocal(cand);
    }

    @Nullable
    public CacheLockCandidates readyLocal(GridCacheMvccCandidate cand) {
        assert (cand.local());
        cand.setReady();
        this.reassign();
        return this.allOwners();
    }

    @Nullable
    public CacheLockCandidates readyNearLocal(GridCacheVersion ver, GridCacheVersion mappedVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledBackVers, Collection<GridCacheVersion> pending) {
        GridCacheMvccCandidate cand = this.candidate(this.locs, ver);
        if (cand != null) {
            assert (cand.nearLocal()) : "Near local candidate is not marked as near local: " + cand;
            cand.setReady();
            boolean setMapped = cand.otherVersion(mappedVer);
            assert (setMapped) : "Failed to set mapped dht version for near local candidate [mappedVer=" + mappedVer + ", cand=" + cand + "]";
            LinkedList<GridCacheMvccCandidate> mvAfter = null;
            ListIterator<GridCacheMvccCandidate> it = this.locs.listIterator();
            while (it.hasNext()) {
                GridCacheMvccCandidate c = (GridCacheMvccCandidate)it.next();
                assert (c.nearLocal()) : "Near local candidate is not marked as near local: " + c;
                if (c == cand) {
                    if (mvAfter == null) break;
                    for (GridCacheMvccCandidate mv : mvAfter) {
                        it.add(mv);
                    }
                    break;
                }
                if (c.owner()) continue;
                assert (!c.ready() || c.read() && cand.read()) : "Cannot have more then one ready near-local candidate [c=" + c + ", cand=" + cand + ", mvcc=" + this + "]";
                it.remove();
                if (mvAfter == null) {
                    mvAfter = new LinkedList<GridCacheMvccCandidate>();
                }
                mvAfter.add(c);
            }
            if (this.rmts != null) {
                for (GridCacheMvccCandidate rmt : this.rmts) {
                    GridCacheVersion rmtVer = rmt.version();
                    if (rmtVer.isLess(mappedVer)) {
                        if (pending.contains(rmtVer) || mappedVer.equals(rmt.ownerVersion())) continue;
                        rmt.setOwner();
                        continue;
                    }
                    if (!committedVers.contains(rmtVer) && !rolledBackVers.contains(rmtVer)) continue;
                    rmt.setOwner();
                }
            }
            this.reassign();
        }
        return this.allOwners();
    }

    @Nullable
    public CacheLockCandidates doneRemote(GridCacheVersion ver, Collection<GridCacheVersion> pending, Collection<GridCacheVersion> committed, Collection<GridCacheVersion> rolledback) {
        GridCacheMvccCandidate cand;
        assert (ver != null);
        if (log.isDebugEnabled()) {
            log.debug("Setting remote candidate to done [mvcc=" + this + ", ver=" + ver + "]");
        }
        if ((cand = this.candidate(this.rmts, ver)) != null) {
            assert (this.rmts != null);
            assert (!this.rmts.isEmpty());
            assert (!cand.local()) : "Remote candidate is marked as local: " + cand;
            assert (!cand.nearLocal()) : "Remote candidate is marked as near local: " + cand;
            cand.setOwner();
            cand.setUsed();
            LinkedList<GridCacheMvccCandidate> mvAfter = null;
            ListIterator<GridCacheMvccCandidate> it = this.rmts.listIterator();
            while (it.hasNext()) {
                GridCacheMvccCandidate c = (GridCacheMvccCandidate)it.next();
                assert (!c.nearLocal()) : "Remote candidate marked as near local: " + c;
                if (c == cand) {
                    if (mvAfter == null) break;
                    for (GridCacheMvccCandidate mv : mvAfter) {
                        it.add(mv);
                    }
                    break;
                }
                if (committed.contains(c.version()) || rolledback.contains(c.version()) || !pending.contains(c.version())) continue;
                it.remove();
                if (mvAfter == null) {
                    mvAfter = new LinkedList<GridCacheMvccCandidate>();
                }
                mvAfter.add(c);
            }
        }
        return this.allOwners();
    }

    public void salvageRemote(GridCacheVersion ver, boolean near) {
        assert (ver != null);
        GridCacheMvccCandidate cand = this.candidate(this.rmts, ver);
        if (cand != null) {
            GridCacheMvccCandidate rmt;
            assert (this.rmts != null);
            assert (!this.rmts.isEmpty());
            Iterator iter = this.rmts.iterator();
            while (iter.hasNext() && (rmt = (GridCacheMvccCandidate)iter.next()) != cand) {
                Object tx;
                assert (!rmt.nearLocal());
                Object t = tx = near ? this.cctx.tm().nearTx(rmt.version()) : this.cctx.tm().tx(rmt.version());
                if (tx != null) {
                    tx.systemInvalidate(true);
                    rmt.setOwner();
                    rmt.setUsed();
                    continue;
                }
                iter.remove();
            }
        }
    }

    private void reassign() {
        GridCacheMvccCandidate firstRmt = null;
        if (this.rmts != null) {
            for (GridCacheMvccCandidate cand : this.rmts) {
                if (firstRmt == null) {
                    firstRmt = cand;
                }
                if (!cand.owner()) continue;
                return;
            }
        }
        if (this.locs != null) {
            boolean first = true;
            ListIterator it = this.locs.listIterator();
            while (it.hasNext()) {
                GridCacheMvccCandidate prev;
                GridCacheMvccCandidate cand = (GridCacheMvccCandidate)it.next();
                if (first) {
                    if (cand.read()) {
                        if (cand.ready() && !cand.owner()) {
                            cand.setOwner();
                        }
                        while (it.hasNext() && (cand = (GridCacheMvccCandidate)it.next()).read()) {
                            if (!cand.ready() || cand.owner()) continue;
                            cand.setOwner();
                        }
                        return;
                    }
                    if (cand.serializable()) {
                        if (cand.owner() || !cand.ready()) {
                            return;
                        }
                        cand.setOwner();
                        return;
                    }
                    first = false;
                }
                if (cand.owner()) {
                    return;
                }
                if (!cand.ready() || (prev = this.nonRollbackPrevious(cand)) != null && !prev.owner()) continue;
                boolean assigned = false;
                if (!this.cctx.isNear() && firstRmt != null && cand.version().isGreater(firstRmt.version())) {
                    while (prev != null && prev.owner()) {
                        for (GridCacheMvccCandidate c : prev.parent().remoteMvccSnapshot(new GridCacheVersion[0])) {
                            if (!c.version().equals(firstRmt.version())) continue;
                            cand.setOwner();
                            assigned = true;
                            break;
                        }
                        if (!assigned) {
                            for (GridCacheMvccCandidate c : this.locs) {
                                if (c == cand || c.version().isGreater(firstRmt.version())) break;
                                for (GridCacheMvccCandidate p = c.previous(); p != null; p = p.previous()) {
                                    if (!p.key().equals(prev.key())) continue;
                                    cand.setOwner();
                                    assigned = true;
                                    break;
                                }
                                if (!assigned) continue;
                                break;
                            }
                        }
                        if (assigned) break;
                        prev = prev.previous();
                    }
                }
                if (!assigned) {
                    if (!this.cctx.isNear() && firstRmt != null) {
                        if (cand.version().isLess(firstRmt.version())) {
                            assert (!cand.nearLocal());
                            cand.setOwner();
                            assigned = true;
                        }
                    } else {
                        cand.setOwner();
                        assigned = true;
                    }
                }
                if (assigned) {
                    assert (!cand.serializable()) : cand;
                    it.remove();
                    this.locs.addFirst(cand);
                }
                return;
            }
        }
    }

    @Nullable
    private GridCacheMvccCandidate nonRollbackPrevious(GridCacheMvccCandidate cand) {
        for (GridCacheMvccCandidate c = cand.previous(); c != null; c = c.previous()) {
            if (!c.owner() && c.used()) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public CacheLockCandidates recheck() {
        this.reassign();
        return this.allOwners();
    }

    @Nullable
    public GridCacheMvccCandidate releaseLocal() {
        return this.releaseLocal(Thread.currentThread().getId());
    }

    @Nullable
    public GridCacheMvccCandidate releaseLocal(long threadId) {
        CacheLockCandidates owners = this.localOwners();
        if (owners == null) {
            return null;
        }
        GridCacheMvccCandidate owner = null;
        for (int i = 0; i < owners.size(); ++i) {
            GridCacheMvccCandidate owner0 = owners.candidate(i);
            if (!owner0.isHeldByThread(threadId)) continue;
            owner = owner0;
            break;
        }
        if (owner != null) {
            owner.setUsed();
            this.remove0(owner.version(), true);
            return owner;
        }
        return null;
    }

    public void remove(GridCacheVersion ver) {
        this.remove0(ver, false);
    }

    @Nullable
    public CacheLockCandidates removeExplicitNodeCandidates(UUID nodeId) {
        GridCacheMvccCandidate cand;
        Iterator it;
        if (this.rmts != null) {
            it = this.rmts.iterator();
            while (it.hasNext()) {
                cand = (GridCacheMvccCandidate)it.next();
                if (cand.tx() || !nodeId.equals(cand.nodeId()) && !nodeId.equals(cand.otherNodeId())) continue;
                cand.setUsed();
                cand.setRemoved();
                it.remove();
            }
            if (this.rmts.isEmpty()) {
                this.rmts = null;
            }
        }
        if (this.locs != null) {
            it = this.locs.iterator();
            while (it.hasNext()) {
                cand = (GridCacheMvccCandidate)it.next();
                if (cand.tx() || !nodeId.equals(cand.otherNodeId()) || !cand.dhtLocal()) continue;
                cand.setUsed();
                cand.setRemoved();
                it.remove();
            }
            if (this.locs.isEmpty()) {
                this.locs = null;
            }
        }
        this.reassign();
        return this.allOwners();
    }

    @Nullable
    public GridCacheMvccCandidate candidate(GridCacheVersion ver) {
        GridCacheMvccCandidate cand = this.candidate(this.locs, ver);
        if (cand == null) {
            cand = this.candidate(this.rmts, ver);
        }
        return cand;
    }

    @Nullable
    GridCacheMvccCandidate localCandidate(long threadId) {
        return this.localCandidate(threadId, false);
    }

    @Nullable
    GridCacheMvccCandidate remoteCandidate(UUID nodeId, long threadId) {
        if (this.rmts != null) {
            for (GridCacheMvccCandidate c : this.rmts) {
                if (!c.nodeId().equals(nodeId) || !c.isHeldByThread(threadId)) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    public GridCacheMvccCandidate localCandidate(UUID nodeId, long threadId) {
        if (this.locs != null) {
            for (GridCacheMvccCandidate c : this.locs) {
                if (!c.nodeId().equals(nodeId) || !c.isHeldByThread(threadId)) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    public GridCacheMvccCandidate localCandidateByThreadOrVer(UUID nodeId, long threadId, GridCacheVersion ver) {
        if (this.locs != null) {
            for (GridCacheMvccCandidate c : this.locs) {
                if (!c.nodeId().equals(nodeId) || !c.isHeldByThreadOrVer(threadId, ver)) continue;
                return c;
            }
        }
        return null;
    }

    boolean hasCandidate(GridCacheVersion ver) {
        return this.candidate(ver) != null;
    }

    public List<GridCacheMvccCandidate> localCandidatesNoCopy(boolean reentry) {
        return this.candidates(this.locs, reentry, false, this.cctx.emptyVersion());
    }

    public Collection<GridCacheMvccCandidate> localCandidates(GridCacheVersion ... excludeVers) {
        return this.candidates(this.locs, false, true, excludeVers);
    }

    public List<GridCacheMvccCandidate> localCandidates(boolean reentries, GridCacheVersion ... excludeVers) {
        return this.candidates(this.locs, reentries, true, excludeVers);
    }

    public List<GridCacheMvccCandidate> remoteCandidates(GridCacheVersion ... excludeVers) {
        return this.candidates(this.rmts, false, true, excludeVers);
    }

    private List<GridCacheMvccCandidate> candidates(List<GridCacheMvccCandidate> col, boolean reentries, boolean cp, GridCacheVersion ... excludeVers) {
        if (col == null) {
            return Collections.emptyList();
        }
        assert (!col.isEmpty());
        if (!cp && F.isEmpty(excludeVers)) {
            return col;
        }
        ArrayList<GridCacheMvccCandidate> cands = new ArrayList<GridCacheMvccCandidate>(col.size());
        for (GridCacheMvccCandidate c : col) {
            if (!reentries && c.reentry() || U.containsObjectArray(excludeVers, c.version(), new Object[0])) continue;
            cands.add(c);
        }
        return cands;
    }

    boolean isLocallyOwnedByThread(long threadId, boolean allowDhtLoc, GridCacheVersion ... exclude) {
        CacheLockCandidates owners = this.localOwners();
        if (owners != null) {
            for (int i = 0; i < owners.size(); ++i) {
                GridCacheMvccCandidate owner = owners.candidate(i);
                if (!owner.isHeldByThread(threadId) || !owner.nodeId().equals(this.cctx.nodeId()) || !allowDhtLoc && owner.dhtLocal() || U.containsObjectArray(exclude, owner.version(), new Object[0])) continue;
                return true;
            }
        }
        return false;
    }

    boolean isLocallyOwned(GridCacheVersion lockVer) {
        CacheLockCandidates owners = this.localOwners();
        return owners != null && owners.hasCandidate(lockVer);
    }

    boolean isLocallyOwnedByIdOrThread(GridCacheVersion lockVer, long threadId) {
        CacheLockCandidates owners = this.localOwners();
        if (owners != null) {
            for (int i = 0; i < owners.size(); ++i) {
                GridCacheMvccCandidate owner = owners.candidate(i);
                if (!owner.isHeldByThreadOrVer(threadId, lockVer)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    List<GridCacheMvccCandidate> allLocal() {
        return this.locs;
    }

    boolean isOwnedBy(GridCacheVersion ver) {
        CacheLockCandidates owners = this.allOwners();
        return owners != null && owners.hasCandidate(ver);
    }

    public String toString() {
        return S.toString(GridCacheMvcc.class, this);
    }

    static {
        SER_VER_COMPARATOR = new Comparator<GridCacheVersion>(){

            @Override
            public int compare(GridCacheVersion ver1, GridCacheVersion ver2) {
                int nodeOrder2;
                int nodeOrder1 = ver1.nodeOrder();
                if (nodeOrder1 == (nodeOrder2 = ver2.nodeOrder())) {
                    long order1 = ver1.order();
                    long order2 = ver2.order();
                    assert (order1 != order2);
                    return order1 > order2 ? 1 : -1;
                }
                return nodeOrder1 > nodeOrder2 ? 1 : -1;
            }
        };
    }
}

