/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheExplicitLockSpan
extends ReentrantLock {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final AffinityTopologyVersion topVer;
    @GridToStringInclude
    private final Map<IgniteTxKey, Deque<GridCacheMvccCandidate>> cands = new HashMap<IgniteTxKey, Deque<GridCacheMvccCandidate>>();
    @GridToStringExclude
    private final GridFutureAdapter<Object> releaseFut;

    public GridCacheExplicitLockSpan(final AffinityTopologyVersion topVer, final GridCacheMvccCandidate cand) {
        this.topVer = topVer;
        this.releaseFut = new GridFutureAdapter<Object>(){

            @Override
            public String toString() {
                return "ExplicitLockSpan [topVer=" + topVer + ", firstCand=" + cand + "]";
            }
        };
        this.ensureDeque(cand.key()).addFirst(cand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCandidate(AffinityTopologyVersion topVer, GridCacheMvccCandidate cand) {
        this.lock();
        try {
            if (this.cands.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            assert (this.topVer.equals(topVer));
            Deque<GridCacheMvccCandidate> deque = this.ensureDeque(cand.key());
            GridCacheMvccCandidate old = F.first(deque);
            deque.add(cand);
            if (old != null && old.owner()) {
                cand.setOwner();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCandidate(GridCacheMvccCandidate cand) {
        this.lock();
        try {
            boolean empty;
            Deque<GridCacheMvccCandidate> deque = this.cands.get(cand.key());
            if (deque != null) {
                assert (!deque.isEmpty());
                if (deque.peekFirst().equals(cand)) {
                    deque.removeFirst();
                    if (deque.isEmpty()) {
                        this.cands.remove(cand.key());
                    }
                }
            }
            if (empty = this.cands.isEmpty()) {
                this.releaseFut.onDone();
            }
            boolean bl = empty;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCacheMvccCandidate removeCandidate(IgniteTxKey key, @Nullable GridCacheVersion ver) {
        this.lock();
        try {
            boolean empty;
            Deque<GridCacheMvccCandidate> deque = this.cands.get(key);
            GridCacheMvccCandidate cand = null;
            if (deque != null) {
                assert (!deque.isEmpty());
                GridCacheMvccCandidate first = deque.peekFirst();
                if (ver == null || first.version().equals(ver)) {
                    GridCacheMvccCandidate reentry = first.unenter();
                    if (reentry != null) {
                        assert (reentry.reentry()) : reentry;
                        boolean rmvd = false;
                        Iterator<GridCacheMvccCandidate> it = deque.iterator();
                        while (it.hasNext()) {
                            if (it.next() != reentry) continue;
                            it.remove();
                            rmvd = true;
                            break;
                        }
                        assert (rmvd) : reentry;
                        cand = reentry;
                    } else {
                        cand = deque.removeFirst();
                    }
                    if (deque.isEmpty()) {
                        this.cands.remove(cand.key());
                    }
                }
            }
            if (empty = this.cands.isEmpty()) {
                this.releaseFut.onDone();
            }
            GridCacheMvccCandidate gridCacheMvccCandidate = cand;
            return gridCacheMvccCandidate;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock();
        try {
            boolean bl = this.cands.isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOwned(IgniteTxKey key) {
        this.lock();
        try {
            Deque<GridCacheMvccCandidate> deque = this.cands.get(key);
            assert (deque != null);
            for (GridCacheMvccCandidate cand : deque) {
                cand.setOwner();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheMvccCandidate candidate(IgniteTxKey key, final @Nullable GridCacheVersion ver) {
        this.lock();
        try {
            Deque<GridCacheMvccCandidate> deque = this.cands.get(key);
            if (deque != null) {
                assert (!deque.isEmpty());
                GridCacheMvccCandidate gridCacheMvccCandidate = ver == null ? deque.peekFirst() : (GridCacheMvccCandidate)F.find(deque, null, new P1<GridCacheMvccCandidate>(){

                    @Override
                    public boolean apply(GridCacheMvccCandidate cand) {
                        return cand.version().equals(ver);
                    }
                });
                return gridCacheMvccCandidate;
            }
            GridCacheMvccCandidate gridCacheMvccCandidate = null;
            return gridCacheMvccCandidate;
        }
        finally {
            this.unlock();
        }
    }

    @Nullable
    public AffinityTopologyVersion topologyVersion() {
        return this.releaseFut.isDone() ? null : this.topVer;
    }

    public IgniteInternalFuture<Object> releaseFuture() {
        return this.releaseFut;
    }

    private Deque<GridCacheMvccCandidate> ensureDeque(IgniteTxKey key) {
        Deque<GridCacheMvccCandidate> deque = this.cands.get(key);
        if (deque == null) {
            deque = new LinkedList<GridCacheMvccCandidate>();
            this.cands.put(key, deque);
        }
        return deque;
    }

    @Override
    public String toString() {
        this.lock();
        try {
            String string = S.toString(GridCacheExplicitLockSpan.class, this);
            return string;
        }
        finally {
            this.unlock();
        }
    }
}

