/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DataEntry {
    public static final byte EMPTY_FLAGS = 0;
    public static final byte PRIMARY_FLAG = 1;
    public static final byte PRELOAD_FLAG = 2;
    public static final byte FROM_STORE_FLAG = 4;
    @GridToStringInclude
    protected int cacheId;
    protected KeyCacheObject key;
    @Nullable
    protected CacheObject val;
    @GridToStringInclude
    protected GridCacheOperation op;
    @GridToStringInclude
    protected GridCacheVersion nearXidVer;
    @GridToStringInclude
    protected GridCacheVersion writeVer;
    protected long expireTime;
    @GridToStringInclude
    protected int partId;
    @GridToStringInclude
    protected long partCnt;
    @GridToStringInclude
    protected byte flags;

    private DataEntry() {
    }

    public DataEntry(int cacheId, KeyCacheObject key, @Nullable CacheObject val, GridCacheOperation op, GridCacheVersion nearXidVer, GridCacheVersion writeVer, long expireTime, int partId, long partCnt, byte flags) {
        this.cacheId = cacheId;
        this.key = key;
        this.val = val;
        this.op = op;
        this.nearXidVer = nearXidVer;
        this.writeVer = writeVer;
        this.expireTime = expireTime;
        this.partId = partId;
        this.partCnt = partCnt;
        this.flags = flags;
        assert (op == GridCacheOperation.READ || op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE) : op;
    }

    public static byte flags(boolean primary) {
        return DataEntry.flags(primary, false, false);
    }

    public static byte flags(boolean primary, boolean preload, boolean fromStore) {
        byte val = 0;
        val = (byte)(val | (primary ? 1 : 0));
        val = (byte)(val | (preload ? 2 : 0));
        val = (byte)(val | (fromStore ? 4 : 0));
        return val;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject value() {
        return this.val;
    }

    public GridCacheOperation op() {
        return this.op;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public int partitionId() {
        return this.partId;
    }

    public long partitionCounter() {
        return this.partCnt;
    }

    public DataEntry partitionCounter(long partCnt) {
        this.partCnt = partCnt;
        return this;
    }

    public long expireTime() {
        return this.expireTime;
    }

    public byte flags() {
        return this.flags;
    }

    public String toString() {
        return S.toString(DataEntry.class, this);
    }
}

