/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.failover;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.failover.GridFailoverContextImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.failover.FailoverSpi;
import org.jetbrains.annotations.Nullable;

public class GridFailoverManager
extends GridManagerAdapter<FailoverSpi> {
    public GridFailoverManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])ctx.config().getFailoverSpi());
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public ClusterNode failover(GridTaskSessionImpl taskSes, ComputeJobResult jobRes, List<ClusterNode> top, int affPartId, @Nullable String affCacheName, @Nullable AffinityTopologyVersion topVer) {
        return ((FailoverSpi)this.getSpi(taskSes.getFailoverSpi())).failover(new GridFailoverContextImpl(taskSes, jobRes, this.ctx.loadBalancing(), affPartId, affCacheName, topVer), top);
    }
}

