/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientTransaction;
import org.apache.ignite.client.ClientTransactions;
import org.apache.ignite.configuration.ClientTransactionConfiguration;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

class TcpClientTransactions
implements ClientTransactions {
    private final ReliableChannel ch;
    private final ClientBinaryMarshaller marsh;
    private final AtomicLong txCnt = new AtomicLong();
    private final ThreadLocal<Long> threadLocTxUid = new ThreadLocal();
    private final Map<Long, TcpClientTransaction> txMap = new ConcurrentHashMap<Long, TcpClientTransaction>();
    private final ClientTransactionConfiguration txCfg;

    TcpClientTransactions(ReliableChannel ch, ClientBinaryMarshaller marsh, ClientTransactionConfiguration txCfg) {
        this.ch = ch;
        this.marsh = marsh;
        this.txCfg = txCfg;
    }

    @Override
    public ClientTransaction txStart() {
        return this.txStart0(null, null, null, null);
    }

    @Override
    public ClientTransaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        return this.txStart0(concurrency, isolation, null, null);
    }

    @Override
    public ClientTransaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout) {
        return this.txStart0(concurrency, isolation, timeout, null);
    }

    private ClientTransaction txStart0(TransactionConcurrency concurrency, TransactionIsolation isolation, Long timeout, String lb) {
        TcpClientTransaction tx0 = this.tx();
        if (tx0 != null) {
            throw new ClientException("A transaction has already been started by the current thread.");
        }
        tx0 = this.ch.service(ClientOperation.TX_START, req -> {
            ProtocolContext protocolCtx = req.clientChannel().protocolCtx();
            if (!protocolCtx.isFeatureSupported(ProtocolVersionFeature.TRANSACTIONS)) {
                throw new ClientProtocolError(String.format("Transactions are not supported by the server's protocol version %s, required version %s", protocolCtx.version(), ProtocolVersionFeature.TRANSACTIONS.verIntroduced()));
            }
            try (BinaryWriterExImpl writer = new BinaryWriterExImpl(this.marsh.context(), req.out(), null, null);){
                writer.writeByte((byte)(concurrency == null ? this.txCfg.getDefaultTxConcurrency() : concurrency).ordinal());
                writer.writeByte((byte)(isolation == null ? this.txCfg.getDefaultTxIsolation() : isolation).ordinal());
                writer.writeLong(timeout == null ? this.txCfg.getDefaultTxTimeout() : timeout.longValue());
                writer.writeString(lb);
            }
        }, res -> new TcpClientTransaction(res.in().readInt(), res.clientChannel()));
        this.threadLocTxUid.set(tx0.txUid);
        this.txMap.put(tx0.txUid, tx0);
        return tx0;
    }

    @Override
    public ClientTransactions withLabel(String lb) {
        A.notNull(lb, "lb");
        return new ClientTransactionsWithLabel(lb);
    }

    TcpClientTransaction tx() {
        Long txUid = this.threadLocTxUid.get();
        if (txUid == null) {
            return null;
        }
        TcpClientTransaction tx0 = this.txMap.get(txUid);
        return tx0 == null || tx0.isClosed() ? null : tx0;
    }

    class TcpClientTransaction
    implements ClientTransaction {
        private final long txUid;
        private final int txId;
        private final ClientChannel clientCh;
        private volatile boolean closed;

        private TcpClientTransaction(int id, ClientChannel clientCh) {
            this.txUid = TcpClientTransactions.this.txCnt.incrementAndGet();
            this.txId = id;
            this.clientCh = clientCh;
        }

        @Override
        public void commit() {
            Long threadTxUid;
            if (this.closed || (threadTxUid = TcpClientTransactions.this.threadLocTxUid.get()) == null) {
                throw new ClientException("The transaction is already closed");
            }
            if (this.txUid != threadTxUid) {
                throw new ClientException("You can commit transaction only from the thread it was started");
            }
            this.endTx(true);
        }

        @Override
        public void rollback() {
            this.endTx(false);
        }

        @Override
        public void close() {
            try {
                this.endTx(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void endTx(boolean committed) {
            try {
                this.clientCh.service(ClientOperation.TX_END, req -> {
                    req.out().writeInt(this.txId);
                    req.out().writeBoolean(committed);
                }, null);
            }
            catch (ClientConnectionException e) {
                throw new ClientException("Transaction context has been lost due to connection errors", e);
            }
            finally {
                TcpClientTransactions.this.txMap.remove(this.txUid);
                this.closed = true;
                Long threadTxUid = TcpClientTransactions.this.threadLocTxUid.get();
                if (threadTxUid != null && this.txUid == threadTxUid) {
                    TcpClientTransactions.this.threadLocTxUid.set(null);
                }
            }
        }

        int txId() {
            return this.txId;
        }

        ClientChannel clientChannel() {
            return this.clientCh;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    private class ClientTransactionsWithLabel
    implements ClientTransactions {
        private final String lb;

        ClientTransactionsWithLabel(String lb) {
            this.lb = lb;
        }

        @Override
        public ClientTransaction txStart() throws ClientServerError, ClientException {
            return TcpClientTransactions.this.txStart0(null, null, null, this.lb);
        }

        @Override
        public ClientTransaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation) throws ClientServerError, ClientException {
            return TcpClientTransactions.this.txStart0(concurrency, isolation, null, this.lb);
        }

        @Override
        public ClientTransaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout) throws ClientServerError, ClientException {
            return TcpClientTransactions.this.txStart0(concurrency, isolation, timeout, this.lb);
        }

        @Override
        public ClientTransactions withLabel(String lb) throws ClientException {
            A.notNull(lb, "lb");
            if (lb.equals(this.lb)) {
                return this;
            }
            return new ClientTransactionsWithLabel(lb);
        }
    }
}

