/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.JavaObjectIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.PlainJavaObjectIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class ObjectHashInlineIndexKeyType
extends NullableInlineIndexKeyType<JavaObjectIndexKey> {
    public ObjectHashInlineIndexKeyType() {
        super(IndexKeyType.JAVA_OBJECT, (short)4);
    }

    @Override
    protected int put0(long pageAddr, int off, JavaObjectIndexKey val, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putInt(pageAddr, off + 1, val.hashCode());
        return this.keySize + 1;
    }

    @Override
    protected JavaObjectIndexKey get0(long pageAddr, int off) {
        int hash = PageUtils.getInt(pageAddr, off + 1);
        return new PlainJavaObjectIndexKey(hash, null);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey v) {
        int val2;
        int val1 = PageUtils.getInt(pageAddr, off + 1);
        int res = Integer.signum(Integer.compare(val1, val2 = v.hashCode()));
        return res == 0 ? -2 : res;
    }

    @Override
    protected int inlineSize0(JavaObjectIndexKey key) {
        return this.keySize + 1;
    }
}

