/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCache;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.jetbrains.annotations.Nullable;

public class IndexRowCacheRegistry {
    private final Object mux = new Object();
    private volatile Map<Integer, IndexRowCache> caches;

    @Nullable
    public IndexRowCache forGroup(int grpId) {
        return this.caches != null ? this.caches.get(grpId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheRegistered(GridCacheContextInfo cacheInfo) {
        if (!cacheInfo.config().isSqlOnheapCacheEnabled()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            IndexRowCache cache;
            int grpId = cacheInfo.groupId();
            if (this.caches != null && (cache = this.caches.get(grpId)) != null) {
                cache.onCacheRegistered();
                return;
            }
            HashMap<Integer, IndexRowCache> caches0 = this.copy();
            if (cacheInfo.affinityNode()) {
                GridCacheContext cacheCtx = cacheInfo.cacheContext();
                assert (cacheCtx != null);
                IndexRowCache rowCache = new IndexRowCache(cacheCtx.group(), cacheInfo.config().getSqlOnheapCacheMaxSize());
                caches0.put(grpId, rowCache);
                this.caches = caches0;
                for (IgniteCacheOffheapManager.CacheDataStore ds : cacheCtx.offheap().cacheDataStores()) {
                    ds.setRowCacheCleaner(rowCache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheUnregistered(GridCacheContextInfo cacheInfo) {
        if (!cacheInfo.config().isSqlOnheapCacheEnabled()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            int grpId = cacheInfo.groupId();
            assert (this.caches != null);
            IndexRowCache cache = this.caches.get(grpId);
            assert (cache != null);
            if (cache.onCacheUnregistered(cacheInfo)) {
                HashMap<Integer, IndexRowCache> caches0 = this.copy();
                caches0.remove(grpId);
                this.caches = caches0;
            }
        }
    }

    private HashMap<Integer, IndexRowCache> copy() {
        assert (Thread.holdsLock(this.mux));
        if (this.caches == null) {
            return new HashMap<Integer, IndexRowCache>();
        }
        return new HashMap<Integer, IndexRowCache>(this.caches);
    }
}

