/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.NoSuchElementException;
import java.util.UUID;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryEntry;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScanQueryIterator<K, V, R>
extends GridCloseableIteratorAdapter<R> {
    private final IgniteBiPredicate<K, V> filter;
    private final Runnable closeFilterClo;
    protected final boolean statsEnabled;
    private final boolean keepBinary;
    private final boolean readEvt;
    private final UUID subjId;
    private final String taskName;
    private final IgniteClosure<Cache.Entry<K, V>, R> transform;
    protected final GridCacheContext<K, V> cctx;
    private final boolean locNode;
    private R next;
    private boolean needAdvance;

    protected AbstractScanQueryIterator(GridCacheContext<K, V> cctx, CacheQuery<R> qry, IgniteClosure<Cache.Entry<K, V>, R> transform, boolean locNode) throws IgniteCheckedException {
        this.cctx = cctx;
        this.locNode = locNode;
        this.closeFilterClo = qry.scanFilter() instanceof PlatformCacheEntryFilter ? () -> AbstractScanQueryIterator.closeFilter(qry.scanFilter()) : null;
        this.filter = this.prepareFilter(qry.scanFilter());
        this.transform = SecurityUtils.sandboxedProxy(cctx.kernalContext(), IgniteClosure.class, GridCacheQueryManager.injectResources(transform, cctx));
        this.statsEnabled = cctx.statisticsEnabled();
        this.readEvt = cctx.events().isRecordable(97) && cctx.gridEvents().hasListener(97);
        this.taskName = this.readEvt ? cctx.kernalContext().task().resolveTaskName(qry.taskHash()) : null;
        this.subjId = SecurityUtils.securitySubjectId(cctx);
        this.keepBinary = !locNode && this.filter == null && transform == null && !this.readEvt || qry.keepBinary();
        this.needAdvance = true;
    }

    @Override
    protected R onNext() {
        if (this.needAdvance) {
            this.next = this.advance();
        } else {
            this.needAdvance = true;
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    protected boolean onHasNext() {
        if (this.needAdvance) {
            this.next = this.advance();
            this.needAdvance = false;
        }
        return this.next != null;
    }

    @Override
    protected void onClose() {
        if (this.closeFilterClo != null) {
            this.closeFilterClo.run();
        }
    }

    protected abstract R advance();

    public R filterAndTransform(KeyCacheObject key, CacheObject val, long start) {
        if (this.statsEnabled) {
            CacheMetricsImpl metrics = this.cctx.cache().metrics0();
            metrics.onRead(true);
            metrics.addGetTimeNanos(System.nanoTime() - start);
        }
        Object key0 = CacheObjectUtils.unwrapBinaryIfNeeded(this.cctx.cacheObjectContext(), key, this.keepBinary, false);
        Object val0 = CacheObjectUtils.unwrapBinaryIfNeeded(this.cctx.cacheObjectContext(), val, this.keepBinary, false);
        if (this.filter != null) {
            try {
                if (!this.filter.apply(key0, val0)) {
                    return null;
                }
            }
            catch (Throwable e) {
                throw new IgniteException(e);
            }
        }
        if (this.readEvt) {
            this.cctx.gridEvents().record(new CacheQueryReadEvent<Object, Object>(this.cctx.localNode(), "Scan query entry read.", 97, CacheQueryType.SCAN.name(), this.cctx.name(), null, null, (IgniteBiPredicate<Object, Object>)this.filter, null, null, this.subjId, this.taskName, key0, val0, null, null));
        }
        if (this.transform != null) {
            try {
                return this.transform.apply(new CacheQueryEntry<Object, Object>(key0, val0));
            }
            catch (Throwable e) {
                throw new IgniteException(e);
            }
        }
        return (R)(!this.locNode ? new T2<Object, Object>(key0, val0) : new CacheQueryEntry<Object, Object>(key0, val0));
    }

    @Nullable
    public IgniteBiPredicate<K, V> filter() {
        return this.filter;
    }

    @Nullable
    private IgniteBiPredicate<K, V> prepareFilter(IgniteBiPredicate<K, V> keyValFilter) throws IgniteCheckedException {
        if (keyValFilter == null) {
            return null;
        }
        try {
            if (keyValFilter instanceof PlatformCacheEntryFilter) {
                ((PlatformCacheEntryFilter)keyValFilter).cacheContext(this.cctx);
            } else {
                GridCacheQueryManager.injectResources(keyValFilter, this.cctx);
            }
            return SecurityUtils.sandboxedProxy(this.cctx.kernalContext(), IgniteBiPredicate.class, keyValFilter);
        }
        catch (RuntimeException | IgniteCheckedException e) {
            AbstractScanQueryIterator.closeFilter(keyValFilter);
            throw e;
        }
    }

    public static void closeFilter(IgniteBiPredicate<?, ?> filter) {
        if (filter instanceof PlatformCacheEntryFilter) {
            ((PlatformCacheEntryFilter)filter).onClose();
        }
    }

    public IgniteClosure<Cache.Entry<K, V>, R> transformer() {
        return this.transform;
    }

    public boolean local() {
        return this.locNode;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public String taskName() {
        return this.taskName;
    }

    public GridCacheContext<K, V> cacheContext() {
        return this.cctx;
    }
}

