/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.processors.cache.persistence.file.IgniteNativeIoLib;
import org.apache.ignite.internal.util.GridUnsafe;

public class AlignedBuffers {
    public static ByteBuffer allocate(int fsBlockSize, int size) {
        assert (fsBlockSize > 0);
        assert (size > 0);
        PointerByReference refToPtr = new PointerByReference();
        int retVal = IgniteNativeIoLib.posix_memalign(refToPtr, new NativeLong((long)fsBlockSize), new NativeLong((long)size));
        if (retVal != 0) {
            throw new IgniteOutOfMemoryException("Failed to allocate memory: " + IgniteNativeIoLib.strerror(retVal));
        }
        return GridUnsafe.wrapPointer((long)Pointer.nativeValue((Pointer)refToPtr.getValue()), (int)size);
    }

    public static void free(ByteBuffer buf) {
        AlignedBuffers.free(GridUnsafe.bufferAddress((ByteBuffer)buf));
    }

    public static void free(long addr) {
        IgniteNativeIoLib.free(new Pointer(addr));
    }
}

