/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheAttributesTtlEntryExtras
extends GridCacheEntryExtrasAdapter {
    private long ttl;
    private long expireTime;

    GridCacheAttributesTtlEntryExtras(long ttl, long expireTime) {
        assert (expireTime != 0L);
        this.ttl = ttl;
        this.expireTime = expireTime;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        return mvcc != null ? new GridCacheAttributesMvccTtlEntryExtras(mvcc, this.ttl, this.expireTime) : this;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        return obsoleteVer != null ? new GridCacheAttributesObsoleteTtlEntryExtras(obsoleteVer, this.ttl, this.expireTime) : this;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        if (expireTime != 0L) {
            this.ttl = ttl;
            this.expireTime = expireTime;
            return this;
        }
        return new GridCacheAttributesEntryExtras();
    }

    @Override
    public int size() {
        return 16;
    }

    public String toString() {
        return S.toString(GridCacheAttributesTtlEntryExtras.class, this);
    }
}

