/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public abstract class GenericUDFBasePad
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter converter1;
    private transient ObjectInspectorConverters.Converter converter2;
    private transient ObjectInspectorConverters.Converter converter3;
    private Text result = new Text();
    private String udfName;
    private StringBuilder builder;

    public GenericUDFBasePad(String _udfName) {
        this.udfName = _udfName;
        this.builder = new StringBuilder();
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 3) {
            throw new UDFArgumentException(this.udfName + " requires three arguments. Found :" + arguments.length);
        }
        this.converter1 = this.checkTextArguments(arguments, 0);
        this.converter2 = this.checkIntArguments(arguments, 1);
        this.converter3 = this.checkTextArguments(arguments, 2);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject1 = arguments[0].get();
        Object valObject2 = arguments[1].get();
        Object valObject3 = arguments[2].get();
        if (valObject1 == null || valObject2 == null || valObject3 == null) {
            return null;
        }
        Text str = (Text)this.converter1.convert(valObject1);
        IntWritable lenW = (IntWritable)this.converter2.convert(valObject2);
        Text pad = (Text)this.converter3.convert(valObject3);
        if (str == null || pad == null || lenW == null || pad.toString().isEmpty()) {
            return null;
        }
        int len = lenW.get();
        this.builder.setLength(0);
        this.performOp(this.builder, len, str.toString(), pad.toString());
        this.result.set(this.builder.toString());
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.udfName, children);
    }

    protected abstract void performOp(StringBuilder var1, int var2, String var3, String var4);

    private ObjectInspectorConverters.Converter checkTextArguments(ObjectInspector[] arguments, int i) throws UDFArgumentException {
        if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(i, "Only primitive type arguments are accepted but " + arguments[i].getTypeName() + " is passed.");
        }
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[i]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        return converter;
    }

    private ObjectInspectorConverters.Converter checkIntArguments(ObjectInspector[] arguments, int i) throws UDFArgumentException {
        if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(i, "Only primitive type arguments are accepted but " + arguments[i].getTypeName() + " is passed.");
        }
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
        return switch (inputType) {
            case PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.BYTE -> ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[i]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
            default -> throw new UDFArgumentTypeException(i + 1, this.udfName + " only takes INT/SHORT/BYTE types as " + (i + 1) + "-ths argument, got " + String.valueOf(inputType));
        };
    }
}

